/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.agroal.spi.JdbcInitialSQLGeneratorBuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.dev.config.CurrentConfig;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.devconsole.runtime.spi.DevConsolePostHandler;
import io.quarkus.devconsole.spi.DevConsoleRouteBuildItem;
import io.quarkus.devconsole.spi.DevConsoleRuntimeTemplateInfoBuildItem;
import io.quarkus.flyway.FlywayProcessor;
import io.quarkus.flyway.runtime.FlywayBuildTimeConfig;
import io.quarkus.flyway.runtime.FlywayContainersSupplier;
import io.quarkus.flyway.runtime.FlywayDataSourceBuildTimeConfig;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.ConfigProvider;

public class FlywayDevConsoleProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    public DevConsoleRuntimeTemplateInfoBuildItem collectBeanInfo(FlywayProcessor.MigrationStateBuildItem migrationStateBuildItem) {
        return new DevConsoleRuntimeTemplateInfoBuildItem("containers", (Supplier)new FlywayContainersSupplier());
    }

    @BuildStep
    DevConsoleRouteBuildItem invokeEndpoint(final List<JdbcInitialSQLGeneratorBuildItem> generatorBuildItem, final FlywayBuildTimeConfig buildTimeConfig, final CurateOutcomeBuildItem curateOutcomeBuildItem) {
        return new DevConsoleRouteBuildItem("create-initial-migration", "POST", (Handler)new DevConsolePostHandler(){

            protected void handlePostAsync(RoutingContext event, MultiMap form) throws Exception {
                String name = form.get("datasource");
                JdbcInitialSQLGeneratorBuildItem found = null;
                for (JdbcInitialSQLGeneratorBuildItem i : generatorBuildItem) {
                    if (!i.getDatabaseName().equals(name)) continue;
                    found = i;
                    break;
                }
                if (found == null) {
                    this.flashMessage(event, "Unable to find SQL generator");
                    return;
                }
                FlywayDataSourceBuildTimeConfig config = buildTimeConfig.getConfigForDataSourceName(name);
                if (config.locations.isEmpty()) {
                    this.flashMessage(event, "Datasource has no locations configured");
                    return;
                }
                System.out.println((String)found.getSqlSupplier().get());
                List resourcesDir = DevConsoleManager.getHotReplacementContext().getResourcesDir();
                if (resourcesDir.isEmpty()) {
                    this.flashMessage(event, "No resource directory found");
                    return;
                }
                Path path = (Path)resourcesDir.get(0);
                Path migrationDir = path.resolve((String)config.locations.get(0));
                Files.createDirectories(migrationDir, new FileAttribute[0]);
                Path file = migrationDir.resolve("V1.0.0__" + curateOutcomeBuildItem.getEffectiveModel().getAppArtifact().getArtifactId() + ".sql");
                Files.writeString(file, (CharSequence)found.getSqlSupplier().get(), new OpenOption[0]);
                this.flashMessage(event, file + " was created");
                HashMap<Object, String> newConfig = new HashMap<Object, String>();
                if (ConfigProvider.getConfig().getOptionalValue("quarkus.flyway.baseline-on-migrate", String.class).isEmpty()) {
                    newConfig.put("quarkus.flyway.baseline-on-migrate", "true");
                }
                if (ConfigProvider.getConfig().getOptionalValue("quarkus.flyway.migrate-at-start", String.class).isEmpty()) {
                    newConfig.put("quarkus.flyway.migrate-at-start", "true");
                }
                for (String profile : List.of("test", "dev")) {
                    if (!ConfigProvider.getConfig().getOptionalValue("quarkus.flyway.clean-at-start", String.class).isEmpty()) continue;
                    newConfig.put("%" + profile + ".quarkus.flyway.clean-at-start", "true");
                }
                CurrentConfig.EDITOR.accept(newConfig);
                DevConsoleManager.getHotReplacementContext().doScan(true);
                this.flashMessage(event, "Initial migration created, Flyway will now manage this datasource");
                event.response().setStatusCode(HttpResponseStatus.SEE_OTHER.code()).headers().set((CharSequence)HttpHeaderNames.LOCATION, (CharSequence)event.request().absoluteURI().replace("create-initial-migration", "datasources"));
                event.response().end();
            }
        });
    }
}

