/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.remotedev;

import java.io.DataOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;

public abstract class QuarkusWebsocketProtocol
extends Endpoint
implements MessageHandler.Whole<byte[]> {
    private static final int CLASS_CHANGE_RESPONSE = 2;
    private static final int CLASS_CHANGE_REQUEST = 1;
    private volatile Session session;

    protected abstract Map<String, byte[]> changedSrcs();

    protected abstract Map<String, byte[]> changedWebResources();

    protected abstract void logMessage(String var1);

    protected abstract void error(Throwable var1);

    protected abstract void done();

    public void onOpen(Session session, EndpointConfig endpointConfig) {
        this.logMessage("Connected to remote server");
        session.addMessageHandler((MessageHandler)this);
        this.session = session;
    }

    public void onClose(Session session, CloseReason closeReason) {
        this.logMessage("Connection closed " + closeReason);
        this.done();
    }

    public void onError(Session session, Throwable thr) {
        this.error(thr);
    }

    public void onMessage(byte[] bytes) {
        switch (bytes[0]) {
            case 1: {
                this.logMessage("Scanning for changed classes");
                String filePathSeparator = new String(bytes, 1, bytes.length - 1, StandardCharsets.UTF_8);
                this.sendChangedClasses(filePathSeparator);
                break;
            }
            default: {
                this.logMessage("Ignoring unknown message type " + bytes[0]);
            }
        }
    }

    private void sendChangedClasses(String remoteFilePathSeparator) {
        Map<String, byte[]> changedSrcs = this.changedSrcs();
        Map<String, byte[]> changedResources = this.changedWebResources();
        this.logMessage("Scan complete changed srcs " + changedSrcs.keySet() + " changes resources " + changedResources);
        boolean filePathSeparatorsDiffer = !File.separator.equals(remoteFilePathSeparator);
        try (OutputStream out = this.session.getBasicRemote().getSendStream();){
            String path;
            out.write(2);
            DataOutputStream data = new DataOutputStream(new DeflaterOutputStream(out));
            data.writeInt(changedSrcs.size());
            for (Map.Entry<String, byte[]> entry : changedSrcs.entrySet()) {
                path = entry.getKey();
                if (filePathSeparatorsDiffer) {
                    path = path.replace(File.separator, remoteFilePathSeparator);
                }
                data.writeUTF(path);
                data.writeInt(entry.getValue().length);
                data.write(entry.getValue());
            }
            data.writeInt(changedResources.size());
            for (Map.Entry<String, byte[]> entry : changedResources.entrySet()) {
                path = entry.getKey();
                if (filePathSeparatorsDiffer) {
                    path = path.replace(File.separator, remoteFilePathSeparator);
                }
                data.writeUTF(path);
                data.writeInt(entry.getValue().length);
                data.write(entry.getValue());
            }
            data.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

