/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.commands;

import io.quarkus.cli.commands.QuarkusCommandException;
import io.quarkus.cli.commands.QuarkusCommandInvocation;
import io.quarkus.cli.commands.QuarkusCommandOutcome;
import io.quarkus.cli.commands.RemoveExtensionsCommandHandler;
import io.quarkus.cli.commands.file.BuildFile;
import io.quarkus.cli.commands.file.MavenBuildFile;
import io.quarkus.cli.commands.writer.ProjectWriter;
import io.quarkus.generators.BuildTool;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.platform.tools.ToolsUtils;
import java.io.IOException;
import java.util.Set;

public class RemoveExtensions {
    public static final String NAME = "remove-extensions";
    public static final String EXTENSIONS = ToolsUtils.dotJoin("quarkus", "remove-extensions", "extensions");
    public static final String OUTCOME_UPDATED = ToolsUtils.dotJoin("quarkus", "remove-extensions", "outcome", "updated");
    private final QuarkusCommandInvocation invocation;

    public RemoveExtensions(ProjectWriter writer, QuarkusPlatformDescriptor platformDescr) throws IOException {
        this(new MavenBuildFile(writer), platformDescr);
    }

    public RemoveExtensions(ProjectWriter writer, BuildTool buildTool, QuarkusPlatformDescriptor platformDescr) throws IOException {
        this(buildTool.createBuildFile(writer), platformDescr);
    }

    public RemoveExtensions(BuildFile buildFile, QuarkusPlatformDescriptor platformDescr) {
        this.invocation = new QuarkusCommandInvocation(platformDescr);
        this.invocation.setBuildFile(buildFile);
    }

    public RemoveExtensions extensions(Set<String> extensions) {
        this.invocation.setValue(EXTENSIONS, extensions);
        return this;
    }

    public QuarkusCommandOutcome execute() throws QuarkusCommandException {
        return new RemoveExtensionsCommandHandler().execute(this.invocation);
    }
}

