/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.postgresql.deployment;

import io.quarkus.datasource.deployment.spi.DevServicesDatasourceContainerConfig;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.deployment.dev.devservices.RunningContainer;
import io.quarkus.devservices.common.ContainerAddress;
import io.quarkus.devservices.common.DatasourceServiceConfigurator;

public class PostgresDatasourceServiceConfigurator
implements DatasourceServiceConfigurator {
    private static final String[] USERNAME_ENVS = new String[]{"POSTGRES_USER", "POSTGRESQL_USER", "POSTGRESQL_USERNAME"};
    private static final String[] PASSWORD_ENVS = new String[]{"POSTGRES_PASSWORD", "POSTGRESQL_PASSWORD"};
    private static final String[] DATABASE_ENVS = new String[]{"POSTGRES_DB", "POSTGRESQL_DB", "POSTGRESQL_DATABASE"};

    public DevServicesDatasourceProvider.RunningDevServicesDatasource composeRunningService(ContainerAddress containerAddress, DevServicesDatasourceContainerConfig containerConfig) {
        RunningContainer container = containerAddress.getRunningContainer();
        String effectiveDbName = containerConfig.getDbName().orElse("quarkus");
        String effectiveUsername = containerConfig.getDbName().orElse("quarkus");
        String effectivePassword = containerConfig.getDbName().orElse("quarkus");
        String jdbcUrl = this.getJdbcUrl(containerAddress, container.tryGetEnv(DATABASE_ENVS).orElse(effectiveDbName));
        String reactiveUrl = this.getReactiveUrl(jdbcUrl);
        return new DevServicesDatasourceProvider.RunningDevServicesDatasource(containerAddress.getId(), jdbcUrl, reactiveUrl, container.tryGetEnv(USERNAME_ENVS).orElse(effectiveUsername), this.extractPassword(container, effectivePassword), null);
    }

    private String extractPassword(RunningContainer container, String effectivePassword) {
        if ("trust".equals(container.env().get("POSTGRES_HOST_AUTH_METHOD"))) {
            return null;
        }
        if (container.env().containsKey("ALLOW_EMPTY_PASSWORD")) {
            return "";
        }
        return container.tryGetEnv(PASSWORD_ENVS).orElse(effectivePassword);
    }

    public String getJdbcPrefix() {
        return "postgresql";
    }
}

