/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.common;

import java.util.Collections;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.utility.Base58;

public final class ConfigureUtil {
    private ConfigureUtil() {
    }

    public static String configureSharedNetwork(GenericContainer<?> container, String hostNamePrefix) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl.getName().contains("Deployment")) {
            try {
                Class<?> networkClass = tccl.getParent().loadClass("org.testcontainers.containers.Network");
                Object sharedNetwork = networkClass.getField("SHARED").get(null);
                container.setNetwork((Network)sharedNetwork);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to obtain SHARED network from testcontainers", e);
            }
        } else {
            container.setNetwork(Network.SHARED);
        }
        String hostName = hostNamePrefix + "-" + Base58.randomString((int)5);
        container.setNetworkAliases(Collections.singletonList(hostName));
        return hostName;
    }
}

