/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.jar;

import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.MainClassBuildItem;
import io.quarkus.deployment.builditem.TransformedClassesBuildItem;
import io.quarkus.deployment.jvm.ResolvedJVMRequirements;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.UberJarIgnoredResourceBuildItem;
import io.quarkus.deployment.pkg.builditem.UberJarMergedResourceBuildItem;
import io.quarkus.deployment.pkg.jar.AbstractJarBuilder;
import io.quarkus.deployment.pkg.jar.ArchiveCreator;
import io.quarkus.deployment.pkg.jar.ParallelCommonsCompressArchiveCreator;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.maven.dependency.ResolvedDependencyBuilder;
import io.quarkus.paths.OpenPathTree;
import io.quarkus.sbom.ApplicationComponent;
import io.quarkus.sbom.ApplicationManifestConfig;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class UberJarBuilder
extends AbstractJarBuilder<JarBuildItem> {
    private static final Logger LOG = Logger.getLogger(UberJarBuilder.class);
    private static final Predicate<String> UBER_JAR_IGNORED_ENTRIES_PREDICATE = new IsEntryIgnoredForUberJarPredicate();
    private static final Predicate<String> UBER_JAR_IGNORED_DUPLICATE_ENTRIES_PREDICATE = new IsDuplicateEntryIgnoredForUberJarPredicate();
    private static final Predicate<String> UBER_JAR_CONCATENATED_ENTRIES_PREDICATE = new Predicate<String>(){

        @Override
        public boolean test(String path) {
            return "META-INF/io.netty.versions.properties".equals(path) || path.startsWith("META-INF/services/") && path.length() > 18 || "META-INF/sisu/javax.inject.Named".equals(path);
        }
    };
    private final List<UberJarMergedResourceBuildItem> mergedResources;
    private final List<UberJarIgnoredResourceBuildItem> ignoredResources;

    public UberJarBuilder(CurateOutcomeBuildItem curateOutcome, OutputTargetBuildItem outputTarget, ApplicationInfoBuildItem applicationInfo, PackageConfig packageConfig, MainClassBuildItem mainClass, ApplicationArchivesBuildItem applicationArchives, TransformedClassesBuildItem transformedClasses, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedResourceBuildItem> generatedResources, Set<ArtifactKey> removedArtifactKeys, List<UberJarMergedResourceBuildItem> mergedResources, List<UberJarIgnoredResourceBuildItem> ignoredResources, ExecutorService executorService, ResolvedJVMRequirements jvmRequirements) {
        super(curateOutcome, outputTarget, applicationInfo, packageConfig, mainClass, applicationArchives, transformedClasses, generatedClasses, generatedResources, removedArtifactKeys, executorService, jvmRequirements);
        this.mergedResources = mergedResources;
        this.ignoredResources = ignoredResources;
    }

    @Override
    public JarBuildItem build() throws IOException {
        Path standardJar;
        Path tmpRunnerJar;
        Path runnerJar = this.outputTarget.getOutputDirectory().resolve(this.outputTarget.getBaseName() + this.packageConfig.computedRunnerSuffix() + ".jar");
        if (Files.exists(runnerJar, new LinkOption[0])) {
            tmpRunnerJar = this.outputTarget.getOutputDirectory().resolve(this.outputTarget.getBaseName() + this.packageConfig.computedRunnerSuffix() + ".tmp");
            Files.deleteIfExists(tmpRunnerJar);
        } else {
            tmpRunnerJar = runnerJar;
        }
        this.buildUberJar0(tmpRunnerJar);
        if (tmpRunnerJar != runnerJar) {
            Files.copy(tmpRunnerJar, runnerJar, StandardCopyOption.REPLACE_EXISTING);
            tmpRunnerJar.toFile().deleteOnExit();
        }
        Path originalJar = Files.exists(standardJar = this.outputTarget.getOutputDirectory().resolve(this.outputTarget.getOriginalBaseName() + ".jar"), new LinkOption[0]) ? standardJar : null;
        ResolvedDependency appArtifact = this.curateOutcome.getApplicationModel().getAppArtifact();
        String classifier = UberJarBuilder.suffixToClassifier(this.packageConfig.computedRunnerSuffix());
        if (classifier != null && !classifier.isEmpty()) {
            appArtifact = ((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setGroupId(appArtifact.getGroupId())).setArtifactId(appArtifact.getArtifactId())).setClassifier(classifier)).setType(appArtifact.getType())).setVersion(appArtifact.getVersion())).setResolvedPaths(appArtifact.getResolvedPaths()).addDependencies(appArtifact.getDependencies()).setWorkspaceModule(appArtifact.getWorkspaceModule()).setFlags(appArtifact.getFlags())).build();
        }
        ApplicationManifestConfig manifestConfig = ApplicationManifestConfig.builder().setMainComponent(ApplicationComponent.builder().setPath(runnerJar).setResolvedDependency(appArtifact).build()).setRunnerPath(runnerJar).addComponents(this.curateOutcome.getApplicationModel().getDependencies()).build();
        return new JarBuildItem(runnerJar, originalJar, null, PackageConfig.JarConfig.JarType.UBER_JAR, UberJarBuilder.suffixToClassifier(this.packageConfig.computedRunnerSuffix()), manifestConfig);
    }

    private void buildUberJar0(Path runnerJar) throws IOException {
        try (ParallelCommonsCompressArchiveCreator archiveCreator = new ParallelCommonsCompressArchiveCreator(runnerJar, this.packageConfig.jar().compress(), this.packageConfig.outputTimestamp().orElse(null), this.outputTarget.getOutputDirectory(), this.executorService);){
            LOG.info((Object)("Building uber jar: " + String.valueOf(runnerJar)));
            HashMap<String, Set<Dependency>> duplicateCatcher = new HashMap<String, Set<Dependency>>();
            HashMap<String, List<byte[]>> concatenatedEntries = new HashMap<String, List<byte[]>>();
            Set<String> mergeResourcePaths = this.mergedResources.stream().map(UberJarMergedResourceBuildItem::getPath).collect(Collectors.toSet());
            Predicate<String> allIgnoredEntriesPredicate = this.getIgnoredEntriesPredicate();
            ResolvedDependency appArtifact = this.curateOutcome.getApplicationModel().getAppArtifact();
            UberJarBuilder.generateManifest(archiveCreator, "", this.packageConfig, appArtifact, this.jvmRequirements, this.mainClass.getClassName(), this.applicationInfo);
            HashSet<String> existingEntries = new HashSet<String>();
            this.generatedResources.stream().map(GeneratedResourceBuildItem::getName).forEach(existingEntries::add);
            for (ResolvedDependency appDep : this.curateOutcome.getApplicationModel().getRuntimeDependencies()) {
                if (!UberJarBuilder.includeAppDependency(appDep, this.outputTarget.getIncludedOptionalDependencies(), this.removedArtifactKeys)) continue;
                for (Path resolvedDep : appDep.getResolvedPaths()) {
                    Set<String> transformedFilesByJar = this.transformedClasses.getTransformedFilesByJar().get(resolvedDep);
                    if (transformedFilesByJar == null) continue;
                    existingEntries.addAll(transformedFilesByJar);
                }
                this.walkFileDependencyForDependency(archiveCreator, duplicateCatcher, concatenatedEntries, allIgnoredEntriesPredicate, appDep, existingEntries, mergeResourcePaths);
            }
            HashMap<Set, List> explained = new HashMap<Set, List>();
            for (Map.Entry entry : duplicateCatcher.entrySet()) {
                if (((Set)entry.getValue()).size() <= 1) continue;
                explained.computeIfAbsent((Set)entry.getValue(), k -> new ArrayList()).add((String)entry.getKey());
            }
            if (!explained.isEmpty()) {
                for (Map.Entry entry : explained.entrySet()) {
                    StringBuilder msg = new StringBuilder().append("Dependencies:");
                    for (Dependency dep : (Set)entry.getKey()) {
                        msg.append(System.lineSeparator()).append("- ").append(dep.toCompactCoords());
                    }
                    msg.append(System.lineSeparator()).append("contain duplicate files:");
                    for (String path : (List)entry.getValue()) {
                        msg.append(System.lineSeparator()).append("- ").append(path);
                    }
                    LOG.warn((Object)msg);
                }
            }
            this.copyCommonContent(archiveCreator, concatenatedEntries, allIgnoredEntriesPredicate);
            if (archiveCreator.isMultiVersion()) {
                LOG.debug((Object)"Uber jar will be marked as multi-release jar");
                archiveCreator.makeMultiVersion();
            }
        }
        runnerJar.toFile().setReadable(true, false);
    }

    private Predicate<String> getIgnoredEntriesPredicate() {
        if (this.packageConfig.jar().userConfiguredIgnoredEntries().isEmpty() && this.ignoredResources.isEmpty()) {
            return UBER_JAR_IGNORED_ENTRIES_PREDICATE;
        }
        List userIgnoredEntries = this.packageConfig.jar().userConfiguredIgnoredEntries().orElse(List.of());
        HashSet ignoredEntries = new HashSet(userIgnoredEntries.size() + this.ignoredResources.size());
        ignoredEntries.addAll(userIgnoredEntries);
        for (UberJarIgnoredResourceBuildItem ignoredResource : this.ignoredResources) {
            ignoredEntries.add(ignoredResource.getPath());
        }
        return path -> UBER_JAR_IGNORED_ENTRIES_PREDICATE.test((String)path) || ignoredEntries.contains(path);
    }

    private void walkFileDependencyForDependency(ArchiveCreator archiveCreator, Map<String, Set<Dependency>> duplicateCatcher, Map<String, List<byte[]>> concatenatedEntries, Predicate<String> ignoredEntriesPredicate, ResolvedDependency appDep, Set<String> existingEntries, Set<String> mergeResourcePaths) throws IOException {
        try (OpenPathTree pathTree = appDep.getContentTree().open();){
            pathTree.walk(visit -> {
                try {
                    String relativePath = visit.getRelativePath();
                    if (Files.isDirectory(visit.getPath(), new LinkOption[0])) {
                        if (!relativePath.isEmpty()) {
                            archiveCreator.addDirectory(relativePath);
                        }
                        return;
                    }
                    Path file = visit.getPath();
                    if (UberJarBuilder.isBlockOrSF(relativePath) && relativePath.startsWith("META-INF/") && relativePath.indexOf(47, "META-INF/".length()) < 0) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Signature file " + String.valueOf(file.toAbsolutePath()) + " from app dependency " + String.valueOf(appDep) + " will not be included in uberjar"));
                        }
                        return;
                    }
                    if (!existingEntries.contains(relativePath)) {
                        if (UBER_JAR_CONCATENATED_ENTRIES_PREDICATE.test(relativePath) || mergeResourcePaths.contains(relativePath)) {
                            concatenatedEntries.computeIfAbsent(relativePath, u -> new ArrayList()).add(Files.readAllBytes(file));
                        } else if (!ignoredEntriesPredicate.test(relativePath)) {
                            if (!UBER_JAR_IGNORED_DUPLICATE_ENTRIES_PREDICATE.test(relativePath)) {
                                duplicateCatcher.computeIfAbsent(relativePath, a -> new HashSet()).add(appDep);
                            }
                            archiveCreator.addFileIfNotExists(file, relativePath, appDep.toString());
                        }
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private static boolean isBlockOrSF(String s) {
        if (s == null) {
            return false;
        }
        return s.endsWith(".SF") || s.endsWith(".DSA") || s.endsWith(".RSA") || s.endsWith(".EC");
    }

    private static class IsEntryIgnoredForUberJarPredicate
    implements Predicate<String> {
        private static final Set<String> UBER_JAR_IGNORED_ENTRIES = Set.of("META-INF/INDEX.LIST", "META-INF/MANIFEST.MF", "module-info.class", "META-INF/LICENSE", "META-INF/LICENSE.txt", "META-INF/LICENSE.md", "META-INF/LGPL-3.0.txt", "META-INF/ASL-2.0.txt", "META-INF/NOTICE", "META-INF/NOTICE.txt", "META-INF/NOTICE.md", "META-INF/README", "META-INF/README.txt", "META-INF/README.md", "META-INF/DEPENDENCIES", "META-INF/DEPENDENCIES.txt", "META-INF/beans.xml", "META-INF/quarkus-config-roots.list", "META-INF/quarkus-javadoc.properties", "META-INF/quarkus-extension.properties", "META-INF/quarkus-extension.json", "META-INF/quarkus-extension.yaml", "META-INF/quarkus-deployment-dependency.graph", "META-INF/jandex.idx", "META-INF/panache-archive.marker", "META-INF/build.metadata", "META-INF/quarkus-config-doc/quarkus-config-javadoc.json", "META-INF/quarkus-config-doc/quarkus-config-model-version", "META-INF/quarkus-config-doc/quarkus-config-model.json", "LICENSE");

        private IsEntryIgnoredForUberJarPredicate() {
        }

        @Override
        public boolean test(String path) {
            return UBER_JAR_IGNORED_ENTRIES.contains(path) || path.endsWith("module-info.class");
        }
    }

    private static class IsDuplicateEntryIgnoredForUberJarPredicate
    implements Predicate<String> {
        private IsDuplicateEntryIgnoredForUberJarPredicate() {
        }

        @Override
        public boolean test(String path) {
            return path.startsWith("META-INF/maven/");
        }
    }
}

