/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.jar;

import io.quarkus.maven.dependency.ResolvedDependency;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class FastJarFormat {
    public static final String QUARKUS_RUN_JAR = "quarkus-run.jar";
    public static final String DEFAULT_FAST_JAR_DIRECTORY_NAME = "quarkus-app";
    public static final String BOOT_LIB = "boot";
    public static final String LIB = "lib";
    public static final String MAIN = "main";
    public static final String APP = "app";
    public static final String DEPLOYMENT_LIB = "deployment";
    public static final String QUARKUS = "quarkus";
    public static final String QUARKUS_APP_DEPS = "quarkus-app-dependencies.txt";
    public static final String DEPLOYMENT_CLASS_PATH_DAT = "deployment-class-path.dat";
    public static final String BUILD_SYSTEM_PROPERTIES = "build-system.properties";
    public static final String APPMODEL_DAT = "appmodel.dat";
    static final String GENERATED_BYTECODE_JAR = "generated-bytecode.jar";
    static final String TRANSFORMED_BYTECODE_JAR = "transformed-bytecode.jar";

    public static String getJarFileName(ResolvedDependency dep, Path resolvedPath) {
        boolean isDirectory = Files.isDirectory(resolvedPath, new LinkOption[0]);
        if (!isDirectory) {
            return dep.getGroupId() + "." + String.valueOf(resolvedPath.getFileName());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(dep.getGroupId()).append(".").append(dep.getArtifactId()).append("-");
        if (!dep.getClassifier().isEmpty()) {
            sb.append(dep.getClassifier()).append("-");
        }
        return sb.append(dep.getVersion()).append(".").append(dep.getType()).toString();
    }
}

