/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.BootstrapModelBuilderFactory;
import io.quarkus.bootstrap.resolver.maven.BootstrapModelResolver;
import io.quarkus.bootstrap.resolver.maven.EffectiveModelResolver;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelCache;
import org.apache.maven.model.resolution.ModelResolver;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;

class DefaultEffectiveModelResolver
implements EffectiveModelResolver {
    private final MavenArtifactResolver resolver;
    private final ModelBuilder modelBuilder;
    private final ModelCache modelCache;
    private final Map<ArtifactCoords, Model> effectiveModels = new HashMap<ArtifactCoords, Model>();

    DefaultEffectiveModelResolver(MavenArtifactResolver resolver) {
        this.resolver = resolver;
        try {
            this.modelCache = new BootstrapModelCache(resolver.getMavenContext().getRepositorySystemSession());
        }
        catch (BootstrapMavenException e) {
            throw new RuntimeException("Failed to initialize Maven model resolver", (Throwable)((Object)e));
        }
        this.modelBuilder = BootstrapModelBuilderFactory.getDefaultModelBuilder();
    }

    @Override
    public Model resolveEffectiveModel(ArtifactCoords coords) {
        return this.resolveEffectiveModel(coords, List.of());
    }

    @Override
    public Model resolveEffectiveModel(ArtifactCoords coords, List<RemoteRepository> repos) {
        BootstrapModelResolver modelResolver;
        Model rawModel;
        File pomFile;
        LocalProject project;
        Model cached;
        if (!"pom".equals(coords.getType())) {
            coords = ArtifactCoords.pom((String)coords.getGroupId(), (String)coords.getArtifactId(), (String)coords.getVersion());
        }
        if ((cached = this.effectiveModels.get(coords)) != null) {
            return cached;
        }
        LocalWorkspace ws = this.resolver.getMavenContext().getWorkspace();
        if (ws != null && (project = ws.getProject(coords.getGroupId(), coords.getArtifactId())) != null && coords.getVersion().equals(project.getVersion()) && project.getModelBuildingResult() != null) {
            return project.getModelBuildingResult().getEffectiveModel();
        }
        try {
            ArtifactResult pomResult = this.resolver.resolve((Artifact)new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType(), coords.getVersion()), repos);
            pomFile = pomResult.getArtifact().getFile();
        }
        catch (BootstrapMavenException e) {
            throw new RuntimeException("Failed to resolve " + coords.toCompactCoords(), (Throwable)((Object)e));
        }
        try {
            rawModel = ModelUtils.readModel(pomFile.toPath());
        }
        catch (IOException e1) {
            throw new RuntimeException("Failed to read " + String.valueOf(pomFile), e1);
        }
        try {
            modelResolver = BootstrapModelResolver.newInstance(this.resolver.getMavenContext(), null);
        }
        catch (BootstrapMavenException e) {
            throw new RuntimeException("Failed to initialize model resolver", (Throwable)((Object)e));
        }
        Parent parent = rawModel.getParent();
        if (parent != null) {
            Path parentPomPath;
            ArtifactResult parentResult;
            DefaultArtifact parentPom = new DefaultArtifact(parent.getGroupId(), parent.getArtifactId(), "pom", parent.getVersion());
            try {
                parentResult = this.resolver.resolve((Artifact)parentPom, repos);
                parentPomPath = parentResult.getArtifact().getFile().toPath();
            }
            catch (BootstrapMavenException e) {
                throw new RuntimeException("Failed to resolve " + String.valueOf(parentPom), (Throwable)((Object)e));
            }
            rawModel.getParent().setRelativePath(pomFile.toPath().getParent().relativize(parentPomPath).toString());
            String repoUrl = null;
            for (RemoteRepository remoteRepository : repos) {
                if (!remoteRepository.getId().equals(parentResult.getRepository().getId())) continue;
                repoUrl = remoteRepository.getUrl();
                break;
            }
            if (repoUrl != null) {
                Repository modelRepo = null;
                for (Repository r : rawModel.getRepositories()) {
                    if (!r.getId().equals(parentResult.getRepository().getId())) continue;
                    modelRepo = r;
                    break;
                }
                if (modelRepo == null) {
                    modelRepo = new Repository();
                    modelRepo.setId(parentResult.getRepository().getId());
                    modelRepo.setLayout("default");
                    modelRepo.setReleases(new RepositoryPolicy());
                }
                modelRepo.setUrl(repoUrl);
                try {
                    modelResolver.addRepository(modelRepo, false);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Failed to add repository " + String.valueOf(modelRepo), exception);
                }
            }
        }
        DefaultModelBuildingRequest req = new DefaultModelBuildingRequest();
        req.setPomFile(pomFile);
        req.setRawModel(rawModel);
        req.setModelResolver((ModelResolver)modelResolver);
        req.setSystemProperties(System.getProperties());
        req.setUserProperties(System.getProperties());
        req.setModelCache(this.modelCache);
        try {
            return this.modelBuilder.build((ModelBuildingRequest)req).getEffectiveModel();
        }
        catch (ModelBuildingException e) {
            throw new RuntimeException("Failed to resolve the effective model of " + coords.toCompactCoords(), e);
        }
    }

    static class BootstrapModelCache
    implements ModelCache {
        private final RepositorySystemSession session;
        private final RepositoryCache cache;

        BootstrapModelCache(RepositorySystemSession session) {
            this.session = session;
            this.cache = session.getCache() == null ? new DefaultRepositoryCache() : session.getCache();
        }

        public Object get(String groupId, String artifactId, String version, String tag) {
            return this.cache.get(this.session, (Object)new Key(groupId, artifactId, version, tag));
        }

        public void put(String groupId, String artifactId, String version, String tag, Object data) {
            this.cache.put(this.session, (Object)new Key(groupId, artifactId, version, tag), data);
        }

        static class Key {
            private final String groupId;
            private final String artifactId;
            private final String version;
            private final String tag;
            private final int hash;

            public Key(String groupId, String artifactId, String version, String tag) {
                this.groupId = groupId;
                this.artifactId = artifactId;
                this.version = version;
                this.tag = tag;
                int h = 17;
                h = h * 31 + this.groupId.hashCode();
                h = h * 31 + this.artifactId.hashCode();
                h = h * 31 + this.version.hashCode();
                this.hash = h = h * 31 + this.tag.hashCode();
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (null == obj || !this.getClass().equals(obj.getClass())) {
                    return false;
                }
                Key that = (Key)obj;
                return this.artifactId.equals(that.artifactId) && this.groupId.equals(that.groupId) && this.version.equals(that.version) && this.tag.equals(that.tag);
            }

            public int hashCode() {
                return this.hash;
            }
        }
    }
}

