/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.ClassLoaderHierarchy;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.SystemClassLoaderSpec;
import org.gradle.internal.impldep.org.jspecify.annotations.Nullable;

public class ClassLoaderVisitor {
    private static final String JAVA_CLASS_PATH = "java.class.path";
    private final @Nullable ClassLoader stopAt;

    public ClassLoaderVisitor() {
        this(ClassLoader.getSystemClassLoader() == null ? null : ClassLoader.getSystemClassLoader().getParent());
    }

    public ClassLoaderVisitor(@Nullable ClassLoader stopAt) {
        this.stopAt = stopAt;
    }

    public void visit(ClassLoader classLoader) {
        if (classLoader == this.stopAt) {
            this.visitSpec(SystemClassLoaderSpec.INSTANCE);
            return;
        }
        if (classLoader instanceof ClassLoaderHierarchy) {
            ((ClassLoaderHierarchy)((Object)classLoader)).visit(this);
        } else {
            if (this.isPreJava9LauncherAppClassloader(classLoader)) {
                this.visitClassPath(this.extractPreJava9Classpath(classLoader));
            } else {
                this.visitClassPath(this.extractJava9Classpath());
            }
            if (classLoader.getParent() != null) {
                this.visitParent(classLoader.getParent());
            }
        }
    }

    private boolean isPreJava9LauncherAppClassloader(ClassLoader classLoader) {
        return classLoader instanceof URLClassLoader;
    }

    private URL[] extractPreJava9Classpath(ClassLoader classLoader) {
        return ((URLClassLoader)classLoader).getURLs();
    }

    private URL[] extractJava9Classpath() {
        String cp = System.getProperty(JAVA_CLASS_PATH);
        String[] elements = cp.split(File.pathSeparator);
        URL[] urls = new URL[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            try {
                URL url;
                urls[i] = url = new File(elements[i]).toURI().toURL();
                continue;
            }
            catch (MalformedURLException mue) {
                throw UncheckedException.throwAsUncheckedException(mue);
            }
        }
        return urls;
    }

    public void visitSpec(ClassLoaderSpec spec) {
    }

    public void visitClassPath(URL[] classPath) {
    }

    public void visitParent(ClassLoader classLoader) {
        this.visit(classLoader);
    }
}

