/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.paths;

import io.quarkus.bootstrap.model.Mappable;
import io.quarkus.bootstrap.model.MappableCollectionFactory;
import io.quarkus.util.GlobUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public class PathFilter
implements Mappable,
Serializable {
    private static final long serialVersionUID = -5712472676677054175L;
    private List<Pattern> includes;
    private List<Pattern> excludes;

    public static boolean isVisible(PathFilter filter, String path) {
        if (path == null) {
            return false;
        }
        if (filter == null) {
            return true;
        }
        return filter.isVisible(path.replace('\\', '/'));
    }

    public static PathFilter forIncludes(Collection<String> includes) {
        return new PathFilter(includes, null);
    }

    public static PathFilter forExcludes(Collection<String> excludes) {
        return new PathFilter(null, excludes);
    }

    public static PathFilter fromMap(Map<String, Object> map) {
        return new PathFilter(PathFilter.compileRegex((Collection)map.get("includes")), PathFilter.compileRegex((Collection)map.get("excludes")));
    }

    public PathFilter(Collection<String> includes, Collection<String> excludes) {
        this.includes = PathFilter.compileGlob(includes);
        this.excludes = PathFilter.compileGlob(excludes);
    }

    private PathFilter(List<Pattern> includes, List<Pattern> excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    public boolean isVisible(String pathStr) {
        if (this.includes != null && !this.includes.isEmpty()) {
            int i;
            for (i = 0; i < this.includes.size() && !this.includes.get(i).matcher(pathStr).matches(); ++i) {
            }
            if (i == this.includes.size()) {
                return false;
            }
        }
        if (this.excludes != null) {
            for (Pattern pattern : this.excludes) {
                if (!pattern.matcher(pathStr).matches()) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public Map<String, Object> asMap(MappableCollectionFactory factory) {
        Map<String, Object> result;
        if (this.includes != null && !this.includes.isEmpty()) {
            if (this.excludes != null && !this.excludes.isEmpty()) {
                result = factory.newMap(2);
                result.put("includes", Mappable.toStringCollection(this.includes, factory));
                result.put("excludes", Mappable.toStringCollection(this.excludes, factory));
            } else {
                result = factory.newMap(1);
                result.put("includes", Mappable.toStringCollection(this.includes, factory));
            }
        } else if (this.excludes != null && !this.excludes.isEmpty()) {
            result = factory.newMap(1);
            result.put("excludes", Mappable.toStringCollection(this.excludes, factory));
        } else {
            result = factory.newMap(0);
        }
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.excludes, this.includes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathFilter other = (PathFilter)obj;
        return Objects.equals(this.excludes, other.excludes) && Objects.equals(this.includes, other.includes);
    }

    public String toString() {
        int i;
        StringBuilder s = new StringBuilder();
        if (this.includes != null && !this.includes.isEmpty()) {
            s.append("includes ").append(this.includes.get(0).pattern());
            for (i = 1; i < this.includes.size(); ++i) {
                s.append(",").append(this.includes.get(i));
            }
        }
        if (this.excludes != null && !this.excludes.isEmpty()) {
            if (s.length() > 0) {
                s.append(" ");
            }
            s.append("excludes ").append(this.excludes.get(0).pattern());
            for (i = 1; i < this.excludes.size(); ++i) {
                s.append(",").append(this.excludes.get(i));
            }
        }
        return s.toString();
    }

    private static List<Pattern> compileGlob(Collection<String> expressions) {
        if (expressions == null) {
            return null;
        }
        ArrayList<Pattern> compiled = new ArrayList<Pattern>(expressions.size());
        for (String expr : expressions) {
            compiled.add(Pattern.compile(GlobUtil.toRegexPattern(expr)));
        }
        return compiled;
    }

    private static List<Pattern> compileRegex(Collection<String> regexList) {
        if (regexList == null) {
            return null;
        }
        ArrayList<Pattern> compiled = new ArrayList<Pattern>(regexList.size());
        for (String regex : regexList) {
            compiled.add(Pattern.compile(regex));
        }
        return compiled;
    }
}

