/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.arc.runtime.BeanContainerListener;
import io.quarkus.arc.runtime.LifecycleEventRunner;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class ArcRecorder {
    public static volatile Map<String, Supplier<?>> supplierMap;
    private static final Logger LOGGER;

    public ArcContainer getContainer(ShutdownContext shutdown) throws Exception {
        ArcContainer container = Arc.initialize();
        shutdown.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                Arc.shutdown();
            }
        });
        return container;
    }

    public void initExecutor(ExecutorService executor) {
        Arc.setExecutor((ExecutorService)executor);
    }

    public void initStaticSupplierBeans(Map<String, Supplier<?>> beans) {
        supplierMap = new ConcurrentHashMap(beans);
    }

    public void initRuntimeSupplierBeans(Map<String, Supplier<?>> beans) {
        supplierMap.putAll(beans);
    }

    public BeanContainer initBeanContainer(final ArcContainer container, List<BeanContainerListener> listeners, final Collection<String> removedBeanTypes) throws Exception {
        if (container == null) {
            throw new IllegalArgumentException("Arc container was null");
        }
        BeanContainer beanContainer = new BeanContainer(){

            @Override
            public <T> BeanContainer.Factory<T> instanceFactory(Class<T> type, Annotation ... qualifiers) {
                final Supplier handleSupplier = container.instanceSupplier(type, qualifiers);
                if (handleSupplier == null) {
                    if (removedBeanTypes.contains(type.getName())) {
                        LOGGER.warnf("Bean matching %s was marked as unused and removed during build.\nExtensions can eliminate false positives using:\n\t- a custom UnremovableBeanBuildItem\n\t- AdditionalBeanBuildItem(false, beanClazz)", type);
                    } else {
                        LOGGER.debugf("No matching bean found for type %s and qualifiers %s. The bean might have been marked as unused and removed during build.", type, (Object)Arrays.toString(qualifiers));
                    }
                    return new DefaultInstanceFactory(type);
                }
                return new BeanContainer.Factory<T>(){

                    @Override
                    public BeanContainer.Instance<T> create() {
                        final InstanceHandle handle = (InstanceHandle)handleSupplier.get();
                        return new BeanContainer.Instance<T>(){

                            @Override
                            public T get() {
                                return handle.get();
                            }

                            @Override
                            public void close() {
                                handle.close();
                            }
                        };
                    }
                };
            }

            @Override
            public ManagedContext requestContext() {
                return container.requestContext();
            }
        };
        for (BeanContainerListener listener : listeners) {
            listener.created(beanContainer);
        }
        return beanContainer;
    }

    public void handleLifecycleEvents(ShutdownContext context, BeanContainer beanContainer) {
        final LifecycleEventRunner instance = beanContainer.instance(LifecycleEventRunner.class, new Annotation[0]);
        instance.fireStartupEvent();
        context.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                instance.fireShutdownEvent();
            }
        });
    }

    public Supplier<Object> createSupplier(final RuntimeValue<?> value) {
        return new Supplier<Object>(){

            @Override
            public Object get() {
                return value.getValue();
            }
        };
    }

    static {
        LOGGER = Logger.getLogger((String)ArcRecorder.class.getName());
    }

    private static final class DefaultInstanceFactory<T>
    implements BeanContainer.Factory<T> {
        final Class<T> type;

        private DefaultInstanceFactory(Class<T> type) {
            this.type = type;
        }

        @Override
        public BeanContainer.Instance<T> create() {
            try {
                final T instance = this.type.newInstance();
                return new BeanContainer.Instance<T>(){

                    @Override
                    public T get() {
                        return instance;
                    }
                };
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

