/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.devconsole;

import io.quarkus.arc.deployment.CompletedApplicationClassPredicateBuildItem;
import io.quarkus.arc.deployment.devconsole.Name;
import io.quarkus.arc.processor.ObserverInfo;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;

public class DevObserverInfo
implements Comparable<DevObserverInfo> {
    private final boolean isApplicationObserver;
    private final Name declaringClass;
    private final String methodName;
    private final Name observedType;
    private List<Name> qualifiers;
    private final int priority;
    private final boolean isAsync;
    private final Reception reception;
    private final TransactionPhase transactionPhase;

    public static DevObserverInfo from(ObserverInfo observer, CompletedApplicationClassPredicateBuildItem predicate) {
        List<Name> qualifiers = observer.getQualifiers().isEmpty() ? Collections.emptyList() : observer.getQualifiers().stream().map(Name::from).collect(Collectors.toList());
        if (observer.getDeclaringBean() != null) {
            return new DevObserverInfo(predicate.test(observer.getObserverMethod().declaringClass().name()), Name.from(observer.getObserverMethod().declaringClass().name()), observer.getObserverMethod().name(), Name.from(observer.getObservedType()), qualifiers, observer.getPriority(), observer.isAsync(), observer.getReception(), observer.getTransactionPhase());
        }
        return new DevObserverInfo(false, null, null, Name.from(observer.getObservedType()), qualifiers, observer.getPriority(), observer.isAsync(), observer.getReception(), observer.getTransactionPhase());
    }

    public DevObserverInfo(boolean isApplicationObserver, Name declaringClass, String methodName, Name observedType, List<Name> qualifiers, int priority, boolean isAsync, Reception reception, TransactionPhase transactionPhase) {
        this.isApplicationObserver = isApplicationObserver;
        this.declaringClass = declaringClass;
        this.methodName = methodName;
        this.observedType = observedType;
        this.qualifiers = qualifiers;
        this.priority = priority;
        this.isAsync = isAsync;
        this.reception = reception;
        this.transactionPhase = transactionPhase;
    }

    public Name getDeclaringClass() {
        return this.declaringClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Name getObservedType() {
        return this.observedType;
    }

    public List<Name> getQualifiers() {
        return this.qualifiers;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public Reception getReception() {
        return this.reception;
    }

    public TransactionPhase getTransactionPhase() {
        return this.transactionPhase;
    }

    public boolean isApplicationObserver() {
        return this.isApplicationObserver;
    }

    @Override
    public int compareTo(DevObserverInfo other) {
        int ret = 0;
        if (this.isApplicationObserver != other.isApplicationObserver) {
            ret = this.isApplicationObserver ? -1 : 1;
        } else if (this.declaringClass == null && other.declaringClass == null) {
            ret = this.observedType.compareTo(other.observedType);
        } else {
            ret = this.declaringClass == null && other.declaringClass != null ? 1 : (this.declaringClass != null && other.declaringClass == null ? -1 : this.declaringClass.compareTo(other.declaringClass));
            if (ret == 0) {
                ret = this.methodName.compareTo(other.methodName);
            }
        }
        return ret;
    }
}

