/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.TypeKind;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Cast;
import io.quarkus.gizmo2.impl.Conversions;
import io.quarkus.gizmo2.impl.StackMapBuilder;
import io.smallrye.classfile.CodeBuilder;
import io.smallrye.classfile.Opcode;
import io.smallrye.common.constraint.Assert;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;

final class Unbox
extends Cast {
    private static ClassDesc unboxing(ClassDesc boxType) {
        ClassDesc unboxType = Conversions.unboxingConversion(boxType).orElseThrow(() -> new IllegalArgumentException("No unbox type for " + boxType.displayName()));
        if (unboxType.equals(ConstantDescs.CD_void)) {
            throw new IllegalArgumentException("Cannot unbox void");
        }
        return unboxType;
    }

    Unbox(Expr a) {
        super(a, Unbox.unboxing(a.type()), null);
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block, StackMapBuilder smb) {
        ClassDesc classDesc = this.a.type();
        cb.invoke(Opcode.INVOKEVIRTUAL, classDesc, switch (TypeKind.from(this.type())) {
            case TypeKind.BOOLEAN -> "booleanValue";
            case TypeKind.BYTE -> "byteValue";
            case TypeKind.CHAR -> "charValue";
            case TypeKind.SHORT -> "shortValue";
            case TypeKind.INT -> "intValue";
            case TypeKind.LONG -> "longValue";
            case TypeKind.FLOAT -> "floatValue";
            case TypeKind.DOUBLE -> "doubleValue";
            default -> throw Assert.impossibleSwitchCase((Object)((Object)TypeKind.from(this.type())));
        }, MethodTypeDesc.of(this.type(), new ClassDesc[0]), false);
        smb.pop();
        smb.push(this.type());
        smb.wroteCode();
    }
}

