/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.StackMapBuilder;
import io.quarkus.gizmo2.impl.Util;
import io.smallrye.classfile.CodeBuilder;
import java.lang.constant.ClassDesc;
import java.lang.constant.DynamicCallSiteDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.List;
import java.util.ListIterator;
import java.util.function.BiConsumer;

final class InvokeDynamic
extends Item {
    private final List<? extends Expr> args;
    private final DynamicCallSiteDesc callSiteDesc;

    InvokeDynamic(List<? extends Expr> args, DynamicCallSiteDesc callSiteDesc) {
        super(callSiteDesc.invocationType().returnType());
        this.args = args;
        this.callSiteDesc = callSiteDesc;
    }

    @Override
    protected void forEachDependency(ListIterator<Item> itr, BiConsumer<Item, ListIterator<Item>> op) {
        for (int i = this.args.size() - 1; i >= 0; --i) {
            ((Item)this.args.get(i)).process(itr, op);
        }
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block, StackMapBuilder smb) {
        cb.invokedynamic(this.callSiteDesc);
        MethodTypeDesc type = this.callSiteDesc.invocationType();
        for (ClassDesc classDesc : type.parameterList()) {
            smb.pop();
        }
        if (!Util.isVoid(type.returnType())) {
            smb.push(type.returnType());
        }
        smb.wroteCode();
    }
}

