/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.MemoryOrder;
import io.quarkus.gizmo2.impl.ArrayDeref;
import io.quarkus.gizmo2.impl.CompareAndSet;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.StackMapBuilder;
import io.quarkus.gizmo2.impl.constant.ConstImpl;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.util.ListIterator;
import java.util.function.BiConsumer;

final class ArrayCompareAndSet
extends CompareAndSet {
    private final Item index;
    private final Item array;

    ArrayCompareAndSet(ArrayDeref arrayDeref, Item expect, Item update, boolean weak, MemoryOrder order) {
        super(expect, update, weak, order, ConstImpl.ofArrayVarHandle(arrayDeref.type().arrayType()), MethodTypeDesc.of(ConstantDescs.CD_boolean, arrayDeref.type().arrayType(), ConstantDescs.CD_int, arrayDeref.type(), arrayDeref.type()));
        this.array = arrayDeref.array();
        this.index = arrayDeref.index();
    }

    @Override
    protected void forEachCoordinateDependency(ListIterator<Item> itr, BiConsumer<Item, ListIterator<Item>> op) {
        this.index.process(itr, op);
        this.array.process(itr, op);
    }

    @Override
    protected void popCoordinates(StackMapBuilder smb) {
        smb.pop();
        smb.pop();
    }
}

