/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.desc;

import io.quarkus.gizmo2.MethodTyped;
import io.quarkus.gizmo2.desc.ClassMethodDesc;
import io.quarkus.gizmo2.desc.InterfaceMethodDesc;
import io.quarkus.gizmo2.desc.MemberDesc;
import io.quarkus.gizmo2.impl.Util;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface MethodDesc
extends MemberDesc,
MethodTyped {
    public static MethodDesc of(Class<?> owner, String name, MethodTypeDesc type) {
        return owner.isInterface() ? InterfaceMethodDesc.of(Util.classDesc(owner), name, type) : ClassMethodDesc.of(Util.classDesc(owner), name, type);
    }

    public static MethodDesc of(Class<?> owner, String name, MethodType type) {
        return MethodDesc.of(owner, name, type.describeConstable().orElseThrow(IllegalArgumentException::new));
    }

    public static MethodDesc of(Class<?> owner, String name, Class<?> returnType, Class<?> ... paramTypes) {
        return MethodDesc.of(owner, name, returnType, Arrays.asList(paramTypes));
    }

    public static MethodDesc of(Class<?> owner, String name, Class<?> returnType, List<Class<?>> paramTypes) {
        ClassDesc[] paramDescriptors = new ClassDesc[paramTypes.size()];
        for (int i = 0; i < paramTypes.size(); ++i) {
            paramDescriptors[i] = Util.classDesc(paramTypes.get(i));
        }
        return MethodDesc.of(owner, name, MethodTypeDesc.of(Util.classDesc(returnType), paramDescriptors));
    }

    public static MethodDesc of(Method method) {
        return MethodDesc.of(method.getDeclaringClass(), method.getName(), method.getReturnType(), method.getParameterTypes());
    }
}

