/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.util.ReferenceCountUtil;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.http.server.ConnectionInfo;
import reactor.netty.http.server.HttpServerOperations;
import reactor.netty.http.server.HttpServerState;

public class HttpToH2Operations
extends HttpServerOperations {
    final Http2Headers http2Headers;

    HttpToH2Operations(Connection c, ConnectionObserver listener, HttpRequest request, Http2Headers headers, ConnectionInfo connectionInfo, ServerCookieEncoder encoder, ServerCookieDecoder decoder) {
        super(c, listener, null, request, connectionInfo, encoder, decoder);
        this.http2Headers = headers;
    }

    @Override
    protected void onInboundNext(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof Http2DataFrame) {
            Http2DataFrame data = (Http2DataFrame)msg;
            super.onInboundNext(ctx, data.content());
            if (data.isEndStream()) {
                this.onInboundComplete();
            }
            return;
        }
        if (msg instanceof Http2HeadersFrame) {
            try {
                this.listener().onStateChange(this, HttpServerState.REQUEST_RECEIVED);
            }
            catch (Exception e) {
                this.onInboundError(e);
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            if (((Http2HeadersFrame)msg).isEndStream()) {
                super.onInboundNext(ctx, msg);
            }
            return;
        }
        super.onInboundNext(ctx, msg);
    }
}

