/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.marshal;

import io.opentelemetry.exporter.internal.marshal.CodedOutputStream;
import io.opentelemetry.exporter.internal.marshal.StringEncoder;
import java.io.IOException;

final class FallbackStringEncoder
implements StringEncoder {
    FallbackStringEncoder() {
    }

    @Override
    public int getUtf8Size(String string) {
        return FallbackStringEncoder.encodedUtf8Length(string);
    }

    @Override
    public void writeUtf8(CodedOutputStream output, String string, int utf8Length) throws IOException {
        FallbackStringEncoder.encodeUtf8(output, string);
    }

    private static int encodedUtf8Length(String string) {
        int i;
        int utf16Length;
        int utf8Length = utf16Length = string.length();
        for (i = 0; i < utf16Length && string.charAt(i) < '\u0080'; ++i) {
        }
        while (i < utf16Length) {
            char c = string.charAt(i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
            } else {
                utf8Length += FallbackStringEncoder.encodedUtf8LengthGeneral(string, i);
                break;
            }
            ++i;
        }
        if (utf8Length < utf16Length) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)utf8Length + 0x100000000L));
        }
        return utf8Length;
    }

    private static int encodedUtf8LengthGeneral(String string, int start) {
        int utf16Length = string.length();
        int utf8Length = 0;
        for (int i = start; i < utf16Length; ++i) {
            char c = string.charAt(i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
                continue;
            }
            utf8Length += 2;
            if (!Character.isSurrogate(c)) continue;
            if (Character.codePointAt(string, i) != c) {
                ++i;
                continue;
            }
            utf8Length -= 2;
        }
        return utf8Length;
    }

    private static void encodeUtf8(CodedOutputStream output, String in) throws IOException {
        char c;
        int i;
        int utf16Length = in.length();
        for (i = 0; i < utf16Length && (c = in.charAt(i)) < '\u0080'; ++i) {
            output.write((byte)c);
        }
        if (i == utf16Length) {
            return;
        }
        while (i < utf16Length) {
            c = in.charAt(i);
            if (c < '\u0080') {
                output.write((byte)c);
            } else if (c < '\u0800') {
                output.write((byte)(0x3C0 | c >>> 6));
                output.write((byte)(0x80 | 0x3F & c));
            } else if (!Character.isSurrogate(c)) {
                output.write((byte)(0x1E0 | c >>> 12));
                output.write((byte)(0x80 | 0x3F & c >>> 6));
                output.write((byte)(0x80 | 0x3F & c));
            } else {
                int codePoint = Character.codePointAt(in, i);
                if (codePoint != c) {
                    output.write((byte)(0xF0 | codePoint >>> 18));
                    output.write((byte)(0x80 | 0x3F & codePoint >>> 12));
                    output.write((byte)(0x80 | 0x3F & codePoint >>> 6));
                    output.write((byte)(0x80 | 0x3F & codePoint));
                    ++i;
                } else {
                    output.write((byte)63);
                }
            }
            ++i;
        }
    }
}

