/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.basic.internal;

import io.hypersistence.utils.common.StringUtils;
import io.hypersistence.utils.hibernate.type.util.ParameterTypeUtils;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.IntegerJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.SmallIntJdbcType;
import org.hibernate.type.descriptor.jdbc.TinyIntJdbcType;
import org.hibernate.usertype.DynamicParameterizedType;
import org.hibernate.usertype.ParameterizedType;

public class NumberJdbcTypeDescriptor
implements JdbcType,
ParameterizedType {
    public static final NumberJdbcTypeDescriptor INSTANCE = new NumberJdbcTypeDescriptor();
    private volatile JdbcType jdbcTypeDescriptor;
    private volatile Properties properties;

    public NumberJdbcTypeDescriptor() {
    }

    public NumberJdbcTypeDescriptor(Properties properties) {
        this.properties = properties;
    }

    public <X> ValueBinder<X> getBinder(final JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                NumberJdbcTypeDescriptor.this.sqlTypeDescriptor().getBinder(javaType).bind(st, value, index, options);
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                NumberJdbcTypeDescriptor.this.sqlTypeDescriptor().getBinder(javaType).bind(st, value, name, options);
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return NumberJdbcTypeDescriptor.this.sqlTypeDescriptor().getExtractor(javaType).extract(rs, paramIndex, options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return NumberJdbcTypeDescriptor.this.sqlTypeDescriptor().getExtractor(javaType).extract(statement, index, options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return NumberJdbcTypeDescriptor.this.sqlTypeDescriptor().getExtractor(javaType).extract(statement, name, options);
            }
        };
    }

    private JdbcType sqlTypeDescriptor() {
        if (this.jdbcTypeDescriptor == null) {
            this.jdbcTypeDescriptor = this.resolveJdbcTypeDescriptor();
        }
        return this.jdbcTypeDescriptor;
    }

    private JdbcType resolveJdbcTypeDescriptor() {
        String columnType;
        DynamicParameterizedType.ParameterType parameterType;
        if (this.properties != null && !this.properties.isEmpty() && (parameterType = ParameterTypeUtils.resolve(this.properties)) != null && !StringUtils.isBlank(columnType = ParameterTypeUtils.getColumnType(parameterType))) {
            switch (columnType) {
                case "tinyint": {
                    return TinyIntJdbcType.INSTANCE;
                }
                case "smallint": {
                    return SmallIntJdbcType.INSTANCE;
                }
            }
        }
        return IntegerJdbcType.INSTANCE;
    }

    public int getJdbcTypeCode() {
        return this.jdbcTypeDescriptor != null ? this.jdbcTypeDescriptor.getJdbcTypeCode() : 4;
    }

    public void setParameterValues(Properties parameters) {
        if (this.properties == null) {
            this.properties = parameters;
        } else {
            this.properties.putAll((Map<?, ?>)parameters);
        }
    }
}

