/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.featuredetection.adap3d.algorithms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class SignalToNoise {
    public static double findSNUsingWaveletCoefficents(double[][] allCoefficients, double bestCoeff, int peakLeft, int peakRight, double windowSizeMult, boolean absWaveCoeffs) {
        int index;
        int peakWidth = peakRight - peakLeft;
        int leftRightWindowSize = (int)Math.round(windowSizeMult * (double)peakWidth);
        double toReturnSN = 0.0;
        int smallestScaleIndex = 0;
        double[] smallestScaleArr = allCoefficients[smallestScaleIndex];
        if (absWaveCoeffs) {
            for (int i = 0; i < smallestScaleArr.length; ++i) {
                smallestScaleArr[i] = Math.abs(smallestScaleArr[i]);
            }
        }
        ArrayList<Double> coefsUsedForSN = new ArrayList<Double>();
        for (index = peakRight + 1; index < smallestScaleArr.length && index - peakRight < leftRightWindowSize; ++index) {
            coefsUsedForSN.add(smallestScaleArr[index]);
        }
        for (index = peakLeft - 1; index > 0 && peakLeft - index < leftRightWindowSize; --index) {
            coefsUsedForSN.add(smallestScaleArr[index]);
        }
        for (index = peakLeft; index <= peakRight; ++index) {
            coefsUsedForSN.add(smallestScaleArr[index]);
        }
        double quantile = SignalToNoise.getQuantile(coefsUsedForSN, 0.95);
        toReturnSN = bestCoeff / quantile;
        return toReturnSN;
    }

    public static double getQuantile(List<Double> values, double probability) {
        int size = values.size();
        if (size <= 1 || probability <= 0.0 || probability >= 1.0) {
            throw new IllegalArgumentException("Cannot calculate quantile");
        }
        Collections.sort(values);
        int index1 = (int)((double)size * probability);
        int index2 = index1 + 1;
        double gamma = (double)(size - 1) * probability + 1.0 - (double)index1;
        return (1.0 - gamma) * values.get(index1 - 1) + gamma * values.get(index2 - 1);
    }

    public static double filterBySNRandWindowSelect(double[] intensities, int peakLeft, int peakRight) {
        int j;
        int peakWidth;
        DescriptiveStatistics stdDevStats = new DescriptiveStatistics();
        DescriptiveStatistics toFindMinWithPeakNoise = new DescriptiveStatistics();
        DescriptiveStatistics toFindLocalMean = new DescriptiveStatistics();
        for (int i = peakLeft; i < peakRight + 1; ++i) {
            stdDevStats.addValue(intensities[i]);
        }
        double peakHeight = stdDevStats.getMax();
        stdDevStats.clear();
        int sampleWindowSize = peakWidth = peakRight - peakLeft;
        int rightBound = peakRight + 10 * sampleWindowSize;
        int leftBound = peakLeft - 10 * sampleWindowSize;
        if (rightBound >= intensities.length) {
            rightBound = intensities.length - 1;
        }
        if (leftBound < 0) {
            leftBound = 0;
        }
        ArrayList<Double> forNoiseCalc = new ArrayList<Double>();
        for (j = peakRight + 1; j < rightBound + 1; ++j) {
            forNoiseCalc.add(intensities[j]);
        }
        for (j = leftBound; j < peakLeft; ++j) {
            forNoiseCalc.add(intensities[j]);
        }
        toFindMinWithPeakNoise.clear();
        DescriptiveStatistics toCollectSampleWindows = new DescriptiveStatistics();
        DescriptiveStatistics allWindowSTD = new DescriptiveStatistics();
        for (int i = 0; i < 1000; ++i) {
            int k;
            int windowStart;
            int max;
            int min;
            int j2;
            toCollectSampleWindows.clear();
            toCollectSampleWindows.clear();
            for (j2 = 0; j2 < 1; ++j2) {
                min = 0;
                max = forNoiseCalc.size() / 2 - sampleWindowSize;
                windowStart = ThreadLocalRandom.current().nextInt(min, max);
                for (k = 0; k < sampleWindowSize; ++k) {
                    toCollectSampleWindows.addValue(((Double)forNoiseCalc.get(windowStart + k)).doubleValue());
                    allWindowSTD.addValue(((Double)forNoiseCalc.get(windowStart + k)).doubleValue());
                }
            }
            for (j2 = 0; j2 < 1; ++j2) {
                min = forNoiseCalc.size() / 2;
                max = forNoiseCalc.size() - sampleWindowSize;
                windowStart = ThreadLocalRandom.current().nextInt(min, max);
                for (k = 0; k < sampleWindowSize; ++k) {
                    toCollectSampleWindows.addValue(((Double)forNoiseCalc.get(windowStart + k)).doubleValue());
                    allWindowSTD.addValue(((Double)forNoiseCalc.get(windowStart + k)).doubleValue());
                }
            }
            stdDevStats.addValue(toCollectSampleWindows.getStandardDeviation());
            double curNoPeakMean = toCollectSampleWindows.getMean();
            toFindLocalMean.addValue(curNoPeakMean);
            for (int j3 = peakLeft; j3 < peakRight + 1; ++j3) {
                toCollectSampleWindows.addValue(intensities[j3]);
            }
            double curWithPeakNoise = toCollectSampleWindows.getStandardDeviation();
            toFindMinWithPeakNoise.addValue(curWithPeakNoise);
        }
        double bestNoise = allWindowSTD.getMean();
        stdDevStats.clear();
        rightBound = peakRight + peakWidth;
        leftBound = peakLeft - peakWidth;
        if (rightBound >= intensities.length) {
            rightBound = intensities.length - 1;
        }
        if (leftBound < 0) {
            leftBound = 0;
        }
        for (int i = peakRight; i <= rightBound; ++i) {
            stdDevStats.addValue(intensities[i]);
        }
        double smallIntensity1 = stdDevStats.getMin();
        stdDevStats.clear();
        for (int i = leftBound; i <= peakLeft; ++i) {
            stdDevStats.addValue(intensities[i]);
        }
        double smallIntensity2 = stdDevStats.getMin();
        double smallIntensityAvg = (smallIntensity1 + smallIntensity2) / 2.0;
        double SNRatio = (peakHeight - smallIntensityAvg) / bestNoise;
        return SNRatio;
    }

    public static double filterBySNWindowSweep(double[] intensities, int peakLeft, int peakRight) {
        DescriptiveStatistics stdDevStats = new DescriptiveStatistics();
        DescriptiveStatistics toFindMinNoPeakNoise = new DescriptiveStatistics();
        DescriptiveStatistics toFindMinWithPeakNoise = new DescriptiveStatistics();
        DescriptiveStatistics toFindLocalMean = new DescriptiveStatistics();
        for (int i = peakLeft; i < peakRight + 1; ++i) {
            stdDevStats.addValue(intensities[i]);
        }
        double peakHeight = stdDevStats.getMax();
        stdDevStats.clear();
        int peakWidth = peakRight - peakLeft;
        int initialWindowSize = 3 * peakWidth;
        int finalWindowSize = 9 * peakWidth;
        toFindMinNoPeakNoise.clear();
        toFindMinWithPeakNoise.clear();
        for (int i = 0; i < finalWindowSize + 1; ++i) {
            int j;
            stdDevStats.clear();
            int curRight = peakRight + initialWindowSize + i;
            int curLeft = peakLeft - initialWindowSize - i;
            if (curRight >= intensities.length) {
                curRight = intensities.length - 1;
            }
            if (curLeft < 0) {
                curLeft = 0;
            }
            for (j = peakRight + 1; j < curRight + 1; ++j) {
                stdDevStats.addValue(intensities[j]);
            }
            for (j = curLeft; j < peakLeft; ++j) {
                stdDevStats.addValue(intensities[j]);
            }
            double curNoPeakNoise = stdDevStats.getStandardDeviation();
            toFindMinNoPeakNoise.addValue(curNoPeakNoise);
            double curNoPeakMean = stdDevStats.getMean();
            toFindLocalMean.addValue(curNoPeakMean);
            for (int j2 = peakLeft; j2 < peakRight + 1; ++j2) {
                stdDevStats.addValue(intensities[j2]);
            }
            double curWithPeakNoise = stdDevStats.getStandardDeviation();
            toFindMinWithPeakNoise.addValue(curWithPeakNoise);
        }
        double bestNoPeakNoise = toFindMinNoPeakNoise.getMin();
        stdDevStats.clear();
        int rightBound = peakRight + peakWidth;
        int leftBound = peakLeft - peakWidth;
        if (rightBound >= intensities.length) {
            rightBound = intensities.length - 1;
        }
        if (leftBound < 0) {
            leftBound = 0;
        }
        for (int i = peakRight; i <= rightBound; ++i) {
            stdDevStats.addValue(intensities[i]);
        }
        double smallIntensity1 = stdDevStats.getMin();
        stdDevStats.clear();
        for (int i = leftBound; i <= peakLeft; ++i) {
            stdDevStats.addValue(intensities[i]);
        }
        double smallIntensity2 = stdDevStats.getMin();
        double smallIntensityAvg = (smallIntensity1 + smallIntensity2) / 2.0;
        double SNRatio = (peakHeight - smallIntensityAvg) / bestNoPeakNoise;
        return SNRatio;
    }

    public static double filterBySNWindowInOutSweep(double[] intensities, int peakLeft, int peakRight) {
        DescriptiveStatistics stdDevStats = new DescriptiveStatistics();
        DescriptiveStatistics toFindMinNoPeakNoise = new DescriptiveStatistics();
        DescriptiveStatistics toFindMinWithPeakNoise = new DescriptiveStatistics();
        DescriptiveStatistics toFindLocalMean = new DescriptiveStatistics();
        for (int i = peakLeft; i < peakRight + 1; ++i) {
            stdDevStats.addValue(intensities[i]);
        }
        double peakHeight = stdDevStats.getMax();
        stdDevStats.clear();
        int peakWidth = peakRight - peakLeft;
        int initialWindowSize = 2 * peakWidth;
        int finalWindowSize = 8 * peakWidth;
        toFindMinNoPeakNoise.clear();
        toFindMinWithPeakNoise.clear();
        for (int i = 0; i < finalWindowSize + 1; ++i) {
            int j;
            stdDevStats.clear();
            int curRight = peakRight + initialWindowSize + i + 1;
            int curLeft = peakLeft - initialWindowSize - i - 1;
            int this_time_num_added = 0;
            if (curRight >= intensities.length) {
                curRight = intensities.length - 1;
            }
            if (curLeft < 0) {
                curLeft = 0;
            }
            if (Math.abs(curLeft - peakLeft) >= initialWindowSize) {
                for (j = curLeft; j < peakLeft; ++j) {
                    stdDevStats.addValue(intensities[j]);
                    ++this_time_num_added;
                }
            }
            if (Math.abs(curRight - peakRight) >= initialWindowSize) {
                for (j = curRight; j > peakRight; --j) {
                    stdDevStats.addValue(intensities[j]);
                    ++this_time_num_added;
                }
            }
            if (this_time_num_added == 0) continue;
            double curNoPeakNoise = stdDevStats.getStandardDeviation();
            toFindMinNoPeakNoise.addValue(curNoPeakNoise);
            double curNoPeakMean = stdDevStats.getMean();
            toFindLocalMean.addValue(curNoPeakMean);
            for (int j2 = peakLeft; j2 < peakRight + 1; ++j2) {
                stdDevStats.addValue(intensities[j2]);
            }
            double curWithPeakNoise = stdDevStats.getStandardDeviation();
            toFindMinWithPeakNoise.addValue(curWithPeakNoise);
        }
        int anchorRight = peakRight + initialWindowSize + finalWindowSize;
        int anchorLeft = peakRight - initialWindowSize - finalWindowSize;
        if (anchorRight >= intensities.length) {
            anchorRight = intensities.length - 1;
        }
        if (anchorLeft < 0) {
            anchorLeft = 0;
        }
        for (int i = 0; i < finalWindowSize - initialWindowSize; ++i) {
            stdDevStats.clear();
            int curRight = peakRight + 1 + i;
            int curLeft = peakLeft - 1 - i;
            int this_time_num_added = 0;
            if (curRight >= intensities.length) {
                curRight = intensities.length - 1;
            }
            if (curLeft < 0) {
                curLeft = 0;
            }
            if (Math.abs(curLeft - anchorLeft) >= initialWindowSize) {
                for (int j = curLeft; j > anchorLeft; --j) {
                    stdDevStats.addValue(intensities[j]);
                    ++this_time_num_added;
                }
            }
            if (Math.abs(curRight - anchorRight) >= initialWindowSize) {
                for (int j = curRight; j < anchorRight; ++j) {
                    stdDevStats.addValue(intensities[j]);
                    ++this_time_num_added;
                }
            }
            if (this_time_num_added == 0) continue;
            double curNoPeakNoise = stdDevStats.getStandardDeviation();
            toFindMinNoPeakNoise.addValue(curNoPeakNoise);
        }
        double bestNoPeakNoise = toFindMinNoPeakNoise.getMin();
        stdDevStats.clear();
        int rightBound = peakRight + peakWidth;
        int leftBound = peakLeft - peakWidth;
        if (rightBound >= intensities.length) {
            rightBound = intensities.length - 1;
        }
        if (leftBound < 0) {
            leftBound = 0;
        }
        for (int i = peakRight; i <= rightBound; ++i) {
            stdDevStats.addValue(intensities[i]);
        }
        double smallIntensity1 = stdDevStats.getMin();
        stdDevStats.clear();
        for (int i = leftBound; i <= peakLeft; ++i) {
            stdDevStats.addValue(intensities[i]);
        }
        double smallIntensity2 = stdDevStats.getMin();
        double smallIntensityAvg = (smallIntensity1 + smallIntensity2) / 2.0;
        double SNRatio = (peakHeight - smallIntensityAvg) / bestNoPeakNoise;
        return SNRatio;
    }

    public static double filterBySNStaticWindowSweep(double[] intensities, int peakLeft, int peakRight) {
        DescriptiveStatistics stdDevStats = new DescriptiveStatistics();
        DescriptiveStatistics toFindMinNoPeakNoise = new DescriptiveStatistics();
        for (int i = peakLeft; i < peakRight + 1; ++i) {
            stdDevStats.addValue(intensities[i]);
        }
        double peakHeight = stdDevStats.getMax();
        stdDevStats.clear();
        int peakWidth = peakRight - peakLeft;
        int windowSize = 2 * peakWidth;
        int furthestPoint = 8 * peakWidth;
        int finalCurLeft = 0;
        int finalCurRight = 0;
        boolean stop_sliding_right = false;
        boolean stop_sliding_left = false;
        for (int i = 0; i < furthestPoint - windowSize; ++i) {
            int j;
            int curLeft;
            int curLeftLeft;
            stdDevStats.clear();
            int curRight = peakRight + i;
            int curRightRight = curRight + windowSize;
            if (curRightRight >= intensities.length && !stop_sliding_right) {
                stop_sliding_right = true;
                finalCurRight = curRight - 1;
            }
            if (stop_sliding_right) {
                curRight = finalCurRight;
                curRightRight = intensities.length - 1;
            }
            if ((curLeftLeft = (curLeft = peakLeft - i) - windowSize) < 0 && !stop_sliding_left) {
                stop_sliding_left = true;
                finalCurLeft = curLeft + 1;
            }
            if (stop_sliding_left) {
                curLeft = finalCurLeft;
                curLeftLeft = 0;
            }
            for (j = curRight; j <= curRightRight; ++j) {
                stdDevStats.addValue(intensities[j]);
            }
            for (j = curLeft; j >= curLeftLeft; --j) {
                stdDevStats.addValue(intensities[j]);
            }
            double curNoPeakNoise = stdDevStats.getStandardDeviation();
            toFindMinNoPeakNoise.addValue(curNoPeakNoise);
        }
        double bestNoPeakNoise = toFindMinNoPeakNoise.getMin();
        stdDevStats.clear();
        int rightBound = peakRight + peakWidth;
        int leftBound = peakLeft - peakWidth;
        if (rightBound >= intensities.length) {
            rightBound = intensities.length - 1;
        }
        if (leftBound < 0) {
            leftBound = 0;
        }
        for (int i = peakRight; i <= rightBound; ++i) {
            stdDevStats.addValue(intensities[i]);
        }
        double smallIntensity1 = stdDevStats.getMin();
        stdDevStats.clear();
        for (int i = leftBound; i <= peakLeft; ++i) {
            stdDevStats.addValue(intensities[i]);
        }
        double smallIntensity2 = stdDevStats.getMin();
        double smallIntensityAvg = (smallIntensity1 + smallIntensity2) / 2.0;
        double SNRatio = (peakHeight - smallIntensityAvg) / bestNoPeakNoise;
        return SNRatio;
    }
}

