/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.output.support.AbstractXMLOutputProcessor;
import org.jdom2.output.support.FormatStack;
import org.jdom2.util.NamespaceStack;

class LineBreakProcessor
extends AbstractXMLOutputProcessor {
    private String buffer;

    LineBreakProcessor() {
    }

    protected void printElement(Writer out, FormatStack fstack, NamespaceStack nstack, Element element) throws IOException {
        Element nextSiblingElement = LineBreakProcessor.findNextSiblingElement(element);
        boolean shouldBreakLine = false;
        if (nextSiblingElement != null) {
            shouldBreakLine = LineBreakProcessor.shouldBreakLine(nextSiblingElement);
        }
        super.printElement(out, fstack, nstack, element);
        this.buffer = shouldBreakLine ? fstack.getLineSeparator() : null;
    }

    protected void textRaw(Writer out, String str) throws IOException {
        if (this.buffer != null) {
            out.write(this.buffer);
            this.buffer = null;
        }
        super.textRaw(out, str);
    }

    private static Element findNextSiblingElement(Element element) {
        List children;
        int idx;
        Element parent = element.getParentElement();
        if (parent != null && (idx = (children = parent.getChildren()).indexOf(element)) < children.size() - 1) {
            return (Element)children.get(idx + 1);
        }
        return null;
    }

    private static boolean shouldBreakLine(Element element) {
        Element rootElement = element.getDocument().getRootElement();
        int idxElement = rootElement.indexOf((Content)element);
        List children = element.getChildren();
        return idxElement > -1 && !children.isEmpty();
    }
}

