/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.junit.platform.engine.CucumberConfiguration;
import io.cucumber.junit.platform.engine.CucumberEngineExecutionContext;
import io.cucumber.junit.platform.engine.ExclusiveResourceConfiguration;
import io.cucumber.junit.platform.engine.FeatureSource;
import io.cucumber.junit.platform.engine.FeatureWithSource;
import io.cucumber.junit.platform.engine.NamingStrategy;
import io.cucumber.plugin.event.Location;
import io.cucumber.plugin.event.Node;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.junit.platform.engine.support.hierarchical.Node;

abstract class CucumberTestDescriptor
extends AbstractTestDescriptor {
    private static final String RULE_SEGMENT_TYPE = "rule";
    private static final String FEATURE_SEGMENT_TYPE = "feature";
    private static final String SCENARIO_SEGMENT_TYPE = "scenario";
    private static final String EXAMPLES_SEGMENT_TYPE = "examples";
    private static final String EXAMPLE_SEGMENT_TYPE = "example";

    private CucumberTestDescriptor(UniqueId uniqueId, String displayName, TestSource source) {
        super(uniqueId, displayName, source);
    }

    static Builder builder(CucumberConfiguration configuration) {
        return new Builder(configuration, configuration.namingStrategy());
    }

    static boolean isFeatureSegment(UniqueId.Segment segment) {
        return FEATURE_SEGMENT_TYPE.equals(segment.getType());
    }

    protected abstract URI getUri();

    protected abstract Location getLocation();

    static class Builder {
        private final CucumberConfiguration configuration;
        private final NamingStrategy namingStrategy;

        Builder(CucumberConfiguration configuration, NamingStrategy namingStrategy) {
            this.configuration = Objects.requireNonNull(configuration);
            this.namingStrategy = Objects.requireNonNull(namingStrategy);
        }

        Optional<TestDescriptor> build(TestDescriptor parent, FeatureWithSource feature, Node node) {
            Objects.requireNonNull(parent);
            Objects.requireNonNull(feature);
            Objects.requireNonNull(node);
            FeatureSource source = feature.getSource();
            if (node instanceof Node.Feature) {
                return Optional.of(new FeatureDescriptor(Builder.createUniqueId(parent, CucumberTestDescriptor.FEATURE_SEGMENT_TYPE, feature.getUri()), this.namingStrategy.name(node), source.nodeSource(node), feature.getFeature()));
            }
            if (node instanceof Node.Rule) {
                return Optional.of(new FeatureElementDescriptor.RuleDescriptor(this.configuration, Builder.createUniqueId(parent, CucumberTestDescriptor.RULE_SEGMENT_TYPE, node.getLocation()), this.namingStrategy.name(node), source.nodeSource(node), node));
            }
            if (node instanceof Node.Scenario) {
                return Optional.of(new PickleDescriptor(this.configuration, Builder.createUniqueId(parent, CucumberTestDescriptor.SCENARIO_SEGMENT_TYPE, node.getLocation()), this.namingStrategy.name(node), source.nodeSource(node), feature.getFeature().getPickleAt(node)));
            }
            if (node instanceof Node.ScenarioOutline) {
                return Optional.of(new FeatureElementDescriptor.ScenarioOutlineDescriptor(this.configuration, Builder.createUniqueId(parent, CucumberTestDescriptor.SCENARIO_SEGMENT_TYPE, node.getLocation()), this.namingStrategy.name(node), source.nodeSource(node), node));
            }
            if (node instanceof Node.Examples) {
                return Optional.of(new FeatureElementDescriptor.ExamplesDescriptor(this.configuration, Builder.createUniqueId(parent, CucumberTestDescriptor.EXAMPLES_SEGMENT_TYPE, node.getLocation()), this.namingStrategy.name(node), source.nodeSource(node), node));
            }
            if (node instanceof Node.Example) {
                Pickle pickle = feature.getFeature().getPickleAt(node);
                return Optional.of(new PickleDescriptor(this.configuration, Builder.createUniqueId(parent, CucumberTestDescriptor.EXAMPLE_SEGMENT_TYPE, node.getLocation()), this.namingStrategy.nameExample(node, pickle), source.nodeSource(node), pickle));
            }
            throw new IllegalStateException("Got a " + node.getClass() + " but didn't have a case to handle it");
        }

        private static UniqueId createUniqueId(TestDescriptor parent, String segmentType, Location line) {
            return Builder.createUniqueId(parent, segmentType, String.valueOf(line.getLine()));
        }

        private static UniqueId createUniqueId(TestDescriptor parent, String segmentType, String line) {
            return parent.getUniqueId().append(segmentType, line);
        }
    }

    static final class PickleDescriptor
    extends CucumberTestDescriptor
    implements org.junit.platform.engine.support.hierarchical.Node<CucumberEngineExecutionContext> {
        private final Pickle pickle;
        private final CucumberConfiguration configuration;

        PickleDescriptor(CucumberConfiguration configuration, UniqueId uniqueId, String name, TestSource source, Pickle pickle) {
            super(uniqueId, name, source);
            this.configuration = configuration;
            this.pickle = pickle;
        }

        Pickle getPickle() {
            return this.pickle;
        }

        public TestDescriptor.Type getType() {
            return TestDescriptor.Type.TEST;
        }

        public Node.SkipResult shouldBeSkipped(CucumberEngineExecutionContext context) {
            return Stream.of(this.shouldBeSkippedByTagFilter(context), this.shouldBeSkippedByNameFilter(context)).flatMap(skipResult -> skipResult.map(Stream::of).orElseGet(Stream::empty)).filter(Node.SkipResult::isSkipped).findFirst().orElseGet(Node.SkipResult::doNotSkip);
        }

        private Optional<Node.SkipResult> shouldBeSkippedByTagFilter(CucumberEngineExecutionContext context) {
            return context.getConfiguration().tagFilter().map(expression -> {
                if (expression.evaluate(this.pickle.getTags())) {
                    return Node.SkipResult.doNotSkip();
                }
                return Node.SkipResult.skip((String)("'cucumber.filter.tags=" + expression + "' did not match this scenario"));
            });
        }

        private Optional<Node.SkipResult> shouldBeSkippedByNameFilter(CucumberEngineExecutionContext context) {
            return context.getConfiguration().nameFilter().map(pattern -> {
                if (pattern.matcher(this.pickle.getName()).matches()) {
                    return Node.SkipResult.doNotSkip();
                }
                return Node.SkipResult.skip((String)("'cucumber.filter.name=" + pattern + "' did not match this scenario"));
            });
        }

        public CucumberEngineExecutionContext execute(CucumberEngineExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) {
            context.runTestCase(this.pickle);
            return context;
        }

        public Set<ExclusiveResource> getExclusiveResources() {
            return this.getTags().stream().map(tag -> this.configuration.getExclusiveResourceConfiguration(tag.getName())).flatMap(ExclusiveResourceConfiguration::getExclusiveResources).collect(Collectors.toSet());
        }

        public Set<TestTag> getTags() {
            return this.pickle.getTags().stream().map(tag -> tag.substring(1)).filter(TestTag::isValid).map(TestTag::create).collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Collections::unmodifiableSet));
        }

        @Override
        protected URI getUri() {
            return this.pickle.getUri();
        }

        @Override
        protected Location getLocation() {
            return this.pickle.getLocation();
        }

        public Node.ExecutionMode getExecutionMode() {
            return this.configuration.getExecutionModeFeature();
        }
    }

    static abstract class FeatureElementDescriptor
    extends CucumberTestDescriptor
    implements org.junit.platform.engine.support.hierarchical.Node<CucumberEngineExecutionContext> {
        private final CucumberConfiguration configuration;
        private final Node element;

        FeatureElementDescriptor(CucumberConfiguration configuration, UniqueId uniqueId, String name, TestSource source, Node element) {
            super(uniqueId, name, source);
            this.configuration = configuration;
            this.element = element;
        }

        public Node.ExecutionMode getExecutionMode() {
            return this.configuration.getExecutionModeFeature();
        }

        @Override
        protected Location getLocation() {
            return this.element.getLocation();
        }

        @Override
        protected URI getUri() {
            return this.element.getUri();
        }

        static final class ScenarioOutlineDescriptor
        extends FeatureElementDescriptor {
            ScenarioOutlineDescriptor(CucumberConfiguration configuration, UniqueId uniqueId, String name, TestSource source, Node element) {
                super(configuration, uniqueId, name, source, element);
            }

            public TestDescriptor.Type getType() {
                return TestDescriptor.Type.CONTAINER;
            }
        }

        static final class RuleDescriptor
        extends FeatureElementDescriptor {
            RuleDescriptor(CucumberConfiguration configuration, UniqueId uniqueId, String name, TestSource source, Node element) {
                super(configuration, uniqueId, name, source, element);
            }

            public TestDescriptor.Type getType() {
                return TestDescriptor.Type.CONTAINER;
            }
        }

        static final class ExamplesDescriptor
        extends FeatureElementDescriptor {
            ExamplesDescriptor(CucumberConfiguration configuration, UniqueId uniqueId, String name, TestSource source, Node element) {
                super(configuration, uniqueId, name, source, element);
            }

            public TestDescriptor.Type getType() {
                return TestDescriptor.Type.CONTAINER;
            }
        }
    }

    static class FeatureDescriptor
    extends CucumberTestDescriptor
    implements org.junit.platform.engine.support.hierarchical.Node<CucumberEngineExecutionContext> {
        private final Feature feature;

        FeatureDescriptor(UniqueId uniqueId, String name, TestSource source, Feature feature) {
            super(uniqueId, name, source);
            this.feature = feature;
        }

        Feature getFeature() {
            return this.feature;
        }

        public CucumberEngineExecutionContext prepare(CucumberEngineExecutionContext context) {
            context.beforeFeature(this.feature);
            return context;
        }

        public TestDescriptor.Type getType() {
            return TestDescriptor.Type.CONTAINER;
        }

        @Override
        protected URI getUri() {
            return this.feature.getUri();
        }

        @Override
        protected Location getLocation() {
            return this.feature.getLocation();
        }
    }
}

