/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.spring.elasticsearch.xml;

import fr.pilato.spring.elasticsearch.ElasticsearchClientFactoryBean;
import fr.pilato.spring.elasticsearch.ElasticsearchTransportClientFactoryBean;
import fr.pilato.spring.elasticsearch.xml.XMLParserUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ClientBeanDefinitionParser
implements BeanDefinitionParser {
    protected static final Log logger = LogFactory.getLog(ClientBeanDefinitionParser.class);

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinition client;
        boolean isEsNodesEmpty;
        String id = XMLParserUtil.getElementStringValue(element, "id");
        String name = XMLParserUtil.getElementStringValue(element, "name");
        String node = XMLParserUtil.getElementStringValue(element, "node");
        String esNodes = XMLParserUtil.getElementStringValue(element, "esNodes");
        String settingsFile = XMLParserUtil.getElementStringValue(element, "settingsFile");
        String properties = XMLParserUtil.getElementStringValue(element, "properties");
        boolean forceMapping = XMLParserUtil.getElementBooleanValue(element, "forceMapping");
        boolean forceTemplate = XMLParserUtil.getElementBooleanValue(element, "forceTemplate");
        boolean mergeMapping = XMLParserUtil.getElementBooleanValue(element, "mergeMapping");
        boolean mergeSettings = XMLParserUtil.getElementBooleanValue(element, "mergeSettings");
        boolean autoscan = XMLParserUtil.getElementBooleanValue(element, "autoscan", true);
        String classpathRoot = XMLParserUtil.getElementStringValue(element, "classpathRoot");
        String mappings = XMLParserUtil.getElementStringValue(element, "mappings");
        String aliases = XMLParserUtil.getElementStringValue(element, "aliases");
        String templates = XMLParserUtil.getElementStringValue(element, "templates");
        boolean isClientNode = node != null && node.length() > 0;
        boolean bl = isEsNodesEmpty = esNodes == null || esNodes.length() == 0;
        if (isClientNode && !isEsNodesEmpty) {
            throw new RuntimeException("Incorrect settings. You should not set esNodes when using a client node.");
        }
        if (!isClientNode && isEsNodesEmpty) {
            throw new RuntimeException("Incorrect settings. You must set esNodes when creating a transport client.");
        }
        GenericBeanDefinition bdef = new GenericBeanDefinition();
        if (isClientNode) {
            bdef.setBeanClass(ElasticsearchClientFactoryBean.class);
            BeanDefinitionBuilder clientBuilder = ClientBeanDefinitionParser.startClientBuilder(ElasticsearchClientFactoryBean.class, settingsFile, properties, forceMapping, forceTemplate, mergeMapping, mergeSettings, autoscan, classpathRoot, mappings, aliases, templates);
            client = ClientBeanDefinitionParser.buildClientDef(clientBuilder, node);
        } else {
            bdef.setBeanClass(ElasticsearchTransportClientFactoryBean.class);
            BeanDefinitionBuilder clientBuilder = ClientBeanDefinitionParser.startClientBuilder(ElasticsearchTransportClientFactoryBean.class, settingsFile, properties, forceMapping, forceTemplate, mergeMapping, mergeSettings, autoscan, classpathRoot, mappings, aliases, templates);
            client = ClientBeanDefinitionParser.buildTransportClientDef(clientBuilder, esNodes);
        }
        if (id != null && id.length() > 0) {
            parserContext.getRegistry().registerBeanDefinition(id, client);
        } else {
            parserContext.getRegistry().registerBeanDefinition(name, client);
        }
        return bdef;
    }

    public static BeanDefinitionBuilder startClientBuilder(Class beanClass, String settingsFile, String properties, boolean forceMapping, boolean forceTemplate, boolean mergeMapping, boolean mergeSettings, boolean autoscan, String classpathRoot, String mappings, String aliases, String templates) {
        BeanDefinitionBuilder nodeFactory = BeanDefinitionBuilder.rootBeanDefinition((Class)beanClass);
        if (settingsFile != null && settingsFile.length() > 0) {
            logger.warn((Object)"settingsFile is deprecated. Use properties attribute instead. See issue #15: https://github.com/dadoonet/spring-elasticsearch/issues/15.");
            nodeFactory.addPropertyValue("settingsFile", (Object)settingsFile);
        }
        if (properties != null && properties.length() > 0) {
            nodeFactory.addPropertyReference("properties", properties);
        }
        nodeFactory.addPropertyValue("forceMapping", (Object)forceMapping);
        nodeFactory.addPropertyValue("forceTemplate", (Object)forceTemplate);
        nodeFactory.addPropertyValue("mergeMapping", (Object)mergeMapping);
        nodeFactory.addPropertyValue("mergeSettings", (Object)mergeSettings);
        nodeFactory.addPropertyValue("autoscan", (Object)autoscan);
        if (classpathRoot != null && classpathRoot.length() > 0) {
            nodeFactory.addPropertyValue("classpathRoot", (Object)classpathRoot);
        }
        if (mappings != null && mappings.length() > 0) {
            nodeFactory.addPropertyValue("mappings", (Object)mappings);
        }
        if (aliases != null && aliases.length() > 0) {
            nodeFactory.addPropertyValue("aliases", (Object)aliases);
        }
        if (templates != null && templates.length() > 0) {
            nodeFactory.addPropertyValue("templates", (Object)templates);
        }
        return nodeFactory;
    }

    public static BeanDefinition buildClientDef(BeanDefinitionBuilder nodeFactory, String node) {
        if (node != null && node.length() > 0) {
            nodeFactory.addPropertyReference("node", node);
        }
        return nodeFactory.getBeanDefinition();
    }

    public static BeanDefinition buildTransportClientDef(BeanDefinitionBuilder nodeFactory, String esNodes) {
        if (esNodes != null && esNodes.length() > 0) {
            nodeFactory.addPropertyValue("esNodes", (Object)esNodes);
        }
        return nodeFactory.getBeanDefinition();
    }
}

