/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.spring.elasticsearch;

import fr.pilato.spring.elasticsearch.ElasticsearchAbstractFactoryBean;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.close.CloseIndexResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.open.OpenIndexResponse;
import org.elasticsearch.action.admin.indices.settings.UpdateSettingsRequestBuilder;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.indices.IndexMissingException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.Assert;

public abstract class ElasticsearchAbstractClientFactoryBean
extends ElasticsearchAbstractFactoryBean
implements FactoryBean<Client>,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected Client client;
    protected boolean forceMapping;
    protected boolean forceTemplate;
    protected boolean mergeMapping;
    protected boolean mergeSettings;
    protected boolean autoscan = true;
    protected String[] mappings;
    protected String[] aliases;
    protected String[] templates;
    protected String classpathRoot = "/es";
    protected String jsonFileExtension = ".json";
    protected String indexSettingsFileName = "_settings.json";
    protected String templateDir = "_template";

    protected abstract Client buildClient() throws Exception;

    public void setForceMapping(boolean forceMapping) {
        this.forceMapping = forceMapping;
    }

    public void setForceTemplate(boolean forceTemplate) {
        this.forceTemplate = forceTemplate;
    }

    public void setMergeMapping(boolean mergeMapping) {
        this.mergeMapping = mergeMapping;
    }

    public void setMergeSettings(boolean mergeSettings) {
        this.mergeSettings = mergeSettings;
    }

    public void setAutoscan(boolean autoscan) {
        this.autoscan = autoscan;
    }

    public void setMappings(String[] mappings) {
        this.mappings = mappings;
    }

    public void setAliases(String[] aliases) {
        this.aliases = aliases;
    }

    public void setTemplates(String[] templates) {
        this.templates = templates;
    }

    public void setClasspathRoot(String classpathRoot) {
        this.classpathRoot = classpathRoot;
    }

    public void afterPropertiesSet() throws Exception {
        this.logger.info((Object)"Starting ElasticSearch client");
        this.client = this.buildClient();
        if (this.autoscan) {
            this.computeMappings();
        }
        this.initTemplates();
        this.initMappings();
        this.initAliases();
    }

    public void destroy() throws Exception {
        try {
            this.logger.info((Object)"Closing ElasticSearch client");
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error closing ElasticSearch client: ", (Throwable)e);
        }
    }

    public Client getObject() throws Exception {
        return this.client;
    }

    public Class<Client> getObjectType() {
        return Client.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private void initTemplates() throws Exception {
        if (this.templates != null && this.templates.length > 0) {
            for (int i = 0; i < this.templates.length; ++i) {
                String template = this.templates[i];
                Assert.hasText((String)template, (String)("Can not read template in [" + this.templates[i] + "]. Check that templates is not empty."));
                this.createTemplate(template, this.forceTemplate);
            }
        }
    }

    private void computeMappings() {
        block7: {
            if (this.mappings == null || this.mappings.length == 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Automatic discovery is activated. Looking for definition files in classpath under " + this.classpathRoot + "."));
                }
                ArrayList<String> autoMappings = new ArrayList<String>();
                PathMatchingResourcePatternResolver pathResolver = new PathMatchingResourcePatternResolver();
                Resource resourceRoot = pathResolver.getResource(this.classpathRoot);
                try {
                    Resource[] resources = pathResolver.getResources("classpath:" + this.classpathRoot + "/**/*" + this.jsonFileExtension);
                    for (int i = 0; i < resources.length; ++i) {
                        String relPath = resources[i].getURI().toString().substring(resourceRoot.getURI().toString().length());
                        if (relPath.startsWith("/")) {
                            relPath = relPath.substring(1);
                        }
                        if (relPath.startsWith(this.templateDir)) continue;
                        relPath = !relPath.endsWith(this.indexSettingsFileName) ? relPath.substring(0, relPath.lastIndexOf(".json")) : relPath.substring(0, relPath.lastIndexOf(this.indexSettingsFileName));
                        autoMappings.add(relPath);
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug((Object)("Automatic discovery found " + relPath + " json file in classpath under " + this.classpathRoot + "."));
                    }
                    this.mappings = autoMappings.toArray(new String[autoMappings.size()]);
                }
                catch (IOException e) {
                    if (!this.logger.isTraceEnabled() && this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Automatic discovery does not succeed for finding json files in classpath under " + this.classpathRoot + "."));
                    }
                    if (!this.logger.isTraceEnabled()) break block7;
                    this.logger.trace((Object)("Automatic discovery does not succeed for finding json files in classpath under " + this.classpathRoot + "."), (Throwable)e);
                }
            }
        }
    }

    private void initMappings() throws Exception {
        if (this.mappings != null && this.mappings.length > 0) {
            HashMap indexes = new HashMap();
            for (int i = 0; i < this.mappings.length; ++i) {
                String indexmapping = this.mappings[i];
                String[] indexmappingsplitted = indexmapping.split("/");
                String index = indexmappingsplitted[0];
                if (index == null) {
                    throw new Exception("Can not read index in [" + indexmapping + "]. Check that mappings contains only indexname/mappingname elements.");
                }
                if (!indexes.containsKey(index)) {
                    indexes.put(index, new ArrayList());
                }
                if (indexmappingsplitted.length <= 1) continue;
                String mapping = indexmappingsplitted[1];
                ((Collection)indexes.get(index)).add(mapping);
            }
            for (String index : indexes.keySet()) {
                if (!this.isIndexExist(index)) {
                    this.createIndex(index);
                } else if (this.mergeSettings) {
                    this.mergeIndexSettings(index);
                }
                Collection mappings = (Collection)indexes.get(index);
                for (String type : mappings) {
                    this.pushMapping(index, type, this.forceMapping, this.mergeMapping);
                }
            }
        }
    }

    private void initAliases() throws Exception {
        if (this.aliases != null && this.aliases.length > 0) {
            for (int i = 0; i < this.aliases.length; ++i) {
                String[] aliasessplitted = this.aliases[i].split(":");
                String alias = aliasessplitted[0];
                String index = aliasessplitted[1];
                if (index == null) {
                    throw new Exception("Can not read index in [" + this.aliases[i] + "]. Check that aliases contains only aliasname:indexname elements.");
                }
                if (alias == null) {
                    throw new Exception("Can not read mapping in [" + this.aliases[i] + "]. Check that aliases contains only aliasname:indexname elements.");
                }
                this.createAlias(alias, index);
            }
        }
    }

    private void checkClient() throws Exception {
        if (this.client == null) {
            throw new Exception("ElasticSearch client doesn't exist. Your factory is not properly initialized.");
        }
    }

    private void createAlias(String alias, String index) throws Exception {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("createAlias(" + alias + "," + index + ")"));
        }
        this.checkClient();
        IndicesAliasesResponse response = (IndicesAliasesResponse)this.client.admin().indices().prepareAliases().addAlias(index, alias).execute().actionGet();
        if (!response.isAcknowledged()) {
            throw new Exception("Could not define alias [" + alias + "] for index [" + index + "].");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("/createAlias(" + alias + "," + index + ")"));
        }
    }

    private void createTemplate(String template, boolean force) throws Exception {
        String source;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("createTemplate(" + template + ")"));
        }
        this.checkClient();
        if (force && this.isTemplateExist(template)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Force remove template [" + template + "]"));
            }
            this.client.admin().indices().prepareDeleteTemplate(template).execute().actionGet();
        }
        if ((source = this.readTemplate(template)) != null) {
            PutIndexTemplateResponse response;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Template [" + template + "]=" + source));
            }
            if (!(response = (PutIndexTemplateResponse)this.client.admin().indices().preparePutTemplate(template).setSource(source).execute().actionGet()).isAcknowledged()) {
                throw new Exception("Could not define template [" + template + "].");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Template [" + template + "] successfully created."));
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("No template definition for [" + template + "]. Ignoring."));
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("/createTemplate(" + template + ")"));
        }
    }

    private boolean isIndexExist(String index) throws Exception {
        this.checkClient();
        return ((IndicesExistsResponse)this.client.admin().indices().prepareExists(new String[]{index}).execute().actionGet()).isExists();
    }

    private boolean isMappingExist(String index, String type) {
        IndexMetaData imd = null;
        try {
            ClusterState cs = ((ClusterStateResponse)this.client.admin().cluster().prepareState().setFilterIndices(new String[]{index}).execute().actionGet()).getState();
            imd = cs.getMetaData().index(index);
        }
        catch (IndexMissingException e) {
            // empty catch block
        }
        if (imd == null) {
            return false;
        }
        MappingMetaData mdd = imd.mapping(type);
        return mdd != null;
    }

    private boolean isTemplateExist(String template) {
        ClusterState cs = ((ClusterStateResponse)this.client.admin().cluster().prepareState().setFilterIndexTemplates(new String[]{template}).execute().actionGet()).getState();
        IndexTemplateMetaData mdd = (IndexTemplateMetaData)cs.getMetaData().templates().get((Object)template);
        return mdd != null;
    }

    private void pushMapping(String index, String type, boolean force, boolean merge) throws Exception {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("pushMapping(" + index + "," + type + "," + force + ")"));
        }
        this.checkClient();
        if (force && this.isMappingExist(index, type)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Force remove old type and mapping [" + index + "]/[" + type + "]"));
            }
            this.client.admin().indices().prepareDeleteMapping(new String[]{index}).setType(type).execute().actionGet();
        }
        boolean mappingExist = this.isMappingExist(index, type);
        if (merge || !mappingExist) {
            String source;
            if (this.logger.isDebugEnabled()) {
                if (mappingExist) {
                    this.logger.debug((Object)("Updating mapping [" + index + "]/[" + type + "]."));
                } else {
                    this.logger.debug((Object)("Mapping [" + index + "]/[" + type + "] doesn't exist. Creating it."));
                }
            }
            if ((source = this.readMapping(index, type)) != null) {
                PutMappingResponse response;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Mapping for [" + index + "]/[" + type + "]=" + source));
                }
                if (!(response = (PutMappingResponse)this.client.admin().indices().preparePutMapping(new String[]{index}).setType(type).setSource(source).execute().actionGet()).isAcknowledged()) {
                    throw new Exception("Could not define mapping for type [" + index + "]/[" + type + "].");
                }
                if (this.logger.isDebugEnabled()) {
                    if (mappingExist) {
                        this.logger.debug((Object)("Mapping definition for [" + index + "]/[" + type + "] succesfully merged."));
                    } else {
                        this.logger.debug((Object)("Mapping definition for [" + index + "]/[" + type + "] succesfully created."));
                    }
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No mapping definition for [" + index + "]/[" + type + "]. Ignoring."));
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Mapping [" + index + "]/[" + type + "] already exists and mergeMapping is not set."));
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("/pushMapping(" + index + "," + type + "," + force + ")"));
        }
    }

    private void createIndex(String index) throws Exception {
        CreateIndexResponse createIndexResponse;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("createIndex(" + index + ")"));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Index " + index + " doesn't exist. Creating it."));
        }
        this.checkClient();
        CreateIndexRequestBuilder cirb = this.client.admin().indices().prepareCreate(index);
        String source = this.readIndexSettings(index);
        if (source != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Found settings for index " + index + " : " + source));
            }
            cirb.setSettings(source);
        }
        if (!(createIndexResponse = (CreateIndexResponse)cirb.execute().actionGet()).isAcknowledged()) {
            throw new Exception("Could not create index [" + index + "].");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("/createIndex(" + index + ")"));
        }
    }

    private void mergeIndexSettings(String index) throws Exception {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("mergeIndexSettings(" + index + ")"));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Index " + index + " already exists. Trying to merge settings."));
        }
        this.checkClient();
        CloseIndexRequestBuilder cirb = this.client.admin().indices().prepareClose(index);
        CloseIndexResponse closeIndexResponse = (CloseIndexResponse)cirb.execute().actionGet();
        if (!closeIndexResponse.isAcknowledged()) {
            throw new Exception("Could not close index [" + index + "].");
        }
        UpdateSettingsRequestBuilder usrb = this.client.admin().indices().prepareUpdateSettings(new String[]{index});
        String source = this.readIndexSettings(index);
        if (source != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Found settings for index " + index + " : " + source));
            }
            usrb.setSettings(source);
        }
        usrb.execute().actionGet();
        OpenIndexRequestBuilder oirb = this.client.admin().indices().prepareOpen(index);
        OpenIndexResponse openIndexResponse = (OpenIndexResponse)oirb.execute().actionGet();
        if (!openIndexResponse.isAcknowledged()) {
            throw new Exception("Could not open index [" + index + "].");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("/mergeIndexSettings(" + index + ")"));
        }
    }

    private String readMapping(String index, String type) throws Exception {
        return ElasticsearchAbstractClientFactoryBean.readFileInClasspath(this.classpathRoot + "/" + index + "/" + type + this.jsonFileExtension);
    }

    private String readTemplate(String template) throws Exception {
        return ElasticsearchAbstractClientFactoryBean.readFileInClasspath(this.classpathRoot + "/" + this.templateDir + "/" + template + this.jsonFileExtension);
    }

    public String readIndexSettings(String index) throws Exception {
        return ElasticsearchAbstractClientFactoryBean.readFileInClasspath(this.classpathRoot + "/" + index + "/" + this.indexSettingsFileName);
    }

    public static String readFileInClasspath(String url) throws Exception {
        StringBuffer bufferJSON = new StringBuffer();
        try {
            String line;
            InputStream ips = ElasticsearchAbstractClientFactoryBean.class.getResourceAsStream(url);
            InputStreamReader ipsr = new InputStreamReader(ips);
            BufferedReader br = new BufferedReader(ipsr);
            while ((line = br.readLine()) != null) {
                bufferJSON.append(line);
            }
            br.close();
        }
        catch (Exception e) {
            return null;
        }
        return bufferJSON.toString();
    }
}

