/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.tree.loadors;

import fr.ird.observe.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.model.DataSelectionModel;
import fr.ird.observe.entities.seine.TripSeine;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import fr.ird.observe.ui.tree.TripSeineNode;
import fr.ird.observe.ui.tree.loadors.AbstractNodeChildLoador;
import fr.ird.observe.ui.tree.loadors.RoutesNodeChildLoador;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.swing.nav.tree.NavTreeBridge;
import org.apache.commons.collections.CollectionUtils;
import org.nuiton.i18n.I18n;

public class ProgramSeineNodeChildLoador
extends AbstractNodeChildLoador<TripSeine> {
    private static final long serialVersionUID = 1L;
    protected boolean addChilds;

    public ProgramSeineNodeChildLoador() {
        super(TripSeine.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadChilds(NavTreeBridge<ObserveNode> model, ObserveNode parentNode, NavDataProvider dataProvider) throws Exception {
        DataSelectionModel selectionModel = this.getSelectionModel(dataProvider);
        this.addChilds = selectionModel == null;
        try {
            super.loadChilds(model, (NavNode)parentNode, dataProvider);
        }
        finally {
            this.addChilds = true;
        }
    }

    public List<TripSeine> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {
        ArrayList<TripSeine> result;
        DataSource dataSource = this.getDataSource(dataProvider);
        DataService service = this.getDataService();
        DataSelectionModel selectionModel = this.getSelectionModel(dataProvider);
        if (selectionModel != null) {
            result = new ArrayList();
            List tripIds = (List)selectionModel.getDatas().get(parentId);
            if (!CollectionUtils.isEmpty((Collection)tripIds)) {
                for (String tripId : tripIds) {
                    result.add((TripSeine)selectionModel.getEntityCache(tripId));
                }
            }
        } else {
            result = service.getTripSeineStubByProgram(dataSource, parentId);
        }
        return result;
    }

    public ObserveNode createNode(TripSeine data, NavDataProvider dataProvider) {
        if (data == null) {
            throw new NullPointerException("Ne peut pas ajouter un objet null");
        }
        TripSeineNode result = new TripSeineNode(data);
        if (this.addChilds) {
            ObserveNode child = ObserveTreeHelper.createStringNode("gearUseFeaturesSeine");
            result.add(child);
            child = ObserveTreeHelper.createStringNode("route", RoutesNodeChildLoador.class);
            result.add(child);
        }
        return result;
    }

    static {
        I18n.n((String)"observe.tree.gearUseFeaturesSeine", (Object[])new Object[0]);
        I18n.n((String)"observe.tree.route", (Object[])new Object[0]);
    }
}

