/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.util.tripMap;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import fr.ird.observe.ObserveTechnicalException;
import fr.ird.observe.tripMap.TripMapPoint;
import fr.ird.observe.tripMap.TripMapPointType;
import fr.ird.observe.ui.util.tripMap.ObserveMapPaneLegendItem;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.geotools.data.FeatureSource;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.CRS;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.SLD;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.UserLayer;
import org.nuiton.i18n.I18n;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.referencing.FactoryException;

public class TripMapContentBuilder {
    public static final String TRIP_LINES_LAYER_NAME = "Trip lines";
    public static final String TRIP_LONGLINE_FISHING_ZONE_LAYER_NAME = "Trip longline zone";
    public static final String TRIP_LONGLINE_LINE_LAYER_NAME = "Trip longline line";
    public static final String TRIP_POINTS_LAYER_NAME = "Trip points";
    protected static final Set<TripMapPointType> TRIP_MAP_POINT_TYPES_IN_LEGEND = ImmutableSet.of((Object)TripMapPointType.SEINE_ACTIVITY_IN_HARBOUR, (Object)TripMapPointType.SEINE_ACTIVITY_WITH_FREE_SCHOOL_TYPE, (Object)TripMapPointType.SEINE_ACTIVITY_WITH_OBJECT_SCHOOL_TYPE, (Object)TripMapPointType.LONGLINE_IN_HARBOUR, (Object)TripMapPointType.LONGLINE_ACTIVITY_WITH_SETTING_START, (Object)TripMapPointType.LONGLINE_ACTIVITY_WITH_SETTING_END, (Object[])new TripMapPointType[]{TripMapPointType.LONGLINE_ACTIVITY_WITH_HAULING_START, TripMapPointType.LONGLINE_ACTIVITY_WITH_HAULING_END, TripMapPointType.LONGLINE_ACTIVITY_WITH_STATION, TripMapPointType.LONGLINE_ACTIVITY_WITH_INTERACTION});
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM");
    protected StyledLayerDescriptor styledLayerDescriptor;
    protected MapContent mapContent = new MapContent();
    protected List<ObserveMapPaneLegendItem> legendItems = Lists.newArrayList();

    public MapContent getMapContent() {
        return this.mapContent;
    }

    public List<ObserveMapPaneLegendItem> getLegendItems() {
        return this.legendItems;
    }

    public void setStyledLayerDescriptor(File styleFile) throws FileNotFoundException {
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);
        SLDParser stylereader = new SLDParser(styleFactory, styleFile);
        this.styledLayerDescriptor = stylereader.parseSLD();
    }

    public void addLayer(File layerFile) throws IOException {
        FileDataStore store = FileDataStoreFinder.getDataStore((File)layerFile);
        SimpleFeatureSource featureSource = store.getFeatureSource();
        Style style = SLD.createSimpleStyle((FeatureType)featureSource.getSchema());
        style = this.findStyle(this.styledLayerDescriptor, ((Name)store.getNames().get(0)).getLocalPart(), null, style);
        FeatureLayer layer = new FeatureLayer((FeatureSource)featureSource, style);
        this.mapContent.addLayer((Layer)layer);
    }

    public void addTripLine(List<TripMapPoint> tripMapPoints) throws FactoryException {
        LineString line;
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
        SimpleFeatureTypeBuilder lineFeatureTypeBuilder = new SimpleFeatureTypeBuilder();
        lineFeatureTypeBuilder.setName("lineBuilder");
        lineFeatureTypeBuilder.setCRS(CRS.decode((String)"EPSG:4326", (boolean)true));
        lineFeatureTypeBuilder.add("line", LineString.class);
        lineFeatureTypeBuilder.add("label", String.class);
        lineFeatureTypeBuilder.add("type", String.class);
        SimpleFeatureType lineFeatureType = lineFeatureTypeBuilder.buildFeatureType();
        SimpleFeatureBuilder lineBuilder = new SimpleFeatureBuilder(lineFeatureType);
        DefaultFeatureCollection linesFeatures = new DefaultFeatureCollection();
        List coordinatesByDay = null;
        TripMapPoint previousPoint = null;
        for (TripMapPoint point : tripMapPoints) {
            if (previousPoint == null) {
                coordinatesByDay = Lists.newLinkedList();
            } else if (!DateUtils.isSameDay((Date)previousPoint.getTime(), (Date)point.getTime())) {
                if (coordinatesByDay.size() > 1) {
                    line = geometryFactory.createLineString(coordinatesByDay.toArray(new Coordinate[0]));
                    lineBuilder.add((Object)line);
                    lineBuilder.add((Object)DATE_FORMAT.format(previousPoint.getTime()));
                    lineBuilder.add((Object)"tripDay");
                    SimpleFeature feature = lineBuilder.buildFeature(null);
                    linesFeatures.add(feature);
                }
                Coordinate[] coordinates = new Coordinate[]{new Coordinate((double)previousPoint.getLongitude(), (double)previousPoint.getLatitude()), new Coordinate((double)point.getLongitude(), (double)point.getLatitude())};
                LineString lineBetweenTwoDays = geometryFactory.createLineString(coordinates);
                lineBuilder.add((Object)lineBetweenTwoDays);
                lineBuilder.add((Object)DateFormat.getDateInstance().format(previousPoint.getTime()));
                lineBuilder.add((Object)"tripBetweenTwoDays");
                linesFeatures.add(lineBuilder.buildFeature(null));
                coordinatesByDay = Lists.newLinkedList();
            }
            Coordinate coordinate = new Coordinate((double)point.getLongitude(), (double)point.getLatitude());
            coordinatesByDay.add(coordinate);
            previousPoint = point;
        }
        if (coordinatesByDay.size() > 1) {
            LineString line2 = geometryFactory.createLineString(coordinatesByDay.toArray(new Coordinate[0]));
            lineBuilder.add((Object)line2);
            lineBuilder.add((Object)DATE_FORMAT.format(previousPoint.getTime()));
            lineBuilder.add((Object)"tripDay");
            linesFeatures.add(lineBuilder.buildFeature(null));
        }
        Style styleLines = this.findStyle(this.styledLayerDescriptor, TRIP_LINES_LAYER_NAME, null);
        FeatureLayer layerLines = new FeatureLayer((FeatureCollection)linesFeatures, styleLines);
        this.mapContent.addLayer((Layer)layerLines);
        line = geometryFactory.createLineString(ObserveMapPaneLegendItem.lineCoordinates());
        lineBuilder.add((Object)line);
        lineBuilder.add((Object)"");
        lineBuilder.add((Object)"tripDay");
        ObserveMapPaneLegendItem legendTripDay = new ObserveMapPaneLegendItem(lineBuilder.buildFeature(null), styleLines, I18n.t((String)"observe.map.legend.tripDay", (Object[])new Object[0]));
        this.legendItems.add(legendTripDay);
        lineBuilder.add((Object)line);
        lineBuilder.add((Object)"");
        lineBuilder.add((Object)"tripBetweenTwoDays");
        ObserveMapPaneLegendItem legendTripBetweenTwoDays = new ObserveMapPaneLegendItem(lineBuilder.buildFeature(null), styleLines, I18n.t((String)"observe.map.legend.tripBetweenTwoDays", (Object[])new Object[0]));
        this.legendItems.add(legendTripBetweenTwoDays);
    }

    public void addLonglineFishingZone(List<TripMapPoint> tripMapPoints) throws FactoryException {
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
        SimpleFeatureTypeBuilder polygonFeatureTypeBuilder = new SimpleFeatureTypeBuilder();
        polygonFeatureTypeBuilder.setName("longlineFishingZoneBuilder");
        polygonFeatureTypeBuilder.setCRS(CRS.decode((String)"EPSG:4326", (boolean)true));
        polygonFeatureTypeBuilder.add("zone", Polygon.class);
        polygonFeatureTypeBuilder.add("label", String.class);
        polygonFeatureTypeBuilder.add("type", String.class);
        SimpleFeatureType polygonFeatureType = polygonFeatureTypeBuilder.buildFeatureType();
        SimpleFeatureBuilder polygonBuilder = new SimpleFeatureBuilder(polygonFeatureType);
        DefaultFeatureCollection polygonsFeatures = new DefaultFeatureCollection();
        for (int indexPoint = 3; indexPoint < tripMapPoints.size(); ++indexPoint) {
            if (!tripMapPoints.get(indexPoint).getType().equals((Object)TripMapPointType.LONGLINE_ACTIVITY_WITH_HAULING_END) || !tripMapPoints.get(indexPoint - 1).getType().equals((Object)TripMapPointType.LONGLINE_ACTIVITY_WITH_HAULING_START) || !tripMapPoints.get(indexPoint - 2).getType().equals((Object)TripMapPointType.LONGLINE_ACTIVITY_WITH_SETTING_END) || !tripMapPoints.get(indexPoint - 3).getType().equals((Object)TripMapPointType.LONGLINE_ACTIVITY_WITH_SETTING_START)) continue;
            Coordinate[] coordinates = new Coordinate[]{new Coordinate((double)tripMapPoints.get(indexPoint - 3).getLongitude(), (double)tripMapPoints.get(indexPoint - 3).getLatitude()), new Coordinate((double)tripMapPoints.get(indexPoint - 2).getLongitude(), (double)tripMapPoints.get(indexPoint - 2).getLatitude()), new Coordinate((double)tripMapPoints.get(indexPoint - 1).getLongitude(), (double)tripMapPoints.get(indexPoint - 1).getLatitude()), new Coordinate((double)tripMapPoints.get(indexPoint).getLongitude(), (double)tripMapPoints.get(indexPoint).getLatitude()), new Coordinate((double)tripMapPoints.get(indexPoint - 3).getLongitude(), (double)tripMapPoints.get(indexPoint - 3).getLatitude())};
            Polygon polygon = geometryFactory.createPolygon(coordinates);
            polygonBuilder.add((Object)polygon);
            polygonBuilder.add((Object)DATE_FORMAT.format(tripMapPoints.get(indexPoint - 3).getTime()));
            polygonBuilder.add((Object)"longlineFishingZone");
            SimpleFeature feature = polygonBuilder.buildFeature(null);
            polygonsFeatures.add(feature);
        }
        Style styleLines = this.findStyle(this.styledLayerDescriptor, TRIP_LONGLINE_FISHING_ZONE_LAYER_NAME, null);
        FeatureLayer layerLines = new FeatureLayer((FeatureCollection)polygonsFeatures, styleLines);
        this.mapContent.addLayer((Layer)layerLines);
    }

    public void addLonglineLine(List<TripMapPoint> tripMapPoints) throws FactoryException {
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
        SimpleFeatureTypeBuilder lineFeatureTypeBuilder = new SimpleFeatureTypeBuilder();
        lineFeatureTypeBuilder.setName("longlineSettingBuilder");
        lineFeatureTypeBuilder.setCRS(CRS.decode((String)"EPSG:4326", (boolean)true));
        lineFeatureTypeBuilder.add("line", LineString.class);
        lineFeatureTypeBuilder.add("type", String.class);
        SimpleFeatureType lineFeatureType = lineFeatureTypeBuilder.buildFeatureType();
        SimpleFeatureBuilder lineBuilder = new SimpleFeatureBuilder(lineFeatureType);
        DefaultFeatureCollection linesFeatures = new DefaultFeatureCollection();
        LinkedList defaultLineCoordinates = Lists.newLinkedList();
        for (int indexPoint = 0; indexPoint < tripMapPoints.size(); ++indexPoint) {
            if (indexPoint > 1 && tripMapPoints.get(indexPoint).getType().equals((Object)TripMapPointType.LONGLINE_ACTIVITY_WITH_SETTING_END) && tripMapPoints.get(indexPoint - 1).getType().equals((Object)TripMapPointType.LONGLINE_ACTIVITY_WITH_SETTING_START) || tripMapPoints.get(indexPoint).getType().equals((Object)TripMapPointType.LONGLINE_ACTIVITY_WITH_HAULING_END) && tripMapPoints.get(indexPoint - 1).getType().equals((Object)TripMapPointType.LONGLINE_ACTIVITY_WITH_HAULING_START)) {
                Coordinate[] coordinates = new Coordinate[]{new Coordinate((double)tripMapPoints.get(indexPoint - 1).getLongitude(), (double)tripMapPoints.get(indexPoint - 1).getLatitude()), new Coordinate((double)tripMapPoints.get(indexPoint).getLongitude(), (double)tripMapPoints.get(indexPoint).getLatitude())};
                boolean setting = tripMapPoints.get(indexPoint).getType().equals((Object)TripMapPointType.LONGLINE_ACTIVITY_WITH_SETTING_END);
                LineString lineString = geometryFactory.createLineString(coordinates);
                lineBuilder.add((Object)lineString);
                lineBuilder.add((Object)(setting ? "setting" : "hauling"));
                SimpleFeature feature = lineBuilder.buildFeature(null);
                linesFeatures.add(feature);
                defaultLineCoordinates.clear();
            }
            if (!tripMapPoints.get(indexPoint).getType().equals((Object)TripMapPointType.LONGLINE_ACTIVITY_WITH_SETTING_END) && !tripMapPoints.get(indexPoint).getType().equals((Object)TripMapPointType.LONGLINE_ACTIVITY_WITH_HAULING_START)) {
                defaultLineCoordinates.add(new Coordinate((double)tripMapPoints.get(indexPoint).getLongitude(), (double)tripMapPoints.get(indexPoint).getLatitude()));
            }
            if (!tripMapPoints.get(indexPoint).getType().equals((Object)TripMapPointType.LONGLINE_ACTIVITY_WITH_SETTING_START) && indexPoint != tripMapPoints.size() - 1 || defaultLineCoordinates.size() <= 1) continue;
            LineString lineString = geometryFactory.createLineString(defaultLineCoordinates.toArray(new Coordinate[0]));
            lineBuilder.add((Object)lineString);
            lineBuilder.add((Object)"trip");
            SimpleFeature feature = lineBuilder.buildFeature(null);
            linesFeatures.add(feature);
            defaultLineCoordinates.clear();
        }
        Style styleLines = this.findStyle(this.styledLayerDescriptor, TRIP_LONGLINE_LINE_LAYER_NAME, null);
        FeatureLayer layerLines = new FeatureLayer((FeatureCollection)linesFeatures, styleLines);
        this.mapContent.addLayer((Layer)layerLines);
        LineString line = geometryFactory.createLineString(ObserveMapPaneLegendItem.lineCoordinates());
        lineBuilder.add((Object)line);
        lineBuilder.add((Object)"setting");
        ObserveMapPaneLegendItem legendTripDay = new ObserveMapPaneLegendItem(lineBuilder.buildFeature(null), styleLines, I18n.t((String)"observe.map.legend.setting", (Object[])new Object[0]));
        this.legendItems.add(legendTripDay);
        line = geometryFactory.createLineString(ObserveMapPaneLegendItem.lineCoordinates());
        lineBuilder.add((Object)line);
        lineBuilder.add((Object)"hauling");
        legendTripDay = new ObserveMapPaneLegendItem(lineBuilder.buildFeature(null), styleLines, I18n.t((String)"observe.map.legend.hauling", (Object[])new Object[0]));
        this.legendItems.add(legendTripDay);
    }

    public void addPoints(List<TripMapPoint> tripMapPoints) throws FactoryException {
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
        SimpleFeatureTypeBuilder pointFeatureTypeBuilder = new SimpleFeatureTypeBuilder();
        pointFeatureTypeBuilder.setName("point Builder");
        pointFeatureTypeBuilder.setCRS(CRS.decode((String)"EPSG:4326", (boolean)true));
        pointFeatureTypeBuilder.add("point", Point.class);
        pointFeatureTypeBuilder.add("label", String.class);
        pointFeatureTypeBuilder.add("pointType", String.class);
        SimpleFeatureType pointFeatureType = pointFeatureTypeBuilder.buildFeatureType();
        SimpleFeatureBuilder pointBuilder = new SimpleFeatureBuilder(pointFeatureType);
        DefaultFeatureCollection pointsFeatures = new DefaultFeatureCollection();
        Style stylePoints = this.findStyle(this.styledLayerDescriptor, TRIP_POINTS_LAYER_NAME, null);
        HashSet pointTypeInLegend = Sets.newHashSet();
        for (TripMapPoint tripMapPoint : tripMapPoints) {
            Coordinate coordinate = new Coordinate((double)tripMapPoint.getLongitude(), (double)tripMapPoint.getLatitude());
            TripMapPointType type = tripMapPoint.getType();
            Point point = geometryFactory.createPoint(coordinate);
            pointBuilder.add((Object)point);
            pointBuilder.add((Object)DATE_FORMAT.format(tripMapPoint.getTime()));
            pointBuilder.add((Object)type.name());
            pointsFeatures.add(pointBuilder.buildFeature(null));
            if (!TRIP_MAP_POINT_TYPES_IN_LEGEND.contains(type) || pointTypeInLegend.contains(type)) continue;
            point = geometryFactory.createPoint(ObserveMapPaneLegendItem.pointCoordinates());
            pointBuilder.add((Object)point);
            pointBuilder.add((Object)"");
            pointBuilder.add((Object)type.name());
            ObserveMapPaneLegendItem legendPoint = new ObserveMapPaneLegendItem(pointBuilder.buildFeature(null), stylePoints, type.getLabel());
            this.legendItems.add(legendPoint);
            pointTypeInLegend.add(type);
        }
        FeatureLayer pointsLayer = new FeatureLayer((FeatureCollection)pointsFeatures, stylePoints);
        this.mapContent.addLayer((Layer)pointsLayer);
    }

    protected Style findStyle(StyledLayerDescriptor styledLayerDescriptor, final String layerName, String styleName, Style defaultStyle) {
        Optional styledLayerOptional = Iterables.tryFind((Iterable)styledLayerDescriptor.layers(), (Predicate)new Predicate<StyledLayer>(){

            public boolean apply(StyledLayer input) {
                return input.getName().equals(layerName);
            }
        });
        Style style = defaultStyle;
        if (styledLayerOptional.isPresent()) {
            StyledLayer styledLayer = (StyledLayer)styledLayerOptional.get();
            Style[] styles = new Style[]{};
            if (styledLayer instanceof UserLayer) {
                styles = ((UserLayer)styledLayer).getUserStyles();
            } else if (styledLayer instanceof NamedLayer) {
                styles = ((NamedLayer)styledLayer).getStyles();
            }
            if (styles.length == 1) {
                style = styles[0];
            } else {
                for (Style styleTmp : styles) {
                    if ((!StringUtils.isBlank((CharSequence)styleName) || !styleTmp.isDefault()) && !styleTmp.getName().equals(styleName)) continue;
                    style = styleTmp;
                }
            }
        }
        return style;
    }

    protected Style findStyle(StyledLayerDescriptor styledLayerDescriptor, String layerName, String styleName) {
        Style style = this.findStyle(styledLayerDescriptor, layerName, styleName, null);
        if (style == null) {
            throw new ObserveTechnicalException(String.format("No style found for layer name '%s' and style name '%s'", layerName, styleName));
        }
        return style;
    }
}

