/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe;

import fr.ird.observe.ObserveRunner;
import fr.ird.observe.db.constants.CreationMode;
import fr.ird.observe.db.constants.DbMode;
import java.io.File;
import java.util.Locale;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.i18n.I18n;

public enum ObserveConfigOption implements ConfigOptionDef
{
    CONFIG_FILE("config.file", I18n.n((String)"observe.config.configFileName.description", (Object[])new Object[0]), ObserveRunner.isAdmin() ? "observe-admin-config" : "observe-config", String.class, true, true),
    DATA_DIRECTORY("data.directory", I18n.n((String)"observe.config.defaultDataDirectory.description", (Object[])new Object[0]), "${user.home}/.observe", File.class, false, false),
    DB_DIRECTORY("db.directory", I18n.n((String)"observe.config.defaultLocalDbDirectory.description", (Object[])new Object[0]), "${data.directory}/db", File.class, false, false),
    INITIAL_DB_DUMP("initial.db.dump", I18n.n((String)"observe.config.defaultInitialDbDump.description", (Object[])new Object[0]), "${data.directory}/initial-database.sql.gz", File.class, false, false),
    BACKUP_DIRECTORY("backup.directory", I18n.n((String)"observe.config.defaultBackupDirectory.description", (Object[])new Object[0]), "${data.directory}/backup", File.class, false, false),
    RESOURCES_DIRECTORY("resources.directory", "resourcesDirectory", I18n.n((String)"observe.config.defaultResourcesDirectory.description", (Object[])new Object[0]), "${data.directory}/resources-${version}", File.class, false, false),
    I18N_DIRECTORY("i18n.directory", "i18nDirectory", I18n.n((String)"observe.config.defaultI18nDirectory.description", (Object[])new Object[0]), "${resources.directory}/i18n", File.class, false, false),
    REPORT_DIRECTORY("report.directory", "reportDirectory", I18n.n((String)"observe.config.defaultReportDirectory.description", (Object[])new Object[0]), "${resources.directory}/report", File.class, false, false),
    VALIDATION_REPORT_DIRECTORY("validation.report.directory", "validationReportDirectory", I18n.n((String)"observe.config.defaultValidationReportDirectory.description", (Object[])new Object[0]), "${data.directory}/validation-report", File.class, false, false),
    TMP_DIRECTORY("tmp.directory", I18n.n((String)"observe.config.defaultTmpDirectory.description", (Object[])new Object[0]), "${data.directory}/tmp", File.class, false, false),
    H2_LOGIN("h2.username", I18n.n((String)"observe.config.h2.login.description", (Object[])new Object[0]), "sa", String.class, true, true),
    H2_PASSWORD("h2.password", I18n.n((String)"observe.config.h2.password.description", (Object[])new Object[0]), "sa", String.class, true, true),
    H2_CAN_MIGRATE("h2.canMigrate", I18n.n((String)"observe.config.h2.can.migrate.description", (Object[])new Object[0]), "true", Boolean.class, false, false),
    H2_SERVER_PORT("h2.serverPort", I18n.n((String)"observe.config.h2.serverPort.description", (Object[])new Object[0]), "9093", Integer.class, false, false),
    OBSTUNA_URL("obstuna.url", I18n.n((String)"observe.config.obstuna.url.description", (Object[])new Object[0]), "jdbc:postgresql:///obstuna", String.class, false, false),
    OBSTUNA_LOGIN("obstuna.username", I18n.n((String)"observe.config.obstuna.login.description", (Object[])new Object[0]), "utilisateur", String.class, false, false),
    OBSTUNA_PASSWORD("obstuna.password", I18n.n((String)"observe.config.obstuna.password.description", (Object[])new Object[0]), "", String.class, true, false),
    OBSTUNA_USE_SSL_CERT("obstuna.useSsl", I18n.n((String)"observe.config.obstuna.useSsl.description", (Object[])new Object[0]), "false", Boolean.class, false, false),
    OBSTUNA_CAN_MIGRATE("pg.canMigrate", I18n.n((String)"observe.config.pg.can.migrate.description", (Object[])new Object[0]), "false", Boolean.class, false, false),
    DEFAULT_DB_MODE("defaultDbMode", "defaultDbMode", I18n.n((String)"observe.config.defaultDbMode", (Object[])new Object[0]), DbMode.USE_LOCAL.name(), DbMode.class, false, false),
    DEFAULT_CREATION_MODE("defaultCreationMode", "defaultCreationMode", I18n.n((String)"observe.config.defaultCreationMode", (Object[])new Object[0]), CreationMode.IMPORT_EXTERNAL_DUMP.name(), CreationMode.class, false, false),
    STORE_REMOTE_STORAGE("ui.storeRemoteStorage", "storeRemoteStorage", I18n.n((String)"observe.config.ui.storeRemoteStorage", (Object[])new Object[0]), "true", Boolean.class, false, false),
    LOAD_LOCAL_STORAGE("ui.loadLocalStorage", "loadLocalStorage", I18n.n((String)"observe.config.ui.loadLocalStorage", (Object[])new Object[0]), "true", Boolean.class, false, false),
    SHOW_MIGRATION_PROGRESSION("showMigrationProgression", "showMigrationProgression", I18n.n((String)"observe.config.showMigrationProgression", (Object[])new Object[0]), "true", Boolean.class, false, false),
    SHOW_MIGRATION_SQL("showMigrationSql", "showMigrationSql", I18n.n((String)"observe.config.showMigrationSql", (Object[])new Object[0]), "true", Boolean.class, false, false),
    SHOW_SQL("showSql", "showSql", I18n.n((String)"observe.config.showSql", (Object[])new Object[0]), "false", Boolean.class, false, false),
    DEFAULT_GPS_MAX_DELAY("defaultGpsMaxDelay", "defaultGpsMaxDelay", I18n.n((String)"observe.config.defaultGpsMaxDelay", (Object[])new Object[0]), "60", Integer.class, false, false),
    DEFAULT_GPS_MAX_SPEED("defaultGpsMaxSpeed", "defaultGpsMaxSpeed", I18n.n((String)"observe.config.defaultGpsMaxSpeed", (Object[])new Object[0]), "25.0f", Float.class, false, false),
    CHANGE_SYNCHRO_SRC("ui.changeSynchroSrc", "changeSynchroSrc", I18n.n((String)"observe.config.ui.changeSynchroSrc", (Object[])new Object[0]), "false", Boolean.class, false, false),
    SHOW_NUMBER_EDITOR_BUTTON("ui.showNumberEditorButton", "showNumberEditorButton", I18n.n((String)"observe.config.ui.showNumberEditorButton", (Object[])new Object[0]), "true", Boolean.class, false, false),
    AUTO_POPUP_NUMBER_EDITOR("ui.autoPopupNumberEditor", "autoPopupNumberEditor", I18n.n((String)"observe.config.ui.autoPopupNumberEditor", (Object[])new Object[0]), "false", Boolean.class, false, false),
    FULL_SCREEN("ui.fullScreen", "fullScreen", I18n.n((String)"observe.config.ui.fullscreen", (Object[])new Object[0]), "false", Boolean.class, false, false),
    LOCALE("ui.locale", "locale", I18n.n((String)"observe.config.ui.locale", (Object[])new Object[0]), Locale.FRANCE.toString(), Locale.class, false, false),
    DB_LOCALE("db.locale", "dbLocale", I18n.n((String)"observe.config.db.locale", (Object[])new Object[0]), Locale.FRANCE.toString(), Locale.class, false, false),
    NON_TARGET_OBSERVATION("observation.fauneAssociee", "nonTargetObservation", I18n.n((String)"observe.config.observation.fauneAssociee", (Object[])new Object[0]), "1", Integer.class, false, false),
    TARGET_DISCARDS_OBSERVATION("observation.rejetsThons", "targetDiscardsObservation", I18n.n((String)"observe.config.observation.rejetsThons", (Object[])new Object[0]), "1", Integer.class, false, false),
    SAMPLES_OBSERVATION("observation.mensurations", "samplesObservation", I18n.n((String)"observe.config.observation.mensurations", (Object[])new Object[0]), "1", Integer.class, false, false),
    OBJECTS_OBSERVATION("observation.floatingObject", "objectsObservation", I18n.n((String)"observe.config.observation.floatingObject", (Object[])new Object[0]), "1", Integer.class, false, false),
    DETAILLED_ACTIVITIES_OBSERVATION("observation.activitysDetaillees", "detailledActivitiesObservation", I18n.n((String)"observe.config.observation.activitysDetaillees", (Object[])new Object[0]), "1", Integer.class, false, false),
    MAMMALS_OBSERVATION("observation.mammiferes", "mammalsObservation", I18n.n((String)"observe.config.observation.mammiferes", (Object[])new Object[0]), "1", Integer.class, false, false),
    BIRDS_OBSERVATION("observation.oiseaux", "birdsObservation", I18n.n((String)"observe.config.observation.oiseaux", (Object[])new Object[0]), "1", Integer.class, false, false),
    BAIT_OBSERVATION("observation.gleure", "baitObservation", I18n.n((String)"observe.config.observation.gleure", (Object[])new Object[0]), "1", Integer.class, false, false),
    SPECIES_LIST_SEINE_TARGET_CATCH("speciesList.seine.targetCatch", "speciesListSeineTargetCatch", I18n.n((String)"observe.config.speciesList.seine.targetCatch", (Object[])new Object[0]), "0", Integer.class, false, false),
    SPECIES_LIST_SEINE_SCHOOL_ESTIMATE("speciesList.seine.schoolEstimate", "speciesListSeineSchoolEstimate", I18n.n((String)"observe.config.speciesList.seine.schoolEstimate", (Object[])new Object[0]), "0", Integer.class, false, false),
    SPECIES_LIST_SEINE_OBJECT_SCHOOL_ESTIMATE("speciesList.seine.objectSchoolEstimate", "speciesListSeineObjectSchoolEstimate", I18n.n((String)"observe.config.speciesList.seine.objectSchoolEstimate", (Object[])new Object[0]), "0", Integer.class, false, false),
    SPECIES_LIST_SEINE_NON_TARGET_CATCH("speciesList.seine.nonTargetCatch", "speciesListSeineNonTargetCatch", I18n.n((String)"observe.config.speciesList.seine.nonTargetCatch", (Object[])new Object[0]), "1", Integer.class, false, false),
    SPECIES_LIST_SEINE_OBJECT_OBSERVED_SPECIES("speciesList.seine.objectObservedSpecies", "speciesListSeineObjectObservedSpecies", I18n.n((String)"observe.config.speciesList.seine.objectObservedSpecies", (Object[])new Object[0]), "1", Integer.class, false, false),
    SPECIES_LIST_LONGLINE_CATCH("speciesList.longline.catch", "speciesListLonglineCatch", I18n.n((String)"observe.config.speciesList.longline.catch", (Object[])new Object[0]), "3", Integer.class, false, false),
    SPECIES_LIST_LONGLINE_ENCOUNTER("speciesList.longline.encounter", "speciesListLonglineEncounter", I18n.n((String)"observe.config.speciesList.longline.encounter", (Object[])new Object[0]), "4", Integer.class, false, false);

    protected final String key;
    protected final String propertyKey;
    protected final String description;
    protected final Class<?> type;
    protected String defaultValue;
    protected boolean _transient;
    protected boolean _final;
    protected boolean admin;

    private ObserveConfigOption(String key, String description, String defaultValue, Class<?> type, boolean _transient, boolean _final) {
        this(key, null, description, defaultValue, type, _transient, _final);
    }

    private ObserveConfigOption(String key, String propertyKey, String description, String defaultValue, Class<?> type, boolean _transient, boolean _final) {
        this.key = key;
        this.description = description;
        this.defaultValue = defaultValue;
        this.type = type;
        this._final = _final;
        this._transient = _transient;
        this.propertyKey = propertyKey;
    }

    public boolean isFinal() {
        return this._final;
    }

    public boolean isTransient() {
        return this._transient;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return I18n.t((String)this.description, (Object[])new Object[0]);
    }

    public String getKey() {
        return this.key;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setTransient(boolean _transient) {
        this._transient = _transient;
    }

    public void setFinal(boolean _final) {
        this._final = _final;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }
}

