/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl;

import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.entities.Calee;
import fr.ird.observe.entities.EchantillonFaune;
import fr.ird.observe.entities.TailleFaune;
import fr.ird.observe.entities.constants.ModeSaisieEchantillonEnum;
import fr.ird.observe.entities.constants.SexeEnum;
import fr.ird.observe.entities.referentiel.EspeceFaune;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.table.ContentTableMeta;
import fr.ird.observe.ui.content.table.ContentTableModel;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.ContentTableUIModel;
import fr.ird.observe.ui.content.table.impl.EchantillonFauneUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.validator.NuitonValidatorScope;

public class EchantillonFauneUIHandler
extends ContentTableUIHandler<EchantillonFaune, TailleFaune> {
    private static Log log = LogFactory.getLog(EchantillonFauneUIHandler.class);
    protected final JAXXContextEntryDef<List<EspeceFaune>> ALL_ESPECES_ENTRY = UIHelper.newListContextEntryDef((String)"EchantillonFauneUI-all-especes");
    protected final PropertyChangeListener poidsChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TailleFaune source = (TailleFaune)evt.getSource();
            source.setPoidsCalcule(false);
        }
    };
    protected final PropertyChangeListener longueurChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TailleFaune source = (TailleFaune)evt.getSource();
            source.setLongueurCalcule(false);
        }
    };

    public static ContentTableUIModel<EchantillonFaune, TailleFaune> newModel(EchantillonFauneUI ui) {
        return new ContentTableUIModel<EchantillonFaune, TailleFaune>(EchantillonFaune.class, TailleFaune.class, new String[]{"tailleFaune", "commentaire"}, new String[]{"espece", "longueur", "longueurCalcule", "poids", "poidsCalcule", "sexe", "effectif", "modeSaisie", "referencePhoto"}, ui, ContentTableModel.newTableMeta(TailleFaune.class, "espece", false), ContentTableModel.newTableMeta(TailleFaune.class, "longueur", false), ContentTableModel.newTableMeta(TailleFaune.class, "poids", false), ContentTableModel.newTableMeta(TailleFaune.class, "effectif", false), new ContentTableMeta<TailleFaune>(TailleFaune.class, "sexe", false){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isNullValue(ContentTableModel<?, ?> m, TailleFaune bean, int row) {
                return bean.getSexe() == -1;
            }
        }, ContentTableModel.newTableMeta(TailleFaune.class, "referencePhoto", false));
    }

    public EchantillonFauneUIHandler(EchantillonFauneUI ui) {
        super(ui);
    }

    @Override
    public EchantillonFauneUI getUi() {
        return (EchantillonFauneUI)super.getUi();
    }

    public void resetPoidsCalcule() {
        ((TailleFaune)this.getTableEditBean()).setPoidsCalcule(false);
        this.getUi().getPoids().grabFocus();
    }

    public void resetLongueurCalcule() {
        ((TailleFaune)this.getTableEditBean()).setLongueurCalcule(false);
        this.getUi().getLongueur().grabFocus();
    }

    @Override
    protected EchantillonFaune loadEditBean(ContentMode mode, DataContext dataContext, DataService dataService, DataSource dataSource) throws DataSourceException {
        String caleeId = dataContext.getSelectedCaleeId();
        List especes = mode == ContentMode.UPDATE ? dataService.getAvailableEspeceForEchantillonFaune(dataSource, caleeId) : new ArrayList();
        this.ALL_ESPECES_ENTRY.setContextValue((JAXXContext)this.getUi(), especes);
        String id = dataService.getEchantillonFauneId(dataSource, caleeId);
        EchantillonFaune editBean = (EchantillonFaune)this.getBean();
        if (log.isInfoEnabled()) {
            log.info((Object)(this.prefix + " - calee id             : " + caleeId));
            log.info((Object)(this.prefix + " - echantillon faune id : " + id));
            log.info((Object)(this.prefix + " - edit bean id         : " + editBean.getTopiaId()));
        }
        if (id == null) {
            this.getLoadBinder().load(null, (TopiaEntity)editBean, true, new String[0]);
            this.getChildsUpdator().setChilds((TopiaEntity)editBean, new ArrayList());
        } else {
            dataService.loadEditEntity(dataSource, id, this.getLoadExecutor());
        }
        this.getModel().setMode(mode);
        this.getUi().getTableModel().attachModel();
        return editBean;
    }

    @Override
    protected boolean prepareSave(EchantillonFaune bean, List<TailleFaune> objets) throws DataSourceException {
        if (bean.getTopiaId() == null) {
            String caleeId = this.getDataContext().getSelectedCaleeId();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will create echantillon faune " + bean + " for " + caleeId));
            }
            this.getDataService().create(this.getDataSource(), caleeId, (TopiaEntity)bean, null, this.getCreateExecutor());
        }
        return true;
    }

    @Override
    protected EchantillonFaune onCreate(TopiaContext tx, Object parent, EchantillonFaune editBean) throws TopiaException {
        Calee parentBean = (Calee)parent;
        EchantillonFaune beanToSave = (EchantillonFaune)ObserveDAOHelper.getEchantillonFauneDAO((TopiaContext)tx).create(new Object[0]);
        if (log.isInfoEnabled()) {
            log.info((Object)("Echantillon faune " + beanToSave.getTopiaId() + " was created."));
        }
        editBean.setTopiaId(beanToSave.getTopiaId());
        editBean.setTopiaCreateDate(beanToSave.getTopiaCreateDate());
        editBean.setTopiaVersion(beanToSave.getTopiaVersion());
        parentBean.addEchantillonFaune(beanToSave);
        return beanToSave;
    }

    @Override
    protected void onSelectedRowChanged(int editingRow, TailleFaune bean, boolean create) {
        BeanComboBox<EspeceFaune> requestFocus;
        List<Object> availableEspeces;
        ContentTableModel model = this.getTableModel();
        if (!model.isEditable()) {
            return;
        }
        EspeceFaune espece = bean.getEspece();
        EchantillonFauneUI ui = this.getUi();
        if (log.isDebugEnabled()) {
            log.debug((Object)("selected espece " + espece));
        }
        if (create) {
            if (model.isCreate()) {
                ui.getModeSaisieGroup().setSelectedValue(null);
                ui.getModeSaisieGroup().setSelectedValue((Object)ModeSaisieEchantillonEnum.byEffectif);
            }
            availableEspeces = new ArrayList((Collection)this.ALL_ESPECES_ENTRY.getContextValue((JAXXContext)ui));
            requestFocus = ui.getEspece();
        } else {
            requestFocus = ui.getEffectif();
            int modeSaisie = bean.getModeSaisie();
            ModeSaisieEchantillonEnum enumValue = ModeSaisieEchantillonEnum.valueOf((int)modeSaisie);
            ui.getModeSaisieGroup().setSelectedValue(null);
            ui.getModeSaisieGroup().setSelectedValue((Object)enumValue);
            availableEspeces = Arrays.asList(espece);
        }
        ui.getEspece().setData(availableEspeces);
        requestFocus.requestFocus();
        TailleFaune tableEditBean = (TailleFaune)this.getTableEditBean();
        tableEditBean.removePropertyChangeListener("poids", this.poidsChanged);
        tableEditBean.addPropertyChangeListener("poids", this.poidsChanged);
        tableEditBean.removePropertyChangeListener("longueur", this.longueurChanged);
        tableEditBean.addPropertyChangeListener("longueur", this.longueurChanged);
    }

    @Override
    protected void initTableUI(DefaultTableCellRenderer renderer) {
        JTable table = this.getUi().getTable();
        UIHelper.fixTableColumnWidth((JTable)table, (int)1, (int)100);
        UIHelper.fixTableColumnWidth((JTable)table, (int)2, (int)100);
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n_((String)"observe.table.echantillonFaune.especeFaune", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonFaune.especeFaune.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonFaune.longueur", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonFaune.longueur.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonFaune.poidsIndividuel", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonFaune.poidsIndividuel.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonFaune.effectif", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonFaune.effectif.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonFaune.sexe", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonFaune.sexe.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonFaune.referencePhoto", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonFaune.referencePhoto.tip", (Object[])new Object[0])});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, EspeceFaune.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)3, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)4, (TableCellRenderer)UIHelper.newEnumTableCellRenderer((TableCellRenderer)renderer, SexeEnum.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)5, (TableCellRenderer)renderer);
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        boolean showData;
        ContentMode mode;
        block3: {
            mode = super.getContentMode(dataContext);
            showData = false;
            try {
                String caleeId = this.getDataContext().getSelectedCaleeId();
                showData = this.getDataService().canUseEchantillonFaune(this.getDataSource(), caleeId);
            }
            catch (DataSourceException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)e);
            }
        }
        ((ContentTableUIModel)this.getUi().getModel()).setShowData(showData);
        if (mode == ContentMode.UPDATE && !showData) {
            mode = ContentMode.READ;
            EchantillonFauneUIHandler.addMessage(this.getUi(), NuitonValidatorScope.INFO, this.getEntityLabel(Calee.class), I18n._((String)"observe.message.calee.no.rejetFaune", (Object[])new Object[0]));
        }
        return mode;
    }

    public void updateModeSaisie(ModeSaisieEchantillonEnum newMode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Change mode saisie to " + newMode));
        }
        if (newMode == null) {
            return;
        }
        EchantillonFauneUI ui = this.getUi();
        boolean createMode = ui.getTableModel().isCreate();
        TailleFaune editBean = ui.getTableEditBean();
        switch (newMode) {
            case byEffectif: {
                ui.getPoids().setEnabled(false);
                ui.getEffectif().setEnabled(true);
                if (!createMode) break;
                editBean.setPoids(null);
                editBean.setEffectif(null);
                break;
            }
            case byIndividu: {
                ui.getPoids().setEnabled(true);
                ui.getEffectif().setEnabled(false);
                if (!createMode) break;
                editBean.setEffectif(Integer.valueOf(1));
            }
        }
        if (createMode) {
            editBean.setModeSaisie(newMode.ordinal());
        }
    }
}

