/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl;

import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.entities.Calee;
import fr.ird.observe.entities.CaptureFaune;
import fr.ird.observe.entities.EchantillonFaune;
import fr.ird.observe.entities.TailleFaune;
import fr.ird.observe.entities.constants.CaptureFauneComputedValueSourceEnum;
import fr.ird.observe.entities.referentiel.DevenirFaune;
import fr.ird.observe.entities.referentiel.EspeceFaune;
import fr.ird.observe.entities.referentiel.Especes;
import fr.ird.observe.entities.referentiel.Ocean;
import fr.ird.observe.entities.referentiel.RaisonRejet;
import fr.ird.observe.entities.referentiel.ReferentielEntities;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.table.ContentTableModel;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.ContentTableUIModel;
import fr.ird.observe.ui.content.table.impl.CaptureFauneUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.decorator.Decorator;

public class CaptureFauneUIHandler
extends ContentTableUIHandler<Calee, CaptureFaune> {
    private static Log log = LogFactory.getLog(CaptureFauneUIHandler.class);
    protected final JAXXContextEntryDef<List<EspeceFaune>> ALL_ESPECES_ENTRY = UIHelper.newListContextEntryDef((String)"CaptureFauneUI-all-especes");
    protected final JAXXContextEntryDef<List<TailleFaune>> ALL_TAILLES_TO_DELETE_ENTRY = UIHelper.newListContextEntryDef((String)"CaptureFauneUI-all-taille-to-delete");
    protected final PropertyChangeListener nombreEstimeChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CaptureFaune source = (CaptureFaune)evt.getSource();
            source.setNombreEstimeCalculeSource(null);
        }
    };
    protected final PropertyChangeListener poidsEstimeChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CaptureFaune source = (CaptureFaune)evt.getSource();
            source.setPoidsEstimeCalculeSource(null);
        }
    };
    protected final PropertyChangeListener poidsMoyenChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CaptureFaune source = (CaptureFaune)evt.getSource();
            source.setPoidsMoyenCalculeSource(null);
        }
    };
    protected final PropertyChangeListener tailleMoyenneChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CaptureFaune source = (CaptureFaune)evt.getSource();
            source.setTailleMoyenneCalculeSource(null);
        }
    };

    public static ContentTableUIModel<Calee, CaptureFaune> newModel(CaptureFauneUI ui) {
        return new ContentTableUIModel<Calee, CaptureFaune>(Calee.class, CaptureFaune.class, new String[]{"captureFaune", "rejetFaune"}, new String[]{"espece", "poidsEstime", "nombreEstime", "poidsMoyen", "tailleMoyenne", "raisonRejet", "devenirFaune", "nombreEstimeCalculeSource", "poidsMoyenCalculeSource", "poidsEstimeCalculeSource", "tailleMoyenneCalculeSource", "commentaire"}, ui, ContentTableModel.newTableMeta(CaptureFaune.class, "espece", false), ContentTableModel.newTableMeta(CaptureFaune.class, "devenirFaune", false), ContentTableModel.newTableMeta(CaptureFaune.class, "raisonRejet", false), ContentTableModel.newTableMeta(CaptureFaune.class, "poidsEstime", false), ContentTableModel.newTableMeta(CaptureFaune.class, "nombreEstime", false), ContentTableModel.newTableMeta(CaptureFaune.class, "poidsMoyen", false), ContentTableModel.newTableMeta(CaptureFaune.class, "tailleMoyenne", false), ContentTableModel.newTableMeta(CaptureFaune.class, "commentaire", false));
    }

    public CaptureFauneUIHandler(CaptureFauneUI ui) {
        super(ui);
    }

    @Override
    public CaptureFauneUI getUi() {
        return (CaptureFauneUI)super.getUi();
    }

    public String getPoidsEstimeDataTip(CaptureFauneComputedValueSourceEnum computed) {
        String result = computed == null ? I18n._((String)"observe.common.poidsEstimeCalcule.observed.tip", (Object[])new Object[0]) : I18n._((String)"observe.common.poidsEstimeCalcule.computed.tip", (Object[])new Object[]{computed.toString()});
        return result;
    }

    public String getNombreEstimeDataTip(CaptureFauneComputedValueSourceEnum computed) {
        String result = computed == null ? I18n._((String)"observe.common.nombreEstimeCalcule.observed.tip", (Object[])new Object[0]) : I18n._((String)"observe.common.nombreEstimeCalcule.computed.tip", (Object[])new Object[]{computed.toString()});
        return result;
    }

    public String getPoidsMoyenDataTip(CaptureFauneComputedValueSourceEnum computed) {
        String result = computed == null ? I18n._((String)"observe.common.poidsMoyenCalcule.observed.tip", (Object[])new Object[0]) : I18n._((String)"observe.common.poidsMoyenCalcule.computed.tip", (Object[])new Object[]{computed.toString()});
        return result;
    }

    public String getTailleMoyenneDataTip(CaptureFauneComputedValueSourceEnum computed) {
        String result = computed == null ? I18n._((String)"observe.common.tailleMoyenneCalcule.observed.tip", (Object[])new Object[0]) : I18n._((String)"observe.common.tailleMoyenneCalcule.computed.tip", (Object[])new Object[]{computed.toString()});
        return result;
    }

    public void resetPoidsEstimeCalcule() {
        ((CaptureFaune)this.getTableEditBean()).setPoidsEstimeCalculeSource(null);
        this.getUi().getPoidsEstime().grabFocus();
    }

    public void resetNombreEstimeCalcule() {
        ((CaptureFaune)this.getTableEditBean()).setNombreEstimeCalculeSource(null);
        this.getUi().getNombreEstime().grabFocus();
    }

    public void resetPoidsMoyenCalcule() {
        ((CaptureFaune)this.getTableEditBean()).setPoidsMoyenCalculeSource(null);
        this.getUi().getPoidsMoyen().grabFocus();
    }

    public void resetTailleMoyenneCalcule() {
        ((CaptureFaune)this.getTableEditBean()).setTailleMoyenneCalculeSource(null);
        this.getUi().getTailleMoyenne().grabFocus();
    }

    @Override
    protected Calee loadEditBean(ContentMode mode, DataContext dataContext, DataService dataService, DataSource dataSource) throws DataSourceException {
        List especeList;
        if (mode == ContentMode.UPDATE) {
            Ocean ocean = dataService.getMareeOcean(dataSource, dataContext.getSelectedMareeId());
            List allSpecies = dataService.loadDecoratedEntities(dataSource, EspeceFaune.class);
            ReferentielEntities.filterReferentielListByStatus((List)allSpecies);
            especeList = Especes.filterByOcean((Collection)allSpecies, (Ocean)ocean);
        } else {
            especeList = new ArrayList();
        }
        this.ALL_ESPECES_ENTRY.setContextValue((JAXXContext)this.getUi(), especeList);
        if (log.isDebugEnabled()) {
            log.debug((Object)("especeList = " + especeList.size()));
        }
        return (Calee)super.loadEditBean(mode, dataContext, dataService, dataSource);
    }

    @Override
    protected void onSelectedRowChanged(int editingRow, CaptureFaune bean, boolean create) {
        Object requestFocus;
        List<Object> availableEspeces;
        CaptureFauneUI ui = this.getUi();
        ContentTableModel model = this.getTableModel();
        if (!model.isEditable()) {
            return;
        }
        if (create) {
            availableEspeces = new ArrayList((Collection)this.ALL_ESPECES_ENTRY.getContextValue((JAXXContext)ui));
            requestFocus = ui.getEspece();
        } else {
            EspeceFaune espece = bean.getEspece();
            availableEspeces = Arrays.asList(espece);
            requestFocus = ui.getTable();
        }
        ui.getEspece().setData(availableEspeces);
        ((JComponent)requestFocus).requestFocus();
        CaptureFaune tableEditBean = (CaptureFaune)this.getTableEditBean();
        tableEditBean.removePropertyChangeListener("nombreEstime", this.nombreEstimeChanged);
        tableEditBean.addPropertyChangeListener("nombreEstime", this.nombreEstimeChanged);
        tableEditBean.removePropertyChangeListener("poidsEstime", this.poidsEstimeChanged);
        tableEditBean.addPropertyChangeListener("poidsEstime", this.poidsEstimeChanged);
        tableEditBean.removePropertyChangeListener("poidsMoyen", this.poidsMoyenChanged);
        tableEditBean.addPropertyChangeListener("poidsMoyen", this.poidsMoyenChanged);
        tableEditBean.removePropertyChangeListener("tailleMoyenne", this.tailleMoyenneChanged);
        tableEditBean.addPropertyChangeListener("tailleMoyenne", this.tailleMoyenneChanged);
    }

    @Override
    protected void initTableUI(DefaultTableCellRenderer renderer) {
        JTable table = this.getUi().getTable();
        UIHelper.fixTableColumnWidth((JTable)table, (int)3, (int)55);
        UIHelper.fixTableColumnWidth((JTable)table, (int)4, (int)65);
        UIHelper.fixTableColumnWidth((JTable)table, (int)5, (int)75);
        UIHelper.fixTableColumnWidth((JTable)table, (int)6, (int)55);
        UIHelper.fixTableColumnWidth((JTable)table, (int)7, (int)50);
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n_((String)"observe.table.captureFaune.especeFaune", (Object[])new Object[0]), I18n.n_((String)"observe.table.captureFaune.especeFaune.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.captureFaune.devenirFaune", (Object[])new Object[0]), I18n.n_((String)"observe.table.captureFaune.devenirFaune.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.captureFaune.raisonRejet", (Object[])new Object[0]), I18n.n_((String)"observe.table.captureFaune.raisonRejet.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.captureFaune.poidsEstime", (Object[])new Object[0]), I18n.n_((String)"observe.table.captureFaune.poidsEstime.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.captureFaune.nombreEstime", (Object[])new Object[0]), I18n.n_((String)"observe.table.captureFaune.nombreEstime.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.captureFaune.poidsMoyen", (Object[])new Object[0]), I18n.n_((String)"observe.table.captureFaune.poidsMoyen.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.captureFaune.tailleMoyenne", (Object[])new Object[0]), I18n.n_((String)"observe.table.captureFaune.tailleMoyenne.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.captureFaune.commentaire", (Object[])new Object[0]), I18n.n_((String)"observe.table.captureFaune.commentaire.tip", (Object[])new Object[0])});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, EspeceFaune.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, DevenirFaune.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, RaisonRejet.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)3, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)4, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)5, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)6, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)7, (TableCellRenderer)UIHelper.newStringTableCellRenderer((DefaultTableCellRenderer)renderer, (int)10, (boolean)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doSave(Calee bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<Calee> binder) throws Exception {
        try {
            boolean bl = super.doSave(bean, dataService, dataSource, binder);
            return bl;
        }
        finally {
            this.ALL_TAILLES_TO_DELETE_ENTRY.removeContextValue((JAXXContext)this.getUi());
        }
    }

    @Override
    protected boolean prepareSave(Calee editBean, List<CaptureFaune> objets) throws Exception {
        super.prepareSave(editBean, objets);
        List especesUsed = this.getTableModel().getColumnValues(0);
        HashSet especesToDelete = new HashSet();
        ArrayList tailleToDelete = new ArrayList();
        this.getDataService().getObsoleteEspeceForEchantillonFaune(this.getDataSource(), editBean.getTopiaId(), especesUsed, especesToDelete, tailleToDelete);
        if (!tailleToDelete.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            StringBuilder sb2 = new StringBuilder();
            Decorator decorator = this.getDecoratorService().getDecoratorByType(EspeceFaune.class);
            Decorator decorator2 = this.getDecoratorService().getDecoratorByType(TailleFaune.class);
            for (EspeceFaune e : especesToDelete) {
                sb.append("  - ").append(decorator.toString((Object)e)).append('\n');
            }
            for (TailleFaune t : tailleToDelete) {
                sb2.append("  - ").append(decorator2.toString((Object)t)).append('\n');
            }
            int reponse = UIHelper.askUser(I18n._((String)"observe.title.need.confirm", (Object[])new Object[0]), I18n._((String)"observe.message.table.captureFaune.will.delete.tailleFaune", (Object[])new Object[]{sb.toString(), sb2.toString()}), 0, new Object[]{I18n._((String)"observe.choice.continue", (Object[])new Object[0]), I18n._((String)"observe.choice.cancel", (Object[])new Object[0])}, 0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("response : " + reponse));
            }
            boolean canContinue = false;
            switch (reponse) {
                case 0: {
                    canContinue = true;
                }
            }
            if (!canContinue) {
                return false;
            }
            this.ALL_TAILLES_TO_DELETE_ENTRY.setContextValue((JAXXContext)this.getUi(), tailleToDelete);
        }
        boolean hasRejet = false;
        for (CaptureFaune c : objets) {
            if (c.getRaisonRejet() == null) continue;
            hasRejet = true;
            break;
        }
        editBean.setRejetFaune(Boolean.valueOf(hasRejet));
        return true;
    }

    @Override
    protected void onUpdateFinalize(TopiaContext tx, Calee bean, Collection<CaptureFaune> oldChilds) {
        List tailleToDelete = (List)this.ALL_TAILLES_TO_DELETE_ENTRY.getContextValue((JAXXContext)this.getUi());
        if (tailleToDelete != null && !tailleToDelete.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Will remove " + tailleToDelete.size() + " obsolete tailleFaune(s)."));
            }
            EchantillonFaune echantillon = (EchantillonFaune)bean.getEchantillonFaune().get(0);
            echantillon.getTailleFaune().removeAll(tailleToDelete);
        }
    }
}

