/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.storage.tabs;

import fr.ird.observe.services.storage.constants.ConnexionStatus;
import fr.ird.observe.services.storage.constants.DbMode;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.storage.StorageStep;
import fr.ird.observe.ui.storage.StorageUIModel;
import fr.ird.observe.ui.storage.tabs.AbstractStorageTabPanelUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.text.JTextComponent;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.Table;
import org.nuiton.i18n.I18n;

public class ConfigStoragePanelUI
extends AbstractStorageTabPanelUI {
    public static final String BINDING_CONNEXION_STATUS_LABEL_ICON = "connexionStatusLabel.icon";
    public static final String BINDING_CONNEXION_STATUS_LABEL_TEXT = "connexionStatusLabel.text";
    public static final String BINDING_CONNEXION_STATUS_PANEL_BORDER = "connexionStatusPanel.border";
    public static final String BINDING_CONNEXION_STATUS_TEXT = "connexionStatus.text";
    public static final String BINDING_DUMP_FILE_TEXT = "dumpFile.text";
    public static final String BINDING_REMOTE_LOGIN_TEXT = "remoteLogin.text";
    public static final String BINDING_REMOTE_PASSWORD_TEXT = "remotePassword.text";
    public static final String BINDING_REMOTE_SSL_CERTIFICAT_FILE_CHOOSEACTION_ENABLED = "remoteSslCertificatFileChooseaction.enabled";
    public static final String BINDING_REMOTE_SSL_CERTIFICAT_FILE_ENABLED = "remoteSslCertificatFile.enabled";
    public static final String BINDING_REMOTE_SSL_CERTIFICAT_FILE_TEXT = "remoteSslCertificatFile.text";
    public static final String BINDING_REMOTE_SSL_CERTIFICAT_PASSWORD_ENABLED = "remoteSslCertificatPassword.enabled";
    public static final String BINDING_REMOTE_SSL_CERTIFICAT_PASSWORD_TEXT = "remoteSslCertificatPassword.text";
    public static final String BINDING_REMOTE_URL_TEXT = "remoteUrl.text";
    public static final String BINDING_REMOTE_USE_SSL_SELECTED = "remoteUseSsl.selected";
    public static final String BINDING_STORE_REMOTE_CONFIG_SELECTED = "storeRemoteConfig.selected";
    public static final String BINDING_TEST_REMOTE_ACTION_ENABLED = "testRemoteAction.enabled";
    private static final String $jaxxObjectDescriptor = "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";
    private static final long serialVersionUID = 1L;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected Table IMPORT_EXTERNAL_DUMP;
    protected Table IMPORT_REMOTE_STORAGE;
    protected JPanel IMPORT_REMOTE_STORAGE_content;
    protected Table USE_REMOTE;
    protected JPanel USE_REMOTE_content;
    protected JPanel configContent;
    protected CardLayout configLayout;
    protected JTextArea connexionStatus;
    protected JLabel connexionStatusLabel;
    protected JScrollPane connexionStatusPanel;
    protected JTextField dumpFile;
    protected JButton fileChooserAction;
    protected JPanel remoteConfig;
    protected JTextField remoteLogin;
    protected JPasswordField remotePassword;
    protected JTextField remoteSslCertificatFile;
    protected JButton remoteSslCertificatFileChooseaction;
    protected JPasswordField remoteSslCertificatPassword;
    protected JTextField remoteUrl;
    protected JCheckBox remoteUseSsl;
    protected JCheckBox storeRemoteConfig;
    protected JButton testRemoteAction;
    private ConfigStoragePanelUI $AbstractStorageTabPanelUI0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JPanel $JPanel0;
    private Table $Table0;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private Table $Table1;
    private Table $Table2;
    private JLabel $JLabel6;
    private Table $Table3;

    public void refreshConfig(String configId) {
        JComponent c = (JComponent)this.getObjectById(configId);
        if (c != null) {
            log.debug((Object)configId);
            this.configLayout.show(this.configContent, configId);
            String text = (String)c.getClientProperty("description");
            this.setDescriptionText(I18n._((String)text));
            if (c == this.IMPORT_REMOTE_STORAGE) {
                this.IMPORT_REMOTE_STORAGE_content.add((Component)this.remoteConfig, "Center");
            } else if (c == this.USE_REMOTE) {
                this.USE_REMOTE_content.add((Component)this.remoteConfig, "Center");
            }
        }
    }

    public Icon updateConnexionStatutIcon(ConnexionStatus status) {
        Icon icon = (Icon)this.connexionStatus.getClientProperty(status.name().toLowerCase() + "Icon");
        return icon;
    }

    public Color updateConnexionStatutColor(ConnexionStatus status) {
        Color color = (Color)this.connexionStatus.getClientProperty(status.name().toLowerCase() + "Color");
        return color;
    }

    public String updateConnexionStatutText(ConnexionStatus status) {
        String text = status.getDescription();
        switch (status) {
            case UNTESTED: {
                text = I18n._((String)text);
                break;
            }
            case SUCCESS: {
                text = I18n._((String)text, (Object[])new Object[]{this.model.getPgConfig().toString()});
                break;
            }
            case FAILED: {
                text = I18n._((String)text, (Object[])new Object[]{this.model.getPgConfig().getConnexionError().getMessage()});
            }
        }
        return text;
    }

    public void chooseDumpFile() {
        File f = UIHelper.chooseFile(this, I18n._((String)"observe.title.choose.db.dump"), I18n._((String)"observe.action.choose.db.dump"), this.getModel().getDumpFile(), "^.+\\.sql\\.gz$", I18n._((String)"observe.action.choose.db.dump.description"));
        this.getModel().setDumpFile(f);
    }

    public void chooseSslCertificatFile() {
        File f = UIHelper.chooseFile(this, I18n._((String)"observe.title.choose.ssl.cert"), I18n._((String)"observe.action.choose.ssl.cert"), this.getModel().getSslCertificatFile(), "^.+\\.jks$", I18n._((String)"observe.action.choose.ssl.cert.description"));
        this.getModel().setSslCertificatFile(f);
    }

    void $afterCompleteSetup() {
        this.getModel().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StorageUIModel model = (StorageUIModel)((Object)evt.getSource());
                String propertyName = evt.getPropertyName();
                if ("creationMode".equals(propertyName) || "dbMode".equals(propertyName)) {
                    String id = null;
                    if (model.getDbMode() == DbMode.USE_REMOTE) {
                        id = DbMode.USE_REMOTE.name();
                    } else if (model.getCreationMode() != null) {
                        id = model.getCreationMode().name();
                    }
                    if (id != null) {
                        ConfigStoragePanelUI.this.refreshConfig(id);
                    }
                }
            }
        });
    }

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor((String)$jaxxObjectDescriptor);
    }

    public ConfigStoragePanelUI() {
        this.$initialize();
    }

    public ConfigStoragePanelUI(JAXXContext parentContext) {
        super(parentContext);
        this.$initialize();
    }

    public void doActionPerformed__on__fileChooserAction(ActionEvent event) {
        this.chooseDumpFile();
    }

    public void doActionPerformed__on__remoteSslCertificatFileChooseaction(ActionEvent event) {
        this.chooseSslCertificatFile();
    }

    public void doActionPerformed__on__remoteUseSsl(ActionEvent event) {
        this.getModel().setUseSsl(((JCheckBox)event.getSource()).isSelected());
    }

    public void doActionPerformed__on__storeRemoteConfig(ActionEvent event) {
        this.getModel().setStoreRemoteConfig(((JCheckBox)event.getSource()).isSelected());
    }

    public void doActionPerformed__on__testRemoteAction(ActionEvent event) {
        this.getHandler().testRemote((JAXXContext)this, this.getModel());
    }

    public void doKeyReleased__on__dumpFile(KeyEvent event) {
        this.getModel().setDumpFile(new File(((JTextField)event.getSource()).getText()));
    }

    public void doKeyReleased__on__remoteLogin(KeyEvent event) {
        this.getModel().setRemoteLogin(((JTextField)event.getSource()).getText());
    }

    public void doKeyReleased__on__remotePassword(KeyEvent event) {
        this.getModel().setRemotePassword(((JPasswordField)event.getSource()).getPassword());
    }

    public void doKeyReleased__on__remoteSslCertificatFile(KeyEvent event) {
        this.getModel().setSslCertificatFile(new File(((JTextField)event.getSource()).getText()));
    }

    public void doKeyReleased__on__remoteSslCertificatPassword(KeyEvent event) {
        this.getModel().setSslCertificatPassword(((JPasswordField)event.getSource()).getPassword());
    }

    public void doKeyReleased__on__remoteUrl(KeyEvent event) {
        this.getModel().setRemoteUrl(((JTextField)event.getSource()).getText());
    }

    public JPanel getConfigContent() {
        return this.configContent;
    }

    public CardLayout getConfigLayout() {
        return this.configLayout;
    }

    public JTextArea getConnexionStatus() {
        return this.connexionStatus;
    }

    public JLabel getConnexionStatusLabel() {
        return this.connexionStatusLabel;
    }

    public JScrollPane getConnexionStatusPanel() {
        return this.connexionStatusPanel;
    }

    public JTextField getDumpFile() {
        return this.dumpFile;
    }

    public JButton getFileChooserAction() {
        return this.fileChooserAction;
    }

    public Table getIMPORT_EXTERNAL_DUMP() {
        return this.IMPORT_EXTERNAL_DUMP;
    }

    public Table getIMPORT_REMOTE_STORAGE() {
        return this.IMPORT_REMOTE_STORAGE;
    }

    public JPanel getIMPORT_REMOTE_STORAGE_content() {
        return this.IMPORT_REMOTE_STORAGE_content;
    }

    public JPanel getRemoteConfig() {
        return this.remoteConfig;
    }

    public JTextField getRemoteLogin() {
        return this.remoteLogin;
    }

    public JPasswordField getRemotePassword() {
        return this.remotePassword;
    }

    public JTextField getRemoteSslCertificatFile() {
        return this.remoteSslCertificatFile;
    }

    public JButton getRemoteSslCertificatFileChooseaction() {
        return this.remoteSslCertificatFileChooseaction;
    }

    public JPasswordField getRemoteSslCertificatPassword() {
        return this.remoteSslCertificatPassword;
    }

    public JTextField getRemoteUrl() {
        return this.remoteUrl;
    }

    public JCheckBox getRemoteUseSsl() {
        return this.remoteUseSsl;
    }

    public JCheckBox getStoreRemoteConfig() {
        return this.storeRemoteConfig;
    }

    public JButton getTestRemoteAction() {
        return this.testRemoteAction;
    }

    public Table getUSE_REMOTE() {
        return this.USE_REMOTE;
    }

    public JPanel getUSE_REMOTE_content() {
        return this.USE_REMOTE_content;
    }

    protected JLabel get$JLabel0() {
        return this.$JLabel0;
    }

    protected JLabel get$JLabel1() {
        return this.$JLabel1;
    }

    protected JLabel get$JLabel2() {
        return this.$JLabel2;
    }

    @Override
    protected JPanel get$JPanel0() {
        return this.$JPanel0;
    }

    protected Table get$Table0() {
        return this.$Table0;
    }

    protected JLabel get$JLabel3() {
        return this.$JLabel3;
    }

    protected JLabel get$JLabel4() {
        return this.$JLabel4;
    }

    protected JLabel get$JLabel5() {
        return this.$JLabel5;
    }

    protected Table get$Table1() {
        return this.$Table1;
    }

    protected Table get$Table2() {
        return this.$Table2;
    }

    protected JLabel get$JLabel6() {
        return this.$JLabel6;
    }

    protected Table get$Table3() {
        return this.$Table3;
    }

    protected void addChildrenToConfigContent() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.configContent.add((Component)this.IMPORT_EXTERNAL_DUMP, "IMPORT_EXTERNAL_DUMP");
        this.configContent.add((Component)this.IMPORT_REMOTE_STORAGE, "IMPORT_REMOTE_STORAGE");
        this.configContent.add((Component)this.USE_REMOTE, "USE_REMOTE");
        this.configContent.add((Component)this.$JPanel0, "$$hideme$$");
    }

    protected void addChildrenToConnexionStatusPanel() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.connexionStatusPanel.getViewport().add(this.connexionStatus);
    }

    protected void addChildrenToContent() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.content.add((Component)this.configContent, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToIMPORT_EXTERNAL_DUMP() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.IMPORT_EXTERNAL_DUMP.add((Component)this.$JLabel0, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.IMPORT_EXTERNAL_DUMP.add((Component)this.dumpFile, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.IMPORT_EXTERNAL_DUMP.add((Component)this.fileChooserAction, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToIMPORT_REMOTE_STORAGE() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.IMPORT_REMOTE_STORAGE.add((Component)this.$JLabel1, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.IMPORT_REMOTE_STORAGE.add((Component)this.IMPORT_REMOTE_STORAGE_content, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToRemoteConfig() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.remoteConfig.add((Component)this.$Table0, "Center");
        this.remoteConfig.add((Component)this.$Table3, "South");
    }

    protected void addChildrenToUSE_REMOTE() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.USE_REMOTE.add((Component)this.$JLabel2, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.USE_REMOTE.add((Component)this.USE_REMOTE_content, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createConfigContent() {
        this.configContent = new JPanel();
        this.$objectMap.put("configContent", this.configContent);
        this.configContent.setName("configContent");
        this.configContent.setLayout(this.configLayout);
    }

    protected void createConfigLayout() {
        this.configLayout = new CardLayout();
        this.$objectMap.put("configLayout", this.configLayout);
    }

    protected void createConnexionStatus() {
        this.connexionStatus = new JTextArea();
        this.$objectMap.put("connexionStatus", this.connexionStatus);
        this.connexionStatus.setName("connexionStatus");
        this.connexionStatus.setColumns(15);
        this.connexionStatus.setLineWrap(true);
        this.connexionStatus.setWrapStyleWord(true);
        this.connexionStatus.setFocusable(false);
        if (this.connexionStatus.getFont() != null) {
            this.connexionStatus.setFont(this.connexionStatus.getFont().deriveFont(11.0f));
        }
        this.connexionStatus.setEditable(false);
        this.connexionStatus.setRows(4);
        this.connexionStatus.putClientProperty("failedColor", Color.RED);
        this.connexionStatus.putClientProperty("failedIcon", SwingUtil.getUIManagerActionIcon((String)"connect_no"));
        this.connexionStatus.putClientProperty("untestedIcon", SwingUtil.getUIManagerActionIcon((String)"connect_untested"));
        this.connexionStatus.putClientProperty("successIcon", SwingUtil.getUIManagerActionIcon((String)"connect_ok"));
        this.connexionStatus.putClientProperty("successColor", Color.GREEN);
        this.connexionStatus.putClientProperty("untestedColor", Color.GRAY);
    }

    protected void createConnexionStatusLabel() {
        this.connexionStatusLabel = new JLabel();
        this.$objectMap.put("connexionStatusLabel", this.connexionStatusLabel);
        this.connexionStatusLabel.setName("connexionStatusLabel");
    }

    protected void createConnexionStatusPanel() {
        this.connexionStatusPanel = new JScrollPane();
        this.$objectMap.put("connexionStatusPanel", this.connexionStatusPanel);
        this.connexionStatusPanel.setName("connexionStatusPanel");
    }

    @Override
    protected void createContent() {
        this.content = new Table();
        this.$objectMap.put("content", this.content);
        this.content.setName("content");
    }

    protected void createDumpFile() {
        this.dumpFile = new JTextField();
        this.$objectMap.put("dumpFile", this.dumpFile);
        this.dumpFile.setName("dumpFile");
        this.dumpFile.setColumns(15);
        this.dumpFile.addKeyListener((KeyListener)JAXXUtil.getEventListener(KeyListener.class, (String)"keyReleased", (Object)this, (String)"doKeyReleased__on__dumpFile"));
    }

    protected void createFileChooserAction() {
        this.fileChooserAction = new JButton();
        this.$objectMap.put("fileChooserAction", this.fileChooserAction);
        this.fileChooserAction.setName("fileChooserAction");
        this.fileChooserAction.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__fileChooserAction"));
    }

    protected void createIMPORT_EXTERNAL_DUMP() {
        this.IMPORT_EXTERNAL_DUMP = new Table();
        this.$objectMap.put("IMPORT_EXTERNAL_DUMP", this.IMPORT_EXTERNAL_DUMP);
        this.IMPORT_EXTERNAL_DUMP.setName("IMPORT_EXTERNAL_DUMP");
        this.IMPORT_EXTERNAL_DUMP.putClientProperty((Object)"description", (Object)I18n.n_((String)"observe.storage.importExternalDump.description"));
    }

    protected void createIMPORT_REMOTE_STORAGE() {
        this.IMPORT_REMOTE_STORAGE = new Table();
        this.$objectMap.put("IMPORT_REMOTE_STORAGE", this.IMPORT_REMOTE_STORAGE);
        this.IMPORT_REMOTE_STORAGE.setName("IMPORT_REMOTE_STORAGE");
        this.IMPORT_REMOTE_STORAGE.putClientProperty((Object)"description", (Object)I18n.n_((String)"observe.storage.importRemoteStorage.description"));
    }

    protected void createIMPORT_REMOTE_STORAGE_content() {
        this.IMPORT_REMOTE_STORAGE_content = new JPanel();
        this.$objectMap.put("IMPORT_REMOTE_STORAGE_content", this.IMPORT_REMOTE_STORAGE_content);
        this.IMPORT_REMOTE_STORAGE_content.setName("IMPORT_REMOTE_STORAGE_content");
        this.IMPORT_REMOTE_STORAGE_content.setLayout(new BorderLayout());
    }

    protected void createRemoteConfig() {
        this.remoteConfig = new JPanel();
        this.$objectMap.put("remoteConfig", this.remoteConfig);
        this.remoteConfig.setName("remoteConfig");
        this.remoteConfig.setLayout(new BorderLayout());
    }

    protected void createRemoteLogin() {
        this.remoteLogin = new JTextField();
        this.$objectMap.put("remoteLogin", this.remoteLogin);
        this.remoteLogin.setName("remoteLogin");
        this.remoteLogin.setColumns(15);
        this.remoteLogin.addKeyListener((KeyListener)JAXXUtil.getEventListener(KeyListener.class, (String)"keyReleased", (Object)this, (String)"doKeyReleased__on__remoteLogin"));
    }

    protected void createRemotePassword() {
        this.remotePassword = new JPasswordField();
        this.$objectMap.put("remotePassword", this.remotePassword);
        this.remotePassword.setName("remotePassword");
        this.remotePassword.setColumns(15);
        this.remotePassword.addKeyListener((KeyListener)JAXXUtil.getEventListener(KeyListener.class, (String)"keyReleased", (Object)this, (String)"doKeyReleased__on__remotePassword"));
    }

    protected void createRemoteSslCertificatFile() {
        this.remoteSslCertificatFile = new JTextField();
        this.$objectMap.put("remoteSslCertificatFile", this.remoteSslCertificatFile);
        this.remoteSslCertificatFile.setName("remoteSslCertificatFile");
        this.remoteSslCertificatFile.setColumns(15);
        this.remoteSslCertificatFile.addKeyListener((KeyListener)JAXXUtil.getEventListener(KeyListener.class, (String)"keyReleased", (Object)this, (String)"doKeyReleased__on__remoteSslCertificatFile"));
    }

    protected void createRemoteSslCertificatFileChooseaction() {
        this.remoteSslCertificatFileChooseaction = new JButton();
        this.$objectMap.put("remoteSslCertificatFileChooseaction", this.remoteSslCertificatFileChooseaction);
        this.remoteSslCertificatFileChooseaction.setName("remoteSslCertificatFileChooseaction");
        this.remoteSslCertificatFileChooseaction.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__remoteSslCertificatFileChooseaction"));
    }

    protected void createRemoteSslCertificatPassword() {
        this.remoteSslCertificatPassword = new JPasswordField();
        this.$objectMap.put("remoteSslCertificatPassword", this.remoteSslCertificatPassword);
        this.remoteSslCertificatPassword.setName("remoteSslCertificatPassword");
        this.remoteSslCertificatPassword.setColumns(15);
        this.remoteSslCertificatPassword.addKeyListener((KeyListener)JAXXUtil.getEventListener(KeyListener.class, (String)"keyReleased", (Object)this, (String)"doKeyReleased__on__remoteSslCertificatPassword"));
    }

    protected void createRemoteUrl() {
        this.remoteUrl = new JTextField();
        this.$objectMap.put("remoteUrl", this.remoteUrl);
        this.remoteUrl.setName("remoteUrl");
        this.remoteUrl.setColumns(15);
        this.remoteUrl.addKeyListener((KeyListener)JAXXUtil.getEventListener(KeyListener.class, (String)"keyReleased", (Object)this, (String)"doKeyReleased__on__remoteUrl"));
    }

    protected void createRemoteUseSsl() {
        this.remoteUseSsl = new JCheckBox();
        this.$objectMap.put("remoteUseSsl", this.remoteUseSsl);
        this.remoteUseSsl.setName("remoteUseSsl");
        this.remoteUseSsl.setText(I18n._((String)"observe.storage.remote.useSll"));
        this.remoteUseSsl.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__remoteUseSsl"));
    }

    protected void createStoreRemoteConfig() {
        this.storeRemoteConfig = new JCheckBox();
        this.$objectMap.put("storeRemoteConfig", this.storeRemoteConfig);
        this.storeRemoteConfig.setName("storeRemoteConfig");
        this.storeRemoteConfig.setText(I18n._((String)"observe.storage.store.remote.config"));
        this.storeRemoteConfig.setToolTipText(I18n._((String)"observe.storage.store.remote.config.tip"));
        this.storeRemoteConfig.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__storeRemoteConfig"));
    }

    protected void createTestRemoteAction() {
        this.testRemoteAction = new JButton();
        this.$objectMap.put("testRemoteAction", this.testRemoteAction);
        this.testRemoteAction.setName("testRemoteAction");
        this.testRemoteAction.setText(I18n._((String)"observe.action.test.remote"));
        this.testRemoteAction.setToolTipText(I18n._((String)"observe.action.test.remote.tip"));
        this.testRemoteAction.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__testRemoteAction"));
    }

    protected void createUSE_REMOTE() {
        this.USE_REMOTE = new Table();
        this.$objectMap.put("USE_REMOTE", this.USE_REMOTE);
        this.USE_REMOTE.setName("USE_REMOTE");
        this.USE_REMOTE.putClientProperty((Object)"description", (Object)I18n.n_((String)"observe.storage.useRemoteStorage.description"));
    }

    protected void createUSE_REMOTE_content() {
        this.USE_REMOTE_content = new JPanel();
        this.$objectMap.put("USE_REMOTE_content", this.USE_REMOTE_content);
        this.USE_REMOTE_content.setName("USE_REMOTE_content");
        this.USE_REMOTE_content.setLayout(new GridLayout());
    }

    private void $completeSetup() {
        this.allComponentsCreated = true;
        this.addChildrenToContent();
        this.addChildrenToConfigContent();
        this.addChildrenToIMPORT_EXTERNAL_DUMP();
        this.addChildrenToIMPORT_REMOTE_STORAGE();
        this.addChildrenToUSE_REMOTE();
        this.$JPanel0.add(this.remoteConfig);
        this.addChildrenToRemoteConfig();
        this.$Table0.add((Component)this.$JLabel3, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.remoteUrl, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.$JLabel4, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.remoteLogin, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.$JLabel5, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.remotePassword, (Object)new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 13, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.remoteUseSsl, (Object)new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.$Table1, (Object)new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.$Table2, (Object)new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.storeRemoteConfig, (Object)new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.testRemoteAction, (Object)new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.remoteSslCertificatFile, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.$Table1.add((Component)this.remoteSslCertificatFileChooseaction, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.$Table2.add((Component)this.$JLabel6, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.$Table2.add((Component)this.remoteSslCertificatPassword, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.$Table3.add((Component)this.connexionStatusPanel, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.$Table3.add((Component)this.connexionStatusLabel, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addChildrenToConnexionStatusPanel();
        JAXXUtil.applyDataBinding((JAXXObject)this, this.$bindings.keySet());
        this.USE_REMOTE_content.setMinimumSize(new Dimension(20, 300));
        this.fileChooserAction.setIcon(SwingUtil.getUIManagerActionIcon((String)"fileChooser"));
        this.remoteSslCertificatFileChooseaction.setIcon(SwingUtil.getUIManagerActionIcon((String)"fileChooser"));
        this.testRemoteAction.setIcon(SwingUtil.getUIManagerActionIcon((String)"connect_creating"));
        this.connexionStatusPanel.setColumnHeaderView(this.connexionStatusLabel);
        this.$afterCompleteSetup();
    }

    private void $initialize() {
        if (this.allComponentsCreated || !this.contextInitialized) {
            return;
        }
        this.$registerDefaultBindings();
        this.$objectMap.put("$AbstractStorageTabPanelUI0", this);
        this.createConfigLayout();
        this.createConfigContent();
        this.createIMPORT_EXTERNAL_DUMP();
        this.$JLabel0 = new JLabel();
        this.$objectMap.put("$JLabel0", this.$JLabel0);
        this.$JLabel0.setName("$JLabel0");
        this.$JLabel0.setText(I18n._((String)"observe.storage.importExternalDump.config"));
        this.createDumpFile();
        this.createFileChooserAction();
        this.createIMPORT_REMOTE_STORAGE();
        this.$JLabel1 = new JLabel();
        this.$objectMap.put("$JLabel1", this.$JLabel1);
        this.$JLabel1.setName("$JLabel1");
        this.$JLabel1.setText(I18n._((String)"observe.storage.importRemoteStorage.config"));
        this.createIMPORT_REMOTE_STORAGE_content();
        this.createUSE_REMOTE();
        this.$JLabel2 = new JLabel();
        this.$objectMap.put("$JLabel2", this.$JLabel2);
        this.$JLabel2.setName("$JLabel2");
        this.$JLabel2.setText(I18n._((String)"observe.storage.useRemoteStorage.config"));
        this.createUSE_REMOTE_content();
        this.$JPanel0 = new JPanel();
        this.$objectMap.put("$JPanel0", this.$JPanel0);
        this.$JPanel0.setName("$JPanel0");
        this.$JPanel0.setVisible(false);
        this.createRemoteConfig();
        this.$Table0 = new Table();
        this.$objectMap.put("$Table0", this.$Table0);
        this.$Table0.setName("$Table0");
        this.$JLabel3 = new JLabel();
        this.$objectMap.put("$JLabel3", this.$JLabel3);
        this.$JLabel3.setName("$JLabel3");
        this.$JLabel3.setText(I18n._((String)"observe.storage.remote.url"));
        this.createRemoteUrl();
        this.$JLabel4 = new JLabel();
        this.$objectMap.put("$JLabel4", this.$JLabel4);
        this.$JLabel4.setName("$JLabel4");
        this.$JLabel4.setText(I18n._((String)"observe.storage.remote.login"));
        this.createRemoteLogin();
        this.$JLabel5 = new JLabel();
        this.$objectMap.put("$JLabel5", this.$JLabel5);
        this.$JLabel5.setName("$JLabel5");
        this.$JLabel5.setText(I18n._((String)"observe.storage.remote.password"));
        this.createRemotePassword();
        this.createRemoteUseSsl();
        this.$Table1 = new Table();
        this.$objectMap.put("$Table1", this.$Table1);
        this.$Table1.setName("$Table1");
        this.createRemoteSslCertificatFile();
        this.createRemoteSslCertificatFileChooseaction();
        this.$Table2 = new Table();
        this.$objectMap.put("$Table2", this.$Table2);
        this.$Table2.setName("$Table2");
        this.$JLabel6 = new JLabel();
        this.$objectMap.put("$JLabel6", this.$JLabel6);
        this.$JLabel6.setName("$JLabel6");
        this.$JLabel6.setText(I18n._((String)"observe.storage.remote.ssl.password"));
        this.createRemoteSslCertificatPassword();
        this.createStoreRemoteConfig();
        this.createTestRemoteAction();
        this.$Table3 = new Table();
        this.$objectMap.put("$Table3", this.$Table3);
        this.$Table3.setName("$Table3");
        this.createConnexionStatusPanel();
        this.createConnexionStatus();
        this.createConnexionStatusLabel();
        this.setName("$AbstractStorageTabPanelUI0");
        this.$AbstractStorageTabPanelUI0.putClientProperty("step", (Object)StorageStep.CONFIG);
        this.$completeSetup();
    }

    private void $registerDefaultBindings() {
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_REMOTE_SSL_CERTIFICAT_PASSWORD_ENABLED, true){

            public void applyDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.addPropertyChangeListener("useSsl", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.remoteSslCertificatPassword.setEnabled(ConfigStoragePanelUI.this.model.isUseSsl());
                }
            }

            public void removeDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.removePropertyChangeListener("useSsl", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_REMOTE_SSL_CERTIFICAT_PASSWORD_TEXT, true){

            public void applyDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.addPropertyChangeListener("sslCertificatPassword", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    SwingUtil.setText((JTextComponent)ConfigStoragePanelUI.this.remoteSslCertificatPassword, (String)(ConfigStoragePanelUI.this.model.getSslCertificatPassword() == null ? "" : new String(ConfigStoragePanelUI.this.model.getSslCertificatPassword())));
                }
            }

            public void removeDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.removePropertyChangeListener("sslCertificatPassword", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_DUMP_FILE_TEXT, true){

            public void applyDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.addPropertyChangeListener("dumpFile", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    SwingUtil.setText((JTextComponent)ConfigStoragePanelUI.this.dumpFile, (String)(ConfigStoragePanelUI.this.model.getDumpFile() + ""));
                }
            }

            public void removeDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.removePropertyChangeListener("dumpFile", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_REMOTE_URL_TEXT, true){

            public void applyDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.addPropertyChangeListener("remoteUrl", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    SwingUtil.setText((JTextComponent)ConfigStoragePanelUI.this.remoteUrl, (String)ConfigStoragePanelUI.this.model.getRemoteUrl());
                }
            }

            public void removeDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.removePropertyChangeListener("remoteUrl", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_REMOTE_LOGIN_TEXT, true){

            public void applyDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.addPropertyChangeListener("remoteLogin", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    SwingUtil.setText((JTextComponent)ConfigStoragePanelUI.this.remoteLogin, (String)ConfigStoragePanelUI.this.model.getRemoteLogin());
                }
            }

            public void removeDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.removePropertyChangeListener("remoteLogin", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_REMOTE_PASSWORD_TEXT, true){

            public void applyDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.addPropertyChangeListener("remotePassword", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    SwingUtil.setText((JTextComponent)ConfigStoragePanelUI.this.remotePassword, (String)(ConfigStoragePanelUI.this.model.getRemotePassword() == null ? "" : new String(ConfigStoragePanelUI.this.model.getRemotePassword())));
                }
            }

            public void removeDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.removePropertyChangeListener("remotePassword", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_REMOTE_USE_SSL_SELECTED, true){

            public void applyDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.addPropertyChangeListener("useSsl", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.remoteUseSsl.setSelected(ConfigStoragePanelUI.this.model.isUseSsl());
                }
            }

            public void removeDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.removePropertyChangeListener("useSsl", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_REMOTE_SSL_CERTIFICAT_FILE_ENABLED, true){

            public void applyDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.addPropertyChangeListener("useSsl", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.remoteSslCertificatFile.setEnabled(ConfigStoragePanelUI.this.model.isUseSsl());
                }
            }

            public void removeDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.removePropertyChangeListener("useSsl", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_REMOTE_SSL_CERTIFICAT_FILE_TEXT, true){

            public void applyDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.addPropertyChangeListener("sslCertificatFile", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    SwingUtil.setText((JTextComponent)ConfigStoragePanelUI.this.remoteSslCertificatFile, (String)(ConfigStoragePanelUI.this.model.getSslCertificatFile() + ""));
                }
            }

            public void removeDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.removePropertyChangeListener("sslCertificatFile", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_REMOTE_SSL_CERTIFICAT_FILE_CHOOSEACTION_ENABLED, true){

            public void applyDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.addPropertyChangeListener("useSsl", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.remoteSslCertificatFileChooseaction.setEnabled(ConfigStoragePanelUI.this.model.isUseSsl());
                }
            }

            public void removeDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.removePropertyChangeListener("useSsl", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_STORE_REMOTE_CONFIG_SELECTED, true){

            public void applyDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.addPropertyChangeListener("storeRemoteConfig", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.storeRemoteConfig.setSelected(ConfigStoragePanelUI.this.model.isStoreRemoteConfig());
                }
            }

            public void removeDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.removePropertyChangeListener("storeRemoteConfig", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_TEST_REMOTE_ACTION_ENABLED, true){

            public void applyDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.addPropertyChangeListener("connexionStatus", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.testRemoteAction.setEnabled(ConfigStoragePanelUI.this.model.getConnexionStatus() != ConnexionStatus.SUCCESS);
                }
            }

            public void removeDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.removePropertyChangeListener("connexionStatus", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_CONNEXION_STATUS_PANEL_BORDER, true){

            public void applyDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.addPropertyChangeListener("connexionStatus", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.connexionStatusPanel.setBorder(new LineBorder(ConfigStoragePanelUI.this.updateConnexionStatutColor(ConfigStoragePanelUI.this.model.getConnexionStatus()), 2));
                }
            }

            public void removeDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.removePropertyChangeListener("connexionStatus", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_CONNEXION_STATUS_TEXT, true){

            public void applyDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.addPropertyChangeListener("connexionStatus", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    SwingUtil.setText((JTextComponent)ConfigStoragePanelUI.this.connexionStatus, (String)ConfigStoragePanelUI.this.updateConnexionStatutText(ConfigStoragePanelUI.this.model.getConnexionStatus()));
                }
            }

            public void removeDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.removePropertyChangeListener("connexionStatus", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_CONNEXION_STATUS_LABEL_ICON, true){

            public void applyDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.addPropertyChangeListener("connexionStatus", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.connexionStatusLabel.setIcon(ConfigStoragePanelUI.this.updateConnexionStatutIcon(ConfigStoragePanelUI.this.model.getConnexionStatus()));
                }
            }

            public void removeDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.removePropertyChangeListener("connexionStatus", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_CONNEXION_STATUS_LABEL_TEXT, true){

            public void applyDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.addPropertyChangeListener("connexionStatus", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (ConfigStoragePanelUI.this.model != null && ConfigStoragePanelUI.this.model.getConnexionStatus() != null) {
                    ConfigStoragePanelUI.this.connexionStatusLabel.setText(I18n._((String)ConfigStoragePanelUI.this.model.getConnexionStatus().getLabel()));
                }
            }

            public void removeDataBinding() {
                if (ConfigStoragePanelUI.this.model != null) {
                    ConfigStoragePanelUI.this.model.removePropertyChangeListener("connexionStatus", (PropertyChangeListener)((Object)this));
                }
            }
        });
    }
}

