/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.actions;

import fr.ird.observe.DBHelper;
import fr.ird.observe.entities.Activite;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.Route;
import fr.ird.observe.entities.gps.GPSPoint;
import fr.ird.observe.entities.gps.GPSPointInterval;
import fr.ird.observe.entities.gps.GPSRoute;
import fr.ird.observe.services.gps.GPSImportModel;
import fr.ird.observe.services.storage.StorageService;
import fr.ird.observe.services.storage.impl.AbstractStorageService;
import fr.ird.observe.ui.admin.SynchroOperationAction;
import fr.ird.observe.ui.admin.SynchroStep;
import fr.ird.observe.ui.admin.SynchroUIModel;
import fr.ird.observe.ui.storage.StorageUIModel;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.wizard.WizardOperationState;
import org.apache.commons.collections.primitives.ArrayIntList;
import org.apache.commons.collections.primitives.IntIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ImportGPSAction
extends SynchroOperationAction {
    private static final Log log = LogFactory.getLog(ImportGPSAction.class);
    protected boolean wasInit;
    protected boolean canTreate;
    protected Maree openMaree;
    protected GPSRoute route;
    protected Map<Activite, GPSPoint> data = new LinkedHashMap<Activite, GPSPoint>();

    public ImportGPSAction() {
        super(SynchroStep.IMPORT_GPS);
    }

    public void beforeAction(JAXXContext context, SynchroUIModel model) throws Exception {
        log.debug((Object)this);
        if (this.wasInit) {
            return;
        }
        StorageUIModel localServiceModel = model.getLocalServiceModel();
        if (model.getLocalService() == null) {
            model.setLocalService(this.createLocalService(localServiceModel, model.getPreviousService()));
        }
        AbstractStorageService sourceService = (AbstractStorageService)model.getLocalService();
        this.openService((StorageService<?>)sourceService);
        TopiaContext srcCtxt = sourceService.newCtxt();
        try {
            this.openMaree = DBHelper.getOpenMaree((TopiaContext)srcCtxt);
        }
        catch (TopiaException e) {
            srcCtxt.closeContext();
        }
        if (this.openMaree == null) {
            this.sendMessage(I18n._((String)"observe.message.no.open.maree.detected"));
            return;
        }
        if (this.openMaree.isRouteEmpty()) {
            this.sendMessage(I18n._((String)"observe.message.no.route.detected"));
            return;
        }
        for (Route r : this.openMaree.getRoute()) {
            if (r.isActiviteEmpty()) continue;
            for (Activite a : r.getActivite()) {
                this.data.put(a, null);
            }
        }
        if (this.data.isEmpty()) {
            this.sendMessage(I18n._((String)"observe.message.no.activite.detected"));
            return;
        }
        GPSImportModel gpsModel = model.getGpsImportModel();
        this.sendMessage(I18n._((String)"observe.message.importGPS.prepare.importFile", (Object[])new Object[]{gpsModel.getImportGPSFile(), gpsModel.getImportGPSMaxDelay(), gpsModel.getImportGPSMaxSpeed()}));
        this.route = this.getGpsService().buildRoute(gpsModel.getImportGPSFile(), gpsModel.getImportGPSMaxDelay().intValue(), gpsModel.getImportGPSMaxSpeed().floatValue());
        List acceptedInterval = this.route.getAcceptedInterval();
        if (acceptedInterval == null || acceptedInterval.isEmpty()) {
            this.sendMessage(I18n._((String)"observe.message.no.accepted.intervalle.detected"));
            return;
        }
        for (GPSPointInterval i : acceptedInterval) {
            this.sendMessage(I18n._((String)"observe.message.detected.accepted.interval", (Object[])new Object[]{i}));
        }
        for (GPSPointInterval i : this.route.getRejectedInterval()) {
            this.sendMessage(I18n._((String)"observe.message.detected.rejected.interval", (Object[])new Object[]{i}));
        }
        this.canTreate = true;
    }

    @Override
    public void copyTo(SynchroOperationAction newAction) {
        ImportGPSAction n = (ImportGPSAction)newAction;
        n.wasInit = this.wasInit;
        n.canTreate = this.canTreate;
        n.openMaree = this.openMaree;
        n.route = this.route;
        n.data = this.data;
    }

    @Override
    public void destroy() {
        this.openMaree = null;
        this.route = null;
        this.data.clear();
        this.data = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WizardOperationState doAction(SynchroUIModel model) throws Exception {
        log.debug((Object)this);
        if (!this.canTreate) {
            this.sendMessage(I18n._((String)"observe.message.importGPS.nothing.to.do"));
            this.sendMessage(I18n._((String)"observe.message.synchro.operation.done", (Object[])new Object[]{new Date()}));
            return WizardOperationState.SUCCESSED;
        }
        if (this.isCancelled()) {
            return this.onCancel(model, (Exception)null);
        }
        if (!this.wasInit) {
            this.sendMessage(I18n._((String)"observe.message.importGPS.detect.points"));
            try {
                this.detectPoints();
            }
            finally {
                this.wasInit = true;
            }
            if (this.isCancelled()) {
                return this.onCancel(model, (Exception)null);
            }
            if (this.data.isEmpty()) {
                this.sendMessage(I18n._((String)"observe.message.importGPS.nothing.to.do"));
                this.sendMessage(I18n._((String)"observe.message.synchro.operation.done", (Object[])new Object[]{new Date()}));
                return WizardOperationState.SUCCESSED;
            }
            this.sendMessage(I18n._((String)"observe.message.importGPS.operation.needFix", (Object[])new Object[]{new Date()}));
            return WizardOperationState.NEED_FIX;
        }
        if (this.isCancelled()) {
            return this.onCancel(model, (Exception)null);
        }
        this.sendMessage(I18n._((String)"observe.message.importGPS.apply.points"));
        if (model.getImportGPSSelectedIndex() == null || model.getImportGPSSelectedIndex().length == 0) {
            this.sendMessage(I18n._((String)"observe.message.importGPS.nothing.to.do"));
            this.sendMessage(I18n._((String)"observe.message.importGPS.no.activite.selected"));
        } else {
            this.applyPoints(model);
        }
        this.sendMessage(I18n._((String)"observe.message.synchro.operation.done", (Object[])new Object[]{new Date()}));
        return WizardOperationState.SUCCESSED;
    }

    public Map<Activite, GPSPoint> getData() {
        return this.data;
    }

    public GPSRoute getRoute() {
        return this.route;
    }

    protected void detectPoints() {
        Decorator decorator = this.getDecoratorService().getDecorator(Activite.class, "activite-gps");
        Decorator decorator2 = this.getDecoratorService().getDecorator(GPSPoint.class, "gpsPoint-gps");
        HashSet<Activite> rejected = new HashSet<Activite>();
        for (Activite a : this.data.keySet()) {
            Date heureObservation = a.getHeureObservation();
            this.sendMessage(I18n._((String)"observe.message.importGPS.detect.point", (Object[])new Object[]{decorator.toString((Object)a)}));
            GPSPoint point = this.route.getPoint(heureObservation);
            if (point == null) {
                this.sendMessage(I18n._((String)"observe.message.importGPS.no.detected.point"));
                rejected.add(a);
                continue;
            }
            this.sendMessage(I18n._((String)"observe.message.importGPS.detected.point", (Object[])new Object[]{decorator2.toString((Object)point)}));
            this.data.put(a, point);
        }
        for (Activite a : rejected) {
            this.data.remove(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyPoints(SynchroUIModel model) throws Exception {
        int[] selectedIndex = model.getImportGPSSelectedIndex();
        AbstractStorageService service = (AbstractStorageService)model.getLocalService();
        TopiaContext ctxt = service.newCtxt();
        ArrayIntList lIndex = new ArrayIntList(selectedIndex.length);
        try {
            for (int i : selectedIndex) {
                lIndex.add(i);
            }
            IntIterator indexItr = lIndex.iterator();
            int currentActiviteIndex = 0;
            int nextActiviteIndex = indexItr.next();
            for (Activite a : this.data.keySet()) {
                if (currentActiviteIndex == nextActiviteIndex) {
                    GPSPoint p = this.data.get(a);
                    this.sendMessage(I18n._((String)"observe.message.importGPS.apply.point", (Object[])new Object[]{p, a.getActiviteBateau().getLibelle2()}));
                    float latitude = Math.abs(p.getLatitude().floatValue());
                    float longitude = Math.abs(p.getLongitude().floatValue());
                    int quadrant = p.getQuadrant();
                    a.setLatitude(Float.valueOf(latitude));
                    a.setLongitude(Float.valueOf(longitude));
                    a.setQuadrant(Integer.valueOf(quadrant));
                    a.update();
                    if (!indexItr.hasNext()) break;
                    nextActiviteIndex = indexItr.next();
                }
                ++currentActiviteIndex;
            }
            ctxt.commitTransaction();
        }
        finally {
            ctxt.rollbackTransaction();
            ctxt.closeContext();
            lIndex.clear();
        }
    }
}

