/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.OpenBitSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.DocSetBase;
import org.apache.solr.search.SolrIndexReader;

public class SortedIntDocSet
extends DocSetBase {
    protected final int[] docs;
    public static int[] zeroInts = new int[0];
    public static SortedIntDocSet zero = new SortedIntDocSet(zeroInts);

    public SortedIntDocSet(int[] docs) {
        this.docs = docs;
    }

    public SortedIntDocSet(int[] docs, int len) {
        this(SortedIntDocSet.shrink(docs, len));
    }

    public int[] getDocs() {
        return this.docs;
    }

    public int size() {
        return this.docs.length;
    }

    public long memSize() {
        return (this.docs.length << 2) + 8;
    }

    public static int[] shrink(int[] arr, int newSize) {
        if (arr.length == newSize) {
            return arr;
        }
        int[] newArr = new int[newSize];
        System.arraycopy(arr, 0, newArr, 0, newSize);
        return newArr;
    }

    public static int firstNonSorted(int[] arr, int offset, int len) {
        if (len <= 1) {
            return -1;
        }
        int lower = arr[offset];
        int end = offset + len;
        for (int i = offset + 1; i < end; ++i) {
            int next = arr[i];
            if (next <= lower) {
                for (int j = i - 1; j > offset; --j) {
                    if (arr[j] >= next) continue;
                    return j + 1;
                }
                return offset;
            }
            lower = next;
        }
        return -1;
    }

    public static int intersectionSize(int[] smallerSortedList, int[] biggerSortedList) {
        int[] a = smallerSortedList;
        int[] b = biggerSortedList;
        int step = b.length / a.length + 1;
        step += step;
        int icount = 0;
        int low = 0;
        int max = b.length - 1;
        block0: for (int i = 0; i < a.length; ++i) {
            int doca = a[i];
            int probe = low + step;
            int high = max;
            if (probe < high) {
                if (b[probe] >= doca) {
                    high = probe;
                } else {
                    low = probe + 1;
                    if ((probe = low + step) < high) {
                        if (b[probe] >= doca) {
                            high = probe;
                        } else {
                            low = probe + 1;
                        }
                    }
                }
            }
            while (low <= high) {
                int mid = low + high >>> 1;
                int docb = b[mid];
                if (docb < doca) {
                    low = mid + 1;
                    continue;
                }
                if (docb > doca) {
                    high = mid - 1;
                    continue;
                }
                ++icount;
                low = mid + 1;
                continue block0;
            }
        }
        return icount;
    }

    public int intersectionSize(DocSet other) {
        int[] b;
        if (!(other instanceof SortedIntDocSet)) {
            int icount = 0;
            for (int i = 0; i < this.docs.length; ++i) {
                if (!other.exists(this.docs[i])) continue;
                ++icount;
            }
            return icount;
        }
        int[] otherDocs = ((SortedIntDocSet)other).docs;
        int[] a = this.docs.length < otherDocs.length ? this.docs : otherDocs;
        int[] nArray = b = this.docs.length < otherDocs.length ? otherDocs : this.docs;
        if (a.length == 0) {
            return 0;
        }
        if (b.length >> 3 >= a.length) {
            return SortedIntDocSet.intersectionSize(a, b);
        }
        int icount = 0;
        int i = 0;
        int j = 0;
        int doca = a[i];
        int docb = b[j];
        while (true) {
            if (doca > docb) {
                if (++j >= b.length) break;
                docb = b[j];
                continue;
            }
            if (doca < docb) {
                if (++i >= a.length) break;
                doca = a[i];
                continue;
            }
            ++icount;
            if (++i >= a.length) break;
            doca = a[i];
            if (++j >= b.length) break;
            docb = b[j];
        }
        return icount;
    }

    public static int intersection(int[] a, int lena, int[] b, int lenb, int[] target) {
        if (lena > lenb) {
            int ti = lena;
            lena = lenb;
            lenb = ti;
            int[] ta = a;
            a = b;
            b = ta;
        }
        if (lena == 0) {
            return 0;
        }
        if (lenb >> 3 >= lena) {
            return SortedIntDocSet.intersectionBinarySearch(a, lena, b, lenb, target);
        }
        int icount = 0;
        int i = 0;
        int j = 0;
        int doca = a[i];
        int docb = b[j];
        while (true) {
            if (doca > docb) {
                if (++j >= lenb) break;
                docb = b[j];
                continue;
            }
            if (doca < docb) {
                if (++i >= lena) break;
                doca = a[i];
                continue;
            }
            target[icount++] = doca;
            if (++i >= lena) break;
            doca = a[i];
            if (++j >= lenb) break;
            docb = b[j];
        }
        return icount;
    }

    protected static int intersectionBinarySearch(int[] a, int lena, int[] b, int lenb, int[] target) {
        int step = lenb / lena + 1;
        step += step;
        int icount = 0;
        int low = 0;
        int max = lenb - 1;
        block0: for (int i = 0; i < lena; ++i) {
            int doca = a[i];
            int probe = low + step;
            int high = max;
            if (probe < high) {
                if (b[probe] >= doca) {
                    high = probe;
                } else {
                    low = probe + 1;
                    if ((probe = low + step) < high) {
                        if (b[probe] >= doca) {
                            high = probe;
                        } else {
                            low = probe + 1;
                        }
                    }
                }
            }
            while (low <= high) {
                int mid = low + high >>> 1;
                int docb = b[mid];
                if (docb < doca) {
                    low = mid + 1;
                    continue;
                }
                if (docb > doca) {
                    high = mid - 1;
                    continue;
                }
                target[icount++] = doca;
                low = mid + 1;
                continue block0;
            }
        }
        return icount;
    }

    public DocSet intersection(DocSet other) {
        if (!(other instanceof SortedIntDocSet)) {
            int icount = 0;
            int[] arr = new int[this.docs.length];
            for (int i = 0; i < this.docs.length; ++i) {
                int doc = this.docs[i];
                if (!other.exists(doc)) continue;
                arr[icount++] = doc;
            }
            return new SortedIntDocSet(arr, icount);
        }
        int[] otherDocs = ((SortedIntDocSet)other).docs;
        int maxsz = Math.min(this.docs.length, otherDocs.length);
        int[] arr = new int[maxsz];
        int sz = SortedIntDocSet.intersection(this.docs, this.docs.length, otherDocs, otherDocs.length, arr);
        return new SortedIntDocSet(arr, sz);
    }

    protected static int andNotBinarySearch(int[] a, int lena, int[] b, int lenb, int[] target) {
        int step = lenb / lena + 1;
        step += step;
        int count = 0;
        int low = 0;
        int max = lenb - 1;
        block0: for (int i = 0; i < lena; ++i) {
            int doca = a[i];
            int probe = low + step;
            int high = max;
            if (probe < high) {
                if (b[probe] >= doca) {
                    high = probe;
                } else {
                    low = probe + 1;
                    if ((probe = low + step) < high) {
                        if (b[probe] >= doca) {
                            high = probe;
                        } else {
                            low = probe + 1;
                        }
                    }
                }
            }
            while (low <= high) {
                int mid = low + high >>> 1;
                int docb = b[mid];
                if (docb < doca) {
                    low = mid + 1;
                    continue;
                }
                if (docb > doca) {
                    high = mid - 1;
                    continue;
                }
                low = mid + 1;
                continue block0;
            }
            target[count++] = doca;
        }
        return count;
    }

    public static int andNot(int[] a, int lena, int[] b, int lenb, int[] target) {
        if (lena == 0) {
            return 0;
        }
        if (lenb == 0) {
            System.arraycopy(a, 0, target, 0, lena);
            return lena;
        }
        if (lenb >> 3 >= lena) {
            return SortedIntDocSet.andNotBinarySearch(a, lena, b, lenb, target);
        }
        int count = 0;
        int i = 0;
        int j = 0;
        int doca = a[i];
        int docb = b[j];
        while (true) {
            if (doca > docb) {
                if (++j >= lenb) break;
                docb = b[j];
                continue;
            }
            if (doca < docb) {
                target[count++] = doca;
                if (++i >= lena) break;
                doca = a[i];
                continue;
            }
            if (++i >= lena) break;
            doca = a[i];
            if (++j >= lenb) break;
            docb = b[j];
        }
        int leftover = lena - i;
        if (leftover > 0) {
            System.arraycopy(a, i, target, count, leftover);
            count += leftover;
        }
        return count;
    }

    public DocSet andNot(DocSet other) {
        if (other.size() == 0) {
            return this;
        }
        if (!(other instanceof SortedIntDocSet)) {
            int count = 0;
            int[] arr = new int[this.docs.length];
            for (int i = 0; i < this.docs.length; ++i) {
                int doc = this.docs[i];
                if (other.exists(doc)) continue;
                arr[count++] = doc;
            }
            return new SortedIntDocSet(arr, count);
        }
        int[] otherDocs = ((SortedIntDocSet)other).docs;
        int[] arr = new int[this.docs.length];
        int sz = SortedIntDocSet.andNot(this.docs, this.docs.length, otherDocs, otherDocs.length, arr);
        return new SortedIntDocSet(arr, sz);
    }

    public boolean exists(int doc) {
        int low = 0;
        int high = this.docs.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int docb = this.docs[mid];
            if (docb < doc) {
                low = mid + 1;
                continue;
            }
            if (docb > doc) {
                high = mid - 1;
                continue;
            }
            return true;
        }
        return false;
    }

    public DocIterator iterator() {
        return new DocIterator(){
            int pos = 0;

            public boolean hasNext() {
                return this.pos < SortedIntDocSet.this.docs.length;
            }

            public Integer next() {
                return this.nextDoc();
            }

            public void remove() {
                throw new UnsupportedOperationException("The remove  operation is not supported by this Iterator.");
            }

            public int nextDoc() {
                return SortedIntDocSet.this.docs[this.pos++];
            }

            public float score() {
                return 0.0f;
            }
        };
    }

    public OpenBitSet getBits() {
        int maxDoc = this.size() > 0 ? this.docs[this.size() - 1] : 0;
        OpenBitSet bs = new OpenBitSet((long)(maxDoc + 1));
        for (int doc : this.docs) {
            bs.fastSet(doc);
        }
        return bs;
    }

    public static int findIndex(int[] arr, int value, int low, int high) {
        while (low <= high) {
            int mid = low + high >>> 1;
            int found = arr[mid];
            if (found < value) {
                low = mid + 1;
                continue;
            }
            if (found > value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low;
    }

    public Filter getTopFilter() {
        return new Filter(){
            int lastEndIdx = 0;

            public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
                int endIdx;
                int offset = 0;
                SolrIndexReader r = (SolrIndexReader)reader;
                while (r.getParent() != null) {
                    offset += r.getBase();
                    r = r.getParent();
                }
                final int base = offset;
                int maxDoc = reader.maxDoc();
                int max = base + maxDoc;
                int sidx = Math.max(0, this.lastEndIdx);
                if (sidx > 0 && SortedIntDocSet.this.docs[sidx - 1] >= base) {
                    sidx = 0;
                }
                if (sidx < SortedIntDocSet.this.docs.length && SortedIntDocSet.this.docs[sidx] < base) {
                    sidx = SortedIntDocSet.findIndex(SortedIntDocSet.this.docs, base, sidx, SortedIntDocSet.this.docs.length - 1);
                }
                final int startIdx = sidx;
                int eidx = Math.min(SortedIntDocSet.this.docs.length, startIdx + maxDoc) - 1;
                this.lastEndIdx = endIdx = (eidx = SortedIntDocSet.findIndex(SortedIntDocSet.this.docs, max, startIdx, eidx) - 1);
                return new DocIdSet(){

                    public DocIdSetIterator iterator() throws IOException {
                        return new DocIdSetIterator(){
                            int idx;
                            int adjustedDoc;
                            {
                                this.idx = startIdx;
                                this.adjustedDoc = -1;
                            }

                            public int doc() {
                                return this.adjustedDoc;
                            }

                            public int docID() {
                                return this.adjustedDoc;
                            }

                            public int nextDoc() throws IOException {
                                this.adjustedDoc = this.idx > endIdx ? Integer.MAX_VALUE : SortedIntDocSet.this.docs[this.idx++] - base;
                                return this.adjustedDoc;
                            }

                            public int advance(int target) throws IOException {
                                int rawDoc;
                                if (this.idx > endIdx || target == Integer.MAX_VALUE) {
                                    this.adjustedDoc = Integer.MAX_VALUE;
                                    return Integer.MAX_VALUE;
                                }
                                if ((rawDoc = SortedIntDocSet.this.docs[this.idx++]) >= (target += base)) {
                                    this.adjustedDoc = rawDoc - base;
                                    return this.adjustedDoc;
                                }
                                int high = endIdx;
                                while (this.idx <= high) {
                                    int mid = this.idx + high >>> 1;
                                    rawDoc = SortedIntDocSet.this.docs[mid];
                                    if (rawDoc < target) {
                                        this.idx = mid + 1;
                                        continue;
                                    }
                                    if (rawDoc > target) {
                                        high = mid - 1;
                                        continue;
                                    }
                                    this.idx = mid + 1;
                                    this.adjustedDoc = rawDoc - base;
                                    return this.adjustedDoc;
                                }
                                if (this.idx <= endIdx) {
                                    this.adjustedDoc = SortedIntDocSet.this.docs[this.idx++] - base;
                                    return this.adjustedDoc;
                                }
                                this.adjustedDoc = Integer.MAX_VALUE;
                                return Integer.MAX_VALUE;
                            }
                        };
                    }

                    public boolean isCacheable() {
                        return true;
                    }
                };
            }
        };
    }
}

