/*
 * #%L
 * Wao :: Web Interface
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.ContactFilter;
import fr.ifremer.wao.bean.ObsProgram;
import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.entity.Company;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.service.ServiceContact;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.apache.tapestry5.util.EnumSelectModel;
import org.slf4j.Logger;

import java.io.IOException;
import java.util.List;

/**
 * Created: 6 juil. 2010
 *
 * @author fdesbois <fdesbois@codelutin.com>
 * @version $Id: Cartography.java 1533 2012-02-23 15:40:52Z bleny $
 */
@RequiresAuthentication(allowedPrograms = {ObsProgram.OBSMER, ObsProgram.OBSVENTE}, allowedRoles = {UserRole.ADMIN, UserRole.COORDINATOR, UserRole.OBSERVER, UserRole.PROFESSIONAL})
public class Cartography {

    @Inject
    private Messages messages;

    @SessionState
    @Property
    private ConnectedUser user;

    @Inject
    private Logger logger;

    @Inject
    private PageRenderLinkSource pageRender;

    @Inject
    private PropertyAccess propertyAccess;

    @Inject
    private ServiceUser serviceUser;

    @Inject
    private ServiceSampling serviceSampling;

    @Inject
    private ServiceContact serviceContact;

    private String url;

    @Property
    @Persist
    private KmlLoader.StrategyValues mapType;

    @SessionState(create = false)
    private ContactFilter cartographyFilter;

    void setupRender() {
        if (mapType == null) {
            mapType = KmlLoader.StrategyValues.CONTACTS_STATES;
        }
    }

    /**************************** FILTERS *************************************/

    public SelectModel getMapTypeSelectModel() {
        return new EnumSelectModel(KmlLoader.StrategyValues.class,
               messages, KmlLoader.StrategyValues.values(getFilter().getObsProgram()));
    }

    public ContactFilter getFilter() {
        if (cartographyFilter == null) {
            cartographyFilter = serviceContact.newContactFilter(user);
        }
        return cartographyFilter;
    }

    public List<Company> getCompanies() {
        List<Company> companies = serviceUser.getCompanies(true);
        return companies;
    }

    public List<String> getPrograms() {
        List<String> programs = serviceSampling.getPrograms(cartographyFilter.getSamplingFilter().getCompany());
        return programs;
    }

    public List<SampleRow> getSampleRows() {
        List<SampleRow> sampleRows =
                serviceSampling.getSampleRowsByFilter(
                        cartographyFilter.getSamplingFilter());
        return sampleRows;
    }

    @InjectComponent
    private Zone samplingFilterZone;

    @InjectComponent
    private Zone sampleRowFilterZone;

    @Log
    Zone onValueChangedFromCompany() {
        return samplingFilterZone;
    }

    @Log
    Zone onValueChangedFromProgramName() {
        return sampleRowFilterZone;
    }

    void onSelectedFromReset() {
        cartographyFilter = null;
    }

//    void onSuccessFromFilters() {
//        if (!user.isAdmin()) {
//            throw new WaoException("Vous n'avez pas les droits nécessaires" +
//                    " pour filtrer sur une société", null);
//        }
//    }

    /**************************** URL *************************************/

    public String getUrl() throws IOException {
        if (url == null) {
            Link link = pageRender.createPageRenderLinkWithContext(
                                        KmlLoader.class,
                                        mapType
            );
            url = link.toURI();
        }
        return url;
    }

    public String getTitle() {
        return "Contacts";
    }

}

