/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id: Layout.java 1053 2011-03-07 17:14:45Z bleny $
 * $HeadURL: http://svn.forge.codelutin.com/svn/wao/tags/wao-3.1/wao-ui/src/main/java/fr/ifremer/wao/ui/components/Layout.java $
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.wao.ui.components;

import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.ObsProgram;
import fr.ifremer.wao.ui.pages.Administration;
import fr.ifremer.wao.ui.pages.Boats;
import fr.ifremer.wao.ui.pages.Contacts;
import fr.ifremer.wao.ui.pages.Index;
import fr.ifremer.wao.ui.pages.ObsDebSamplingPlan;
import fr.ifremer.wao.ui.pages.SamplingPlan;
import fr.ifremer.wao.ui.pages.Synthesis;
import fr.ifremer.wao.ui.services.ServiceAuthentication;
import fr.ifremer.wao.ui.services.WaoManager;
import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.apache.tapestry5.services.PersistentLocale;
import org.apache.tapestry5.services.Request;
import org.slf4j.Logger;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

/**
 * Layout
 *
 * Created: 9 nov. 2009
 *
 * @author fdesbois <fdesbois@codelutin.com>
 */
public class Layout {

    @Inject
    private WaoManager manager;

    @Parameter(required = true, defaultPrefix = BindingConstants.LITERAL)
    @Property
    private String pageTitle;

    @Parameter(required = true, defaultPrefix = BindingConstants.LITERAL)
    @Property
    private String contentId;

    @InjectComponent
    private FeedBack contentFeedback;

    @Inject
    private Request request;

    @Inject
    private Logger logger;

    @Inject
    private Messages messages;

    @Inject
    private ServiceAuthentication serviceAuthentication;

    private boolean fatal = false;

    boolean afterRender() {
        // Check if fatal errors has been added to the layout
        // Reload the page if feedBack hasn't been reloaded yet to display
        // errors
        if (fatal && contentFeedback.hasErrors() &&
                !contentFeedback.hasBeeanReloaded()) {
            if (logger.isInfoEnabled()) {
                logger.info("[ FATAL ] Reload the page to display" +
                        " errors");
            }
            contentFeedback.reload();
            return false;
        }
        // Clear errors after page render
        contentFeedback.clearErrors();
        fatal = false;
        return true;
    }

    public boolean isDevEnvironment() {
        return manager.isDevEnvironment();
    }

    /**
     * Test if the current user in session is a valid user.
     * Test topia id existence because ConnectedUser can be empty when session is lost
     *
     * @return true if the current user is a valide user (not empty).
     * @see fr.ifremer.wao.ui.services.AppModule#
     * contributeApplicationStateManager(MappedConfiguration)
     */
    public boolean isCurrentUserExists() {
        return serviceAuthentication.existConnectedUser();
    }

    public String getContextPath() {
        return request.getContextPath();
    }
    
    public ConnectedUser getConnectedUser() {
        return serviceAuthentication.getConnectedUser();
    }

    public FeedBack getFeedBack() {
        return this.contentFeedback;
    }

    /*************************** MAIN MENU ************************************/

    /** Page links and link title. */
    private Map<String, String> menuItems;

    @Property
    private Map.Entry<String, String> menuItem;

    @Inject
    private ComponentResources resources;

    @Inject
    private PageRenderLinkSource pageRender;

    public Map getMenuItems() {
        if (menuItems == null) {

            Messages messages = resources.getMessages();
            Map<Class, String> pagesInMenu = new LinkedHashMap<Class, String>();

            // Adding all pages that may be in the main menu
            pagesInMenu.put(SamplingPlan.class, messages.get(n_("wao.ui.page.SamplingPlan.title")));
            pagesInMenu.put(ObsDebSamplingPlan.class, messages.get(n_("wao.ui.page.SamplingPlan.title")));
            pagesInMenu.put(Boats.class, messages.get(n_("wao.ui.page.Boats.title")));
            pagesInMenu.put(Contacts.class, messages.get(n_("wao.ui.page.Contacts.title")));
            pagesInMenu.put(Synthesis.class, messages.get(n_("wao.ui.page.Synthesis.title")));
            pagesInMenu.put(Administration.class, messages.get(n_("wao.ui.page.Administration.title")));

            // now creating the menu by adding only authorized pages
            menuItems = new LinkedHashMap<String, String>();
            for (Map.Entry<Class, String> menuEntry : pagesInMenu.entrySet()) {
                Class page = menuEntry.getKey();
                String linkName = menuEntry.getValue();

                if (serviceAuthentication.isAllowed(page)) {
                    Link link = pageRender.createPageRenderLinkWithContext(page);
                    String url = link.toAbsoluteURI();
                    menuItems.put(url, linkName);
                }
            }
        }
        return menuItems;
    }

    public boolean displayBody() {
        return !fatal;
    }

    /**
     * Add an info message to the layout.
     *
     * @param message of the info
     */
    public void addInfo(String message) {
        contentFeedback.addInfo(message);
    }

    /**
     * Add an error to the layout : display the body any way.
     *
     * @param message of the error
     */
    public void addError(String... message) {
        contentFeedback.addError(message);
    }

    /**
     * Add a fatal error to the layout : don't display the page body.
     *
     * @param message of the error
     */
    public void addFatal(String message) {
        contentFeedback.addError(message);
        fatal = true;
    }


    /********************************* ACTIONS *******************************/

    @Log
    Object onActionFromExit() {
        serviceAuthentication.setConnectedUser(null);
        request.getSession(false).invalidate();
        return Index.class;
    }

    @Log
    Object onActionFromChangeLocale() {
        manager.changeLocale();
        return this;
    }
        
}
