/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.wao.ui.components;

import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.bean.SamplingFilterValues;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.ui.base.FilterManager;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.nuiton.util.PeriodDates;
import org.slf4j.Logger;

import java.text.DateFormat;
import java.text.SimpleDateFormat;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class SamplingFilterComponent {

    @Inject
    private Logger log;

    @Inject
    private ComponentResources resources;

    @InjectComponent
    private Form filtersForm;

    @Parameter(required = true)
    private FilterManager<? extends SamplingFilter> filterManager;

    @Parameter(required = true)
    private String legendMsg;

    @Parameter(required = false)
    private Boolean visibleOnStartup;

    @Parameter(required = false)
    private Boolean showEstimatedTides;

    @InjectComponent
    private Zone filtersZone;

    @Persist
    private Object owner;

    @Persist
    private Boolean filtersVisible;

    /**
     * Current SampleRow from loop
     */
    @Property
    private SampleRow row;

    public String getLegendMsg() {
        return legendMsg;
    }

    // False by default
    public Boolean getShowEstimatedTides() {
        if (showEstimatedTides == null) {
            showEstimatedTides = false;
        }
        return showEstimatedTides;
    }

    // True by default
    public Boolean getVisibleOnStartup() {
        if (visibleOnStartup == null) {
            visibleOnStartup = true;
        }
        return visibleOnStartup;
    }

    public Boolean getFiltersVisible() {
        if (filtersVisible == null) {
            filtersVisible = getVisibleOnStartup();
        }
        return filtersVisible;
    }

    public void setFiltersVisible(Boolean filtersVisible) {
        this.filtersVisible = filtersVisible;
    }

    public void switchFiltersVisible() {
        filtersVisible = !filtersVisible;
    }

    public Zone getFiltersZone() {
        return filtersZone;
    }

    public SamplingFilter getFilter() {
        return filterManager.getFilter();
    }

    public SamplingFilterValues getPossibleValuesForFilter() {
        return filterManager.getPossibleValuesForFilter();
    }

    public FilterManager getFilterManager() {
        return filterManager;
    }

    public void setFilterManager(FilterManager<? extends SamplingFilter> filterManager) {
        this.filterManager = filterManager;
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("MM/yyyy");
    }

    /**
     * Activate reset filter
     */
    private boolean reset;
    private boolean refresh;

    public void onSelectedFromReset() {
        reset = true;
    }

    public void onSelectedFromRefresh() {
        refresh = true;
    }

    /**
     * Do filtering
     *
     * @return owner (for refresh) if filter is edited
     */
    Object onSuccessFromFiltersForm() {
        if (reset) {
            // Don't reset period in filters
            PeriodDates period = getFilter().getPeriod();
            getFilterManager().resetFilter();
            getFilter().setPeriod(period);
        }

        // Limite search panel
        getFilterManager().updatePossibleValuesForFilter();

        if (refresh) {
            // Refresh search panel
            return filtersZone.getBody();
        } else {
            // Refresh owner
            return resources.getContainer();
        }
    }
}
