/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.wao.ui.services;

import fr.ifremer.wao.WaoUtils;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.entity.Contact;
import fr.ifremer.wao.entity.SampleRow;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.PropertyConduit;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.services.BeanModelSource;

import java.lang.annotation.Annotation;

/**
 * Used to generate a bean model for the grid used in sampling plan showed
 * on page {@link fr.ifremer.wao.ui.pages.ObsDebSamplingPlan}.
 *
 * This factory will generate a model showing the columnsForImport that the user
 * has the right to see.
 *
 * @author bleny
 */
public class SampleRowModelFactory {

    protected BeanModelSource beanModelSource;

    protected ComponentResources resources;

    protected ConnectedUser connectedUser;

    protected BeanModel<SampleRow> model;

    public SampleRowModelFactory(BeanModelSource beanModelSource, ComponentResources resources, ConnectedUser connectedUser) {
        this.beanModelSource = beanModelSource;
        this.resources = resources;
        this.connectedUser = connectedUser;
    }

    /** add a property in the model and make it not sortable
     * @param property the name of the property to add
     * @param conduit a PropertyConduit to get the String representation of the
     *        value of the property, may be null if toString can be used */
    protected void add(String property, PropertyConduit conduit) {
        model.add(property, conduit);
        model.get(property).sortable(false);
    }

    protected void add(String property) {
        model.add(property);
        model.get(property).sortable(false);
    }

    protected void initModel() {
        add(SampleRow.PROPERTY_CODE);
        add(SampleRow.PROPERTY_DAY, new SampleRowReaderPropertyConduit() {

            @Override
            public String getValue(SampleRow sampleRow) {
                return WaoUtils.formatDate(sampleRow.getDay());
            }
        });
        add(SampleRow.PROPERTY_OBSERVATION_UNIT);
        add(SampleRow.PROPERTY_COMMENT);
        add("actions", null);
    }


    /** put in common some implementation of PropertyConduit interface. */
    protected static abstract class SampleRowReaderPropertyConduit implements PropertyConduit {

        public abstract String getValue(SampleRow sampleRow);

        @Override
        public String get(Object instance) {
            // cast and delegate
            SampleRow sampleRow = (SampleRow) instance;
            return getValue(sampleRow);
        }

        /** all value returned are string */
        @Override
        public Class getPropertyType() {
            return String.class;
        }

        /** should never be called */
        @Override
        public void set(Object instance, Object value) {
            throw new UnsupportedOperationException();
        }

        /** should never be called */
        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            throw new UnsupportedOperationException();
        }
    }

    public BeanModel<SampleRow> newModel() {
        model = beanModelSource.createDisplayModel(SampleRow.class, resources.getMessages());
        model.include(); // empty the model to include only what we want
        initModel();
        return model;
    }
}
