/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.FacadeRow;
import fr.ifremer.wao.bean.ImportResults;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.bean.SamplingFilterImpl;
import fr.ifremer.wao.entity.FishingZone;
import fr.ifremer.wao.entity.SampleMonth;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.service.ServiceReferential;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.ui.base.AbstractFilteredPage;
import fr.ifremer.wao.ui.components.Layout;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.nuiton.util.PeriodDates;
import org.nuiton.util.StringUtil;
import org.slf4j.Logger;

@RequiresAuthentication
@IncludeStylesheet(value={"context:css/sampling.css"})
public class SamplingPlan
extends AbstractFilteredPage {
    @Inject
    private Logger logger;
    @Inject
    private ServiceSampling serviceSampling;
    @Inject
    private ServiceReferential serviceReferential;
    @InjectComponent
    private Layout layout;
    @SessionState
    @Property
    private ConnectedUser user;
    private long nbTidesExpectedTime;
    private long nbTidesRealTime;
    private long totalTidesExpectedTime;
    private long totalTidesRealTime;
    @Property
    private UploadedFile samplingPlanCsvFile;
    @Persist
    private SamplingFilter filter;
    @InjectComponent
    private Zone filtersZone;
    @InjectComponent
    private Form filtersForm;
    private boolean reset;
    @Persist
    @Property
    private Boolean fullView;
    private List<SampleRow> data;
    private List<Date> months;
    @Property
    private Date month;
    @Property
    private SampleRow row;
    @Property
    private String currentFacadeName;
    @Property
    private String currentSectorName;
    private static final StringUtil.ToString<FishingZone> FISHING_ZONE_TO_STRING_DISTRICT = new /* Unavailable Anonymous Inner Class!! */;
    @Property
    private int rowIndex;

    void setupRender() {
        if (this.isFiltersVisible()) {
            this.initSelectFilters(true, false, true);
        }
        if (this.fullView == null) {
            this.fullView = this.user.isAdmin();
        }
        this.initCompanyFilter();
    }

    public boolean canImportSamplingPlan() {
        return this.user.isAdmin() && !this.user.isReadOnly();
    }

    @Log
    void onSuccessFromImportSamplingPlan() throws WaoException {
        if (this.canImportSamplingPlan()) {
            try {
                ImportResults result = this.serviceSampling.importSamplingPlanCsv(this.samplingPlanCsvFile.getStream());
                this.layout.addInfo(result.getNbRowsImported() + " lignes du plan import\u00e9s,  " + result.getNbRowsRefused() + " refus\u00e9s.");
                for (String error : result.getErrors()) {
                    this.layout.addInfo(error);
                }
            }
            catch (WaoBusinessException eee) {
                this.layout.addError(new String[]{eee.getMessage()});
            }
        }
    }

    StreamResponse onActionFromExportSamplingPlan() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public PeriodDates getPeriod() {
        return this.getFilter().getPeriod();
    }

    public SamplingFilter getFilter() throws WaoException {
        if (this.filter == null) {
            this.filter = new SamplingFilterImpl();
            PeriodDates period = PeriodDates.createMonthsPeriodFromToday((int)11);
            this.filter.setPeriod(period);
        }
        return this.filter;
    }

    protected boolean isAvailableDataForFiltersOnly() {
        return false;
    }

    public boolean isFiltersVisible() {
        boolean companyFiltered = this.getFilter().getCompany() != null && this.user.isAdmin();
        return !this.getFilter().isPeriodFilteredOnly() || companyFiltered;
    }

    Object onActionFromShowFilters() {
        this.initSelectFilters(true, false, true);
        return this.filtersZone.getBody();
    }

    public String[] onProvideCompletionsFromCodeDCF5(String input) throws WaoException {
        List results = this.serviceReferential.getCodesDCF5Contains(input);
        return results.toArray(new String[0]);
    }

    void onSelectedFromReset() {
        this.reset = true;
    }

    Object onSuccessFromFiltersForm() {
        if (this.isEdited()) {
            return this.filtersZone.getBody();
        }
        if (this.reset) {
            PeriodDates period = this.getFilter().getPeriod();
            this.filter = null;
            this.getFilter().setPeriod(period);
        }
        return this;
    }

    void onActionFromToggleDisplayMode() {
        this.fullView = this.fullView == false;
    }

    void onActionFromChangeFilterEstimatedTides() {
        boolean oldValue = this.getFilter().getEstimatedTides();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Change estimatedTides in filter to : " + !oldValue);
        }
        this.getFilter().setEstimatedTides(!oldValue);
    }

    public List<SampleRow> getData() throws WaoException {
        if (this.data == null) {
            FacadeRow facade = this.serviceSampling.getSampleRowsOrderedByFishingZone(this.getFilter());
            this.data = facade.getValues();
        }
        return this.data;
    }

    public List<Date> getMonths() {
        if (this.months == null) {
            this.months = this.getPeriod().getMonths();
        }
        return this.months;
    }

    public boolean isFacadeChanged() {
        if (!this.row.getFacade().equals(this.currentFacadeName)) {
            this.currentFacadeName = this.row.getFacade();
            return true;
        }
        return false;
    }

    public boolean isSectorChanged() {
        if (!this.row.getSectors().equals(this.currentSectorName)) {
            this.currentSectorName = this.row.getSectors();
            return true;
        }
        return false;
    }

    public String getCompanyName() {
        return this.row.getCompany() != null ? this.row.getCompany().getName() : "";
    }

    public boolean isCurrentMonth() {
        String currentStr = this.getDateFormat().format(new Date());
        String monthStr = this.getDateFormat().format(this.month);
        return currentStr.equals(monthStr);
    }

    public Integer getNbTidesExpected() {
        Integer result = null;
        SampleMonth sampleMonth = this.row.getSampleMonth(this.month);
        if (sampleMonth != null) {
            result = sampleMonth.getExpectedTidesValue();
        }
        return result;
    }

    public String getFishingZones() {
        return StringUtil.join((Iterable)this.row.getFishingZone(), (StringUtil.ToString)FISHING_ZONE_TO_STRING_DISTRICT, (String)", ", (boolean)false);
    }

    public Integer getNbTidesReal() {
        Integer result = null;
        SampleMonth sampleMonth = this.row.getSampleMonth(this.month);
        if (sampleMonth != null) {
            result = this.getFilter().getEstimatedTides() ? sampleMonth.getEstimatedTidesValue() : sampleMonth.getRealTidesValue();
        }
        return result;
    }

    public boolean hasNbTidesReal() {
        Date current = new Date();
        boolean validMonth = this.month.before(current) || this.isCurrentMonth();
        return validMonth && this.getNbTidesReal() != null;
    }

    public boolean canDisplayTidesReal() {
        boolean result = this.hasNbTidesReal() && !this.user.isGuest();
        return result;
    }

    public String getTotalPercentage() {
        double result = 0.0;
        if (this.row.getTotalTidesExpected() > 0) {
            result = (double)this.row.getTotalTidesReal().intValue() / (double)this.row.getTotalTidesExpected().intValue();
        }
        return NumberFormat.getPercentInstance().format(result);
    }

    public NumberFormat getNumberFormat() {
        return NumberFormat.getNumberInstance();
    }

    public String getRowComment() {
        String comment = this.row.getComment();
        comment = comment.replace("\n", "<br />");
        return comment;
    }

    public int getNbColumnsForProfession() {
        int fixed = 5;
        if (this.fullView.booleanValue()) {
            fixed += 8;
        }
        return fixed;
    }

    public int getNbColumnsForMonths() {
        return this.getMonths().size() + 1;
    }

    public int getNbColumnsForOther() {
        return 4;
    }

    public int getNbColumnsTotal() {
        return this.getNbColumnsForProfession() + this.getNbColumnsForMonths() + this.getNbColumnsForOther();
    }

    public String getMainClass() {
        return this.fullView != false ? "admin" : "user";
    }

    public String getParityClass() {
        return this.rowIndex % 2 == 0 ? "even" : "odd";
    }

    public String getActionsClass() {
        return this.fullView != false ? "width100" : "width50";
    }

    public String getRealTidesClass() {
        String result = "real-warning";
        if (this.getNbTidesReal() < this.getNbTidesExpected()) {
            result = result + "-inf";
        } else if (this.getNbTidesReal() > this.getNbTidesExpected()) {
            result = result + "-sup";
        }
        return result;
    }

    public String getMonthCurrentClass() {
        return this.isCurrentMonth() ? "selected" : "";
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("MM/yyyy");
    }

    public boolean canEditSampleRow() {
        return this.user.isAdmin() && !this.user.isReadOnly();
    }

    void onActionFromFilterPeriodDates(int rowIndex) throws WaoException {
        this.row = (SampleRow)this.getData().get(rowIndex);
        this.getPeriod().setFromDate(this.row.getPeriodBegin());
        this.getPeriod().setThruDate(this.row.getPeriodEnd());
    }

    void onActionFromDeleteSampleRow(int rowIndex) throws WaoException {
        this.row = (SampleRow)this.getData().get(rowIndex);
        this.serviceSampling.deleteSampleRow(this.row);
    }

    public boolean isRowNotFinished() {
        return !this.row.isFinished(-1);
    }

    static /* synthetic */ ConnectedUser access$000(SamplingPlan x0) {
        return x0.user;
    }

    static /* synthetic */ ServiceSampling access$100(SamplingPlan x0) {
        return x0.serviceSampling;
    }
}

