/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.services;

import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.pages.Connexion;
import fr.ifremer.wao.ui.pages.Unavailable;
import fr.ifremer.wao.ui.services.ServiceAuthentication;
import java.io.IOException;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.services.ComponentEventRequestParameters;
import org.apache.tapestry5.services.ComponentRequestFilter;
import org.apache.tapestry5.services.ComponentRequestHandler;
import org.apache.tapestry5.services.ComponentSource;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.apache.tapestry5.services.PageRenderRequestParameters;
import org.apache.tapestry5.services.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequiresAuthenticationFilter
implements ComponentRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(RequiresAuthenticationFilter.class);
    private final PageRenderLinkSource pageRender;
    private final ComponentSource componentSource;
    private final Response response;
    private final ServiceAuthentication serviceAuthentication;

    public RequiresAuthenticationFilter(PageRenderLinkSource renderLinkSource, ComponentSource componentSource, Response response, ServiceAuthentication serviceAuthentication) {
        this.pageRender = renderLinkSource;
        this.componentSource = componentSource;
        this.response = response;
        this.serviceAuthentication = serviceAuthentication;
        if (logger.isTraceEnabled()) {
            logger.trace("Construct");
        }
    }

    public void handleComponentEvent(ComponentEventRequestParameters parameters, ComponentRequestHandler handler) throws IOException {
        if (logger.isTraceEnabled()) {
            logger.trace("handleComponentEvent");
        }
        if (this.dispatchedToLoginPage(parameters.getActivePageName())) {
            return;
        }
        handler.handleComponentEvent(parameters);
    }

    public void handlePageRender(PageRenderRequestParameters parameters, ComponentRequestHandler handler) throws IOException {
        if (logger.isTraceEnabled()) {
            logger.trace("handlePageRender");
        }
        if (this.dispatchedToLoginPage(parameters.getLogicalPageName())) {
            return;
        }
        handler.handlePageRender(parameters);
    }

    private boolean dispatchedToLoginPage(String pageName) throws IOException {
        Component page = this.componentSource.getPage(pageName);
        if (logger.isTraceEnabled()) {
            logger.trace("Page name : " + pageName);
            logger.trace("Page class : " + page.getClass());
            logger.trace("RequiresLogin annotation : " + page.getClass().isAnnotationPresent(RequiresAuthentication.class));
            logger.trace("User in session : " + this.serviceAuthentication.isUserConnected());
        }
        if (!page.getClass().isAnnotationPresent(RequiresAuthentication.class)) {
            return false;
        }
        Class<Connexion> redirectPage = Connexion.class;
        if (this.serviceAuthentication.isUserConnected()) {
            WaoUser user = this.serviceAuthentication.getUserConnected();
            if (logger.isTraceEnabled()) {
                logger.trace("User connected : " + user);
                logger.trace("User role : " + user.getUserRole().name());
                logger.trace("User allowed : " + this.serviceAuthentication.isAllowed(page.getClass()));
            }
            if (this.serviceAuthentication.isAllowed(page.getClass())) {
                return false;
            }
            redirectPage = Unavailable.class;
        }
        Link link = this.pageRender.createPageRenderLinkWithContext(redirectPage, new Object[]{pageName});
        if (logger.isTraceEnabled()) {
            logger.trace("Redirection to " + redirectPage.getSimpleName() + " page...");
        }
        this.response.sendRedirect(link);
        return true;
    }
}

