/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.caliper.feed;

import fr.ifremer.tutti.caliper.feed.CaliperConnectionException;
import fr.ifremer.tutti.caliper.feed.event.CaliperFeedReaderEvent;
import fr.ifremer.tutti.caliper.feed.event.CaliperFeedReaderListener;
import fr.ifremer.tutti.caliper.feed.record.CaliperFeedReaderMeasureRecord;
import fr.ifremer.tutti.caliper.feed.record.CaliperFeedReaderRecordFactory;
import fr.ifremer.tutti.caliper.feed.record.CaliperFeedReaderRecordSupport;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.TooManyListenersException;
import javax.swing.event.EventListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CaliperFeedReader
implements Closeable {
    private static final Log log = LogFactory.getLog(CaliperFeedReader.class);
    private static final String SERIAL_PORT_PREFIX = "COM";
    protected String serialPortName;
    protected SerialPort serialPort;
    protected final EventListenerList listenerList = new EventListenerList();
    protected final CaliperFeedReaderRecordFactory recordFactory = new CaliperFeedReaderRecordFactory();

    public void start(int portNumber) throws CaliperConnectionException {
        this.serialPortName = SERIAL_PORT_PREFIX + portNumber;
        try {
            CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)this.serialPortName);
            this.serialPort = portIdentifier.open(this.getClass().getName(), 2000);
            this.serialPort.setSerialPortParams(4800, 7, 1, 2);
            InputStream inputStream = this.serialPort.getInputStream();
            this.serialPort.addEventListener((SerialPortEventListener)new SerialReader(inputStream));
            this.serialPort.notifyOnDataAvailable(true);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Ready to read remote device...");
            }
        }
        catch (NoSuchPortException | PortInUseException | UnsupportedCommOperationException | IOException | TooManyListenersException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Error while connecting to the serial port " + this.serialPortName), e);
            }
            throw new CaliperConnectionException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.serialPort.close();
    }

    public void addFeedModeReaderListener(CaliperFeedReaderListener listener) {
        this.listenerList.add(CaliperFeedReaderListener.class, listener);
    }

    public void removeFeedModeReaderListener(CaliperFeedReaderListener listener) {
        this.listenerList.remove(CaliperFeedReaderListener.class, listener);
    }

    public void removeAllFeedModeReaderListeners() {
        for (CaliperFeedReaderListener listener : (CaliperFeedReaderListener[])this.listenerList.getListeners(CaliperFeedReaderListener.class)) {
            this.listenerList.remove(CaliperFeedReaderListener.class, listener);
        }
    }

    public String getSerialPortName() {
        return this.serialPortName;
    }

    public class SerialReader
    implements SerialPortEventListener {
        private InputStream in;
        private byte[] buffer = new byte[1024];

        public SerialReader(InputStream in) {
            this.in = in;
        }

        public void serialEvent(SerialPortEvent arg0) {
            block4: {
                try {
                    CaliperFeedReaderRecordSupport readerRecord = this.readRecord();
                    if (readerRecord != null && readerRecord instanceof CaliperFeedReaderMeasureRecord) {
                        CaliperFeedReaderEvent e = new CaliperFeedReaderEvent(CaliperFeedReader.this, (CaliperFeedReaderMeasureRecord)readerRecord);
                        for (CaliperFeedReaderListener listener : (CaliperFeedReaderListener[])CaliperFeedReader.this.listenerList.getListeners(CaliperFeedReaderListener.class)) {
                            listener.recordRead(e);
                        }
                    }
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)"Could not read record", (Throwable)e);
                }
            }
        }

        private CaliperFeedReaderRecordSupport readRecord() throws IOException {
            int data;
            int len = 0;
            while ((data = this.in.read()) > -1 && data != 10) {
                this.buffer[len++] = (byte)data;
            }
            String result = new String(this.buffer, 0, len);
            if (log.isInfoEnabled()) {
                log.info((Object)("New raw record: " + result));
            }
            CaliperFeedReaderRecordSupport readerRecord = CaliperFeedReader.this.recordFactory.newRecord(result);
            if (log.isDebugEnabled()) {
                log.debug((Object)("New feed record: " + readerRecord));
            }
            return readerRecord;
        }
    }
}

