/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.actions;

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.service.catches.multipost.MultiPostImportService;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.actions.ImportMultiPostActionSupport;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesOrBenthosBatchUISupport;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchUIModel;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.nuiton.i18n.I18n;

public abstract class ImportMultiPostSpeciesSupportAction
extends ImportMultiPostActionSupport<SpeciesBatchUIModel, SpeciesBatchUI, SpeciesBatchUIHandler> {
    protected ImportMultiPostSpeciesSupportAction(SpeciesBatchUIHandler handler) {
        super(handler);
    }

    public abstract boolean isImportFrequencies();

    public abstract boolean isImportIndivudalObservations();

    @Override
    protected final Map<String, Object> importBatches(MultiPostImportService multiPostImportExportService, File file, FishingOperation operation) {
        SpeciesOrBenthosBatchUISupport batchUISupport = ((SpeciesBatchUIModel)this.getModel()).getSpeciesOrBenthosBatchUISupport();
        return batchUISupport.importMultiPost(file, operation, this.isImportFrequencies(), this.isImportIndivudalObservations());
    }

    @Override
    protected final String buildNotImportedDataReportText(Map<String, Object> notImportedData) {
        WeightUnit speciesWeightUnit = this.getConfig().getSpeciesWeightUnit();
        StringBuilder builder = new StringBuilder();
        Float totalSortedWeight = (Float)notImportedData.get("speciesTotalSortedWeight");
        this.addNotImportedWeightToReport(builder, totalSortedWeight, speciesWeightUnit, I18n.n((String)"tutti.multiPostImportLog.totalSortedWeight", (Object[])new Object[0]));
        Float inertWeight = (Float)notImportedData.get("speciesTotalInertWeight");
        this.addNotImportedWeightToReport(builder, inertWeight, speciesWeightUnit, I18n.n((String)"tutti.multiPostImportLog.inertWeight", (Object[])new Object[0]));
        Float livingNotItemizedWeight = (Float)notImportedData.get("speciesTotalLivingNotItemizedWeight");
        this.addNotImportedWeightToReport(builder, livingNotItemizedWeight, speciesWeightUnit, I18n.n((String)"tutti.multiPostImportLog.livingNotItemizedWeight", (Object[])new Object[0]));
        Collection notImportedSpeciesBatches = (Collection)notImportedData.get("batchesKey");
        for (SpeciesBatch sb : notImportedSpeciesBatches) {
            builder.append("- ").append(this.decorate(sb.getSpecies())).append(" / ").append(this.decorate(sb.getSampleCategoryValue())).append("\n");
        }
        return builder.toString();
    }
}

