/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.font;

import com.lowagie.text.pdf.BaseFont;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.birt.report.engine.layout.pdf.font.CompositeFont;
import org.eclipse.birt.report.engine.layout.pdf.font.CompositeFontConfig;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingConfig;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManagerFactory;

public class FontMappingManager {
    public static final String FONT_NAME_ALL_FONTS = "all-fonts";
    public static final String DEFAULT_FONT = "Times-Roman";
    private FontMappingManagerFactory factory;
    private FontMappingManager parent;
    private Map fontEncodings = new HashMap();
    private Map searchSequences = new HashMap();
    private Map fontAliases = new HashMap();
    private Map compositeFonts = new HashMap();

    FontMappingManager(FontMappingManagerFactory factory, FontMappingManager parent, FontMappingConfig config, Locale locale) {
        this.factory = factory;
        this.parent = parent;
        if (parent != null) {
            this.searchSequences.putAll(parent.getSearchSequences());
            this.fontAliases.putAll(parent.getFontAliases());
            this.fontEncodings.putAll(parent.getFontEncodings());
            this.compositeFonts.putAll(parent.getCompositeFonts());
        }
        this.fontEncodings.putAll(config.fontEncodings);
        this.searchSequences.putAll(config.searchSequences);
        this.fontAliases.putAll(config.fontAliases);
        String[] sequence = this.getSearchSequence(locale);
        for (Map.Entry entry : config.compositeFonts.entrySet()) {
            String fontName = (String)entry.getKey();
            CompositeFontConfig fontConfig = (CompositeFontConfig)entry.getValue();
            CompositeFont font = factory.createCompositeFont(this, fontConfig, sequence);
            this.compositeFonts.put(fontName, font);
        }
    }

    public FontMappingManager getParent() {
        return this.parent;
    }

    public Map getFontEncodings() {
        return this.fontEncodings;
    }

    public Map getFontAliases() {
        return this.fontAliases;
    }

    public Map getSearchSequences() {
        return this.searchSequences;
    }

    public Map getCompositeFonts() {
        return this.compositeFonts;
    }

    protected String[] getSearchSequence(Locale locale) {
        StringBuffer sb = new StringBuffer();
        String[] localeKeys = new String[3];
        localeKeys[2] = sb.append(locale.getLanguage()).toString();
        localeKeys[1] = sb.append('_').append(locale.getCountry()).toString();
        localeKeys[0] = sb.append('_').append(locale.getVariant()).toString();
        int i = 0;
        while (i < localeKeys.length) {
            String[] sequence = (String[])this.searchSequences.get(localeKeys[i]);
            if (sequence != null) {
                return sequence;
            }
            ++i;
        }
        return null;
    }

    public CompositeFont getCompositeFont(String name) {
        return (CompositeFont)this.compositeFonts.get(name);
    }

    public String getDefaultPhysicalFont(char c) {
        CompositeFont compositeFont = (CompositeFont)this.compositeFonts.get(FONT_NAME_ALL_FONTS);
        if (compositeFont != null) {
            String font = compositeFont.getUsedFont(c);
            if (font != null) {
                return font;
            }
            return compositeFont.getDefaultFont();
        }
        return null;
    }

    public String getAliasedFont(String fontAlias) {
        String alias = (String)this.fontAliases.get(fontAlias);
        if (alias != null) {
            return alias;
        }
        return fontAlias;
    }

    public BaseFont createFont(String fontFamily, int fontStyle) {
        return this.factory.createFont(fontFamily, fontStyle);
    }
}

