/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.catches.WeightComputingService;
import fr.ifremer.tutti.service.genericformat.csv.AccidentalCatchRow;
import fr.ifremer.tutti.service.genericformat.csv.AttachmentRow;
import fr.ifremer.tutti.service.genericformat.csv.CatchRow;
import fr.ifremer.tutti.service.genericformat.csv.IndividualObservationRow;
import fr.ifremer.tutti.service.genericformat.csv.MarineLitterRow;
import fr.ifremer.tutti.service.genericformat.csv.OperationRow;
import fr.ifremer.tutti.service.genericformat.csv.ParameterRow;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenericFormatExportOperationContext {
    private static final Log log = LogFactory.getLog(GenericFormatExportOperationContext.class);
    private final Cruise cruise;
    private final FishingOperation operation;
    private final CatchBatch catchBatch;
    private BatchContainer<MarineLitterBatch> rootMarineLitterBatch;
    private BatchContainer<SpeciesBatch> rootSpeciesBatch;
    private BatchContainer<SpeciesBatch> rootBenthosBatch;
    private List<IndividualObservationBatch> individualObservations;
    private List<AccidentalBatch> accidentalBatches;
    private boolean withCatchBatch;
    private final PersistenceService persistenceService;
    protected final Caracteristic weightMeasuredCaracteristic;
    protected final Caracteristic pmfmIdCaracteristic;
    protected final Caracteristic deadOrAliveCaracteristic;
    protected final Caracteristic genderCaracteristic;
    private final Caracteristic copyIndividualObservationModeCaracteristic;
    private final Caracteristic sampleCodeCaracteristic;
    private final SampleCategoryModel sampleCategoryModel;
    private final String operationLabel;
    private OperationRow operationRow;
    private List<ParameterRow> parameterRows;
    private List<MarineLitterRow> marineLitterRows;
    private List<IndividualObservationRow> individualObservationRows;
    private List<AccidentalCatchRow> accidentalCatchRows;
    private List<CatchRow> catchRows;
    private final List<AttachmentRow> attachmentRows;

    public GenericFormatExportOperationContext(Cruise cruise, FishingOperation operation, String operationLabel, PersistenceService persistenceService, WeightComputingService weightComputingService, SampleCategoryModel sampleCategoryModel, Caracteristic weightMeasuredCaracteristic, Caracteristic pmfmIdCaracteristic, Caracteristic deadOrAliveCaracteristic, Caracteristic genderCaracteristic, Caracteristic copyIndividualObservationModeCaracteristic, Caracteristic sampleCodeCaracteristic) {
        this.cruise = cruise;
        this.operation = operation;
        this.operationLabel = operationLabel;
        this.sampleCategoryModel = sampleCategoryModel;
        this.persistenceService = persistenceService;
        this.weightMeasuredCaracteristic = weightMeasuredCaracteristic;
        this.pmfmIdCaracteristic = pmfmIdCaracteristic;
        this.deadOrAliveCaracteristic = deadOrAliveCaracteristic;
        this.genderCaracteristic = genderCaracteristic;
        this.copyIndividualObservationModeCaracteristic = copyIndividualObservationModeCaracteristic;
        this.sampleCodeCaracteristic = sampleCodeCaracteristic;
        this.attachmentRows = new ArrayList<AttachmentRow>();
        Integer operationId = operation.getIdAsInt();
        this.accidentalBatches = persistenceService.getAllAccidentalBatch(operationId);
        this.withCatchBatch = persistenceService.isFishingOperationWithCatchBatch(operationId);
        if (this.withCatchBatch) {
            block15: {
                this.catchBatch = persistenceService.getCatchBatchFromFishingOperation(operationId);
                boolean withError = false;
                try {
                    this.rootSpeciesBatch = weightComputingService.getComputedSpeciesBatches(operationId);
                }
                catch (Exception e) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"Could not getComputedSpeciesBatches", (Throwable)e);
                    }
                    withError = true;
                    this.rootSpeciesBatch = persistenceService.getRootSpeciesBatch(operationId, false);
                }
                try {
                    this.rootBenthosBatch = weightComputingService.getComputedBenthosBatches(operationId);
                }
                catch (Exception e) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"Could not getComputedBenthosBatches", (Throwable)e);
                    }
                    withError = true;
                    this.rootBenthosBatch = persistenceService.getRootBenthosBatch(operationId, false);
                }
                try {
                    this.rootMarineLitterBatch = weightComputingService.getComputedMarineLitterBatches(operationId, this.catchBatch.getMarineLitterTotalWeight());
                }
                catch (Exception e) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"Could not getComputedMarineLitterBatches", (Throwable)e);
                    }
                    withError = true;
                    this.rootMarineLitterBatch = persistenceService.getRootMarineLitterBatch(operationId);
                }
                if (!withError) {
                    try {
                        weightComputingService.computeCatchBatchWeights(this.catchBatch, this.rootSpeciesBatch, this.rootBenthosBatch, this.rootMarineLitterBatch);
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) break block15;
                        log.warn((Object)"Could not computeCatchBatchWeights", (Throwable)e);
                    }
                }
            }
            this.individualObservations = persistenceService.getAllIndividualObservationBatchsForFishingOperation(operation.getIdAsInt());
        } else {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Skip fishing operation " + operationId + " since no catchBatch associated."));
            }
            this.catchBatch = null;
            this.rootSpeciesBatch = null;
            this.rootBenthosBatch = null;
            this.rootMarineLitterBatch = null;
        }
    }

    public Cruise getCruise() {
        return this.cruise;
    }

    public FishingOperation getOperation() {
        return this.operation;
    }

    public CatchBatch getCatchBatch() {
        return this.catchBatch;
    }

    public BatchContainer<MarineLitterBatch> getRootMarineLitterBatch() {
        return this.rootMarineLitterBatch;
    }

    public BatchContainer<SpeciesBatch> getRootSpeciesBatch() {
        return this.rootSpeciesBatch;
    }

    public BatchContainer<SpeciesBatch> getRootBenthosBatch() {
        return this.rootBenthosBatch;
    }

    public boolean isWithCatchBatch() {
        return this.withCatchBatch;
    }

    public List<IndividualObservationBatch> getIndividualObservations() {
        return this.individualObservations;
    }

    public Caracteristic getWeightMeasuredCaracteristic() {
        return this.weightMeasuredCaracteristic;
    }

    public Caracteristic getPmfmIdCaracteristic() {
        return this.pmfmIdCaracteristic;
    }

    public Caracteristic getDeadOrAliveCaracteristic() {
        return this.deadOrAliveCaracteristic;
    }

    public Caracteristic getGenderCaracteristic() {
        return this.genderCaracteristic;
    }

    public Caracteristic getCopyIndividualObservationModeCaracteristic() {
        return this.copyIndividualObservationModeCaracteristic;
    }

    public Caracteristic getSampleCodeCaracteristic() {
        return this.sampleCodeCaracteristic;
    }

    public List<AccidentalBatch> getAccidentalBatches() {
        return this.accidentalBatches;
    }

    public boolean isVracBatch(SpeciesBatch batch) {
        return this.persistenceService.isVracBatch(batch);
    }

    public List<SpeciesBatchFrequency> getAllBenthosBatchFrequency(Integer id) {
        return this.persistenceService.getAllBenthosBatchFrequency(id);
    }

    public List<SpeciesBatchFrequency> getAllSpeciesBatchFrequency(Integer id) {
        return this.persistenceService.getAllSpeciesBatchFrequency(id);
    }

    public SampleCategoryModel getSampleCategoryModel() {
        return this.sampleCategoryModel;
    }

    public String getOperationLabel() {
        return this.operationLabel;
    }

    public void setOperationRow(OperationRow operationRow) {
        this.operationRow = operationRow;
    }

    public OperationRow getOperationRow() {
        return this.operationRow;
    }

    public void setParameterRows(List<ParameterRow> parameterRows) {
        this.parameterRows = parameterRows;
    }

    public List<ParameterRow> getParameterRows() {
        return this.parameterRows;
    }

    public void setMarineLitterRows(List<MarineLitterRow> marineLitterRows) {
        this.marineLitterRows = marineLitterRows;
    }

    public List<MarineLitterRow> getMarineLitterRows() {
        return this.marineLitterRows;
    }

    public void setIndividualObservationRows(List<IndividualObservationRow> individualObservationRows) {
        this.individualObservationRows = individualObservationRows;
    }

    public List<IndividualObservationRow> getIndividualObservationRows() {
        return this.individualObservationRows;
    }

    public void setAccidentalCatchRows(List<AccidentalCatchRow> accidentalCatchRows) {
        this.accidentalCatchRows = accidentalCatchRows;
    }

    public List<AccidentalCatchRow> getAccidentalCatchRows() {
        return this.accidentalCatchRows;
    }

    public void setCatchRows(List<CatchRow> catchRows) {
        this.catchRows = catchRows;
    }

    public List<CatchRow> getCatchRows() {
        return this.catchRows;
    }

    public List<AttachmentRow> getAttachmentRows() {
        return this.attachmentRows;
    }

    public void addAttachmentRows(List<AttachmentRow> attachmentRows) {
        if (CollectionUtils.isNotEmpty(attachmentRows)) {
            this.attachmentRows.addAll(attachmentRows);
        }
    }
}

