/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.attachment;

import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentEditorUI;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentItem;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentItemModel;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import fr.ifremer.tutti.ui.swing.util.attachment.actions.HideAttachmentUIAction;
import fr.ifremer.tutti.ui.swing.util.attachment.actions.ShowAttachmentUIAction;
import java.awt.Component;
import java.awt.Container;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import jaxx.runtime.swing.ComponentMover;
import jaxx.runtime.swing.ComponentResizer;
import jaxx.runtime.validator.swing.SwingValidator;
import org.nuiton.jaxx.application.swing.ApplicationUI;

public class AttachmentEditorUIHandler
extends AbstractTuttiUIHandler<TuttiUIContext, AttachmentEditorUI> {
    public static final String CLOSE_DIALOG_ACTION = "closeDialog";
    public static final String SHOW_DIALOG_ACTION = "showDialog";
    protected Action closeAction;
    protected Action openAction;

    public void beforeInit(AttachmentEditorUI ui) {
        super.beforeInit((ApplicationUI)ui);
        ui.setContextValue(TuttiUIContext.getApplicationContext());
    }

    public void afterInit(AttachmentEditorUI ui) {
        this.initButton(ui.getAddButton());
        ui.getFile().setDialogOwner((JDialog)ui);
        ui.pack();
        ui.setResizable(true);
        ComponentResizer cr = new ComponentResizer();
        cr.registerComponent(new Component[]{ui});
        ComponentMover cm = new ComponentMover();
        cm.setDragInsets(cr.getDragInsets());
        cm.registerComponent(new Component[]{ui});
        this.closeAction = new HideAttachmentUIAction(ui);
        this.openAction = new ShowAttachmentUIAction(ui);
        JRootPane rootPane = ui.getRootPane();
        KeyStroke shortcutClosePopup = KeyStroke.getKeyStroke(27, 0);
        rootPane.getInputMap(2).put(shortcutClosePopup, CLOSE_DIALOG_ACTION);
        rootPane.getActionMap().put(CLOSE_DIALOG_ACTION, this.closeAction);
        rootPane.getActionMap().put(SHOW_DIALOG_ACTION, this.openAction);
        JButton closeButton = new JButton(this.closeAction);
        closeButton.setText(null);
        closeButton.setFocusPainted(false);
        closeButton.setRequestFocusEnabled(false);
        closeButton.setFocusable(false);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setOpaque(false);
        jToolBar.add(this.closeAction);
        jToolBar.setBorderPainted(false);
        jToolBar.setFloatable(false);
        ui.getAttachmentBody().setRightDecoration((JComponent)jToolBar);
    }

    protected JComponent getComponentToFocus() {
        return ((AttachmentEditorUI)this.getUI()).getFile();
    }

    public void onCloseUI() {
        ((AttachmentEditorUI)this.ui).dispose();
    }

    public SwingValidator<TuttiUIContext> getValidator() {
        return null;
    }

    public void closeEditor() {
        this.closeAction.actionPerformed(null);
    }

    public void openEditor(JComponent component) {
        if (component != null) {
            this.place(component);
        }
        this.openAction.actionPerformed(null);
    }

    public void init() {
        List<Attachment> list;
        this.resetFields();
        ((AttachmentEditorUI)this.ui).getAttachments().removeAll();
        AttachmentModelAware bean = ((AttachmentEditorUI)this.ui).getBean();
        if (bean != null && (list = bean.getAttachment()) != null) {
            for (Attachment attachment : list) {
                this.addAttachment(attachment);
            }
        }
    }

    public void place(JComponent component) {
        int x = 0;
        int y = component.getHeight();
        for (Container comp = component; comp != null; comp = comp.getParent()) {
            x += ((Component)comp).getX();
            y += ((Component)comp).getY();
        }
        ((AttachmentEditorUI)this.ui).pack();
        if (x + ((AttachmentEditorUI)this.ui).getWidth() > ((AttachmentEditorUI)this.ui).getOwner().getX() + ((AttachmentEditorUI)this.ui).getOwner().getWidth()) {
            x = x - ((AttachmentEditorUI)this.ui).getWidth() + component.getWidth();
        }
        ((AttachmentEditorUI)this.ui).setLocation(x, y);
    }

    public void addAttachment(Attachment attachment) {
        AttachmentItemModel model = new AttachmentItemModel();
        model.fromEntity(attachment);
        ((AttachmentEditorUI)this.ui).setContextValue(model);
        AttachmentItem item = new AttachmentItem((AttachmentEditorUI)this.ui);
        ((AttachmentEditorUI)this.ui).getAttachments().add(item);
    }

    public void resetFields() {
        ((AttachmentEditorUI)this.ui).getFile().setSelectedFilePath(null);
        ((AttachmentEditorUI)this.ui).getFileName().setText("");
        ((AttachmentEditorUI)this.ui).getFileComment().setText("");
    }
}

