/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.birt.report.engine.api.script.instance.IScriptStyle;
import org.eclipse.birt.report.engine.toc.ITreeNode;
import org.eclipse.birt.report.engine.toc.ViewNode;

public class ViewNodeList
extends AbstractList<ViewNode> {
    ViewNode parent;
    private static final int MAX_CACHE_SIZE = 16;
    private ViewNode[] cacheChildren = new ViewNode[16];
    private ViewNodeIterator cacheIter;
    private int cacheIndex;
    private int size;

    public ViewNodeList(ViewNode parent) {
        this.parent = parent;
        this.size = -1;
    }

    @Override
    public synchronized ViewNode get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        this.refreshCaches(index);
        if (index >= this.cacheIndex - 16 && index < this.cacheIndex) {
            return this.cacheChildren[index % 16];
        }
        throw new IndexOutOfBoundsException("Index: " + index);
    }

    protected void refreshCaches(int index) {
        int firstCache;
        if (index < this.cacheIndex && index >= (firstCache = this.cacheIndex - 16)) {
            return;
        }
        if (index < this.cacheIndex || this.cacheIter == null) {
            this.cacheIter = new ViewNodeIterator();
            this.cacheIndex = 0;
        }
        int i = this.cacheIndex;
        while (i <= index) {
            if (this.cacheIter.hasNext()) {
                this.cacheChildren[i % 16] = this.cacheIter.next();
                ++this.cacheIndex;
            } else {
                this.size = this.cacheIndex;
            }
            ++i;
        }
    }

    @Override
    public synchronized int size() {
        if (this.size == -1) {
            this.size = this.calculateListSize();
        }
        return this.size;
    }

    private int calculateListSize() {
        ViewNodeIterator iter = new ViewNodeIterator();
        int size = 0;
        while (iter.hasNext()) {
            iter.next();
            ++size;
        }
        return size;
    }

    protected ViewNode createGroupNode(ViewNode parent, ITreeNode treeNode) {
        ITreeNode labelNode = this.getFirstNoneNode(treeNode);
        if (labelNode != null) {
            ViewNode groupNode = new ViewNode(parent, treeNode);
            Object groupValue = labelNode.getTOCValue();
            IScriptStyle groupStyle = groupNode.getTOCStyle();
            String groupLabel = parent.view.localizeValue(groupValue, groupStyle);
            groupNode.setDisplayString(groupLabel);
            return groupNode;
        }
        return null;
    }

    private ITreeNode getFirstNoneNode(ITreeNode treeNode) {
        if (this.isHidden(treeNode)) {
            return null;
        }
        if (this.isVisible(treeNode) && treeNode.getTOCValue() != null) {
            return treeNode;
        }
        for (ITreeNode childNode : treeNode.getChildren()) {
            ITreeNode firstNode = this.getFirstNoneNode(childNode);
            if (firstNode == null) continue;
            return firstNode;
        }
        return null;
    }

    protected boolean isHidden(ITreeNode node) {
        return this.parent.view.isHidden(node);
    }

    protected boolean isVisible(ITreeNode node) {
        return this.parent.view.isVisible(node);
    }

    class ViewNodeIterator
    implements Iterator<ViewNode> {
        LinkedList<Iterator<ITreeNode>> nodeIters = new LinkedList();
        ViewNode nextNode;

        ViewNodeIterator() {
            this.nodeIters.addLast(ViewNodeList.this.parent.node.getChildren().iterator());
            this.nextNode = this.getNextNode();
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public ViewNode next() {
            if (this.nextNode != null) {
                ViewNode returnNode = this.nextNode;
                this.nextNode = this.getNextNode();
                return returnNode;
            }
            return null;
        }

        ViewNode getNextNode() {
            while (!this.nodeIters.isEmpty()) {
                Iterator<ITreeNode> nodeIter = this.nodeIters.getLast();
                while (nodeIter.hasNext()) {
                    ITreeNode node = nodeIter.next();
                    if (ViewNodeList.this.isHidden(node)) continue;
                    if (!ViewNodeList.this.isVisible(node)) {
                        nodeIter = node.getChildren().iterator();
                        this.nodeIters.addLast(nodeIter);
                        continue;
                    }
                    if (node.isGroup()) {
                        ViewNode group = ViewNodeList.this.createGroupNode(ViewNodeList.this.parent, node);
                        if (group == null) continue;
                        return group;
                    }
                    if (node.getTOCValue() == null) {
                        nodeIter = node.getChildren().iterator();
                        this.nodeIters.addLast(nodeIter);
                        continue;
                    }
                    return new ViewNode(ViewNodeList.this.parent, node);
                }
                this.nodeIters.removeLast();
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

