/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Cruises;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntity;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.model.CruiseDataModel;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.ValidationService;
import fr.ifremer.tutti.service.csv.CaracteristicValueParseException;
import fr.ifremer.tutti.service.csv.CaracteristicValueParserFormatter;
import fr.ifremer.tutti.service.genericformat.GenericFormatArchive;
import fr.ifremer.tutti.service.genericformat.GenericFormatCsvFileResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatFileResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportCruiseContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportEntityParserFactory;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportRequest;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportValidationHelper;
import fr.ifremer.tutti.service.genericformat.GenericFormatReferentialImportResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatReferentialSpeciesImportResult;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForAccidentalCatch;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForAttachment;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForCatch;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForGearCaracteristic;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForIndividualObservation;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForMarineLitter;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForOperation;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForParameter;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForSampleCategory;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForSurvey;
import fr.ifremer.tutti.service.genericformat.csv.AttachmentRow;
import fr.ifremer.tutti.service.genericformat.csv.RowWithCruiseContextSupport;
import fr.ifremer.tutti.service.referential.consumer.CsvConsumerForTemporaryGear;
import fr.ifremer.tutti.service.referential.consumer.CsvConsumerForTemporaryPerson;
import fr.ifremer.tutti.service.referential.consumer.CsvConsumerForTemporarySpecies;
import fr.ifremer.tutti.service.referential.consumer.CsvConsumerForTemporaryVessel;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.nuiton.decorator.Decorator;

public abstract class GenericFormatContextSupport
implements Closeable,
Iterable<GenericFormatImportCruiseContext> {
    private final GenericFormatImportRequest importRequest;
    private final ProgressionModel progressionModel;
    private final Decorator<Cruise> cruiseDecorator;
    private final Decorator<FishingOperation> fishingOperationDecorator;
    private final GenericFormatImportEntityParserFactory importEntityParserFactory;
    private final GenericFormatImportValidationHelper validationHelper;
    private Set<String> archiveLayoutErrors;
    private TuttiProtocol importedProtocol;
    private SampleCategoryModel importedSampleCategoryModel;
    private final GenericFormatCsvFileResult sampleCategoryFileResult;
    private final GenericFormatReferentialImportResult<Gear, Integer> referentialTemporaryGearFileResult;
    private final GenericFormatReferentialImportResult<Person, Integer> referentialTemporaryPersonFileResult;
    private final GenericFormatReferentialSpeciesImportResult referentialTemporarySpeciesFileResult;
    private final GenericFormatReferentialImportResult<Vessel, String> referentialTemporaryVesselFileResult;
    private final GenericFormatFileResult protocolFileResult;
    private final GenericFormatCsvFileResult surveyFileResult;
    private final GenericFormatCsvFileResult accidentalCatchFileResult;
    private final GenericFormatCsvFileResult individualObservationFileResult;
    private final GenericFormatCsvFileResult marineLitterFileResult;
    private final GenericFormatCsvFileResult catchFileResult;
    private final GenericFormatCsvFileResult parameterFileResult;
    private final GenericFormatCsvFileResult operationFileResult;
    private final GenericFormatCsvFileResult gearCaracteristicFileResult;
    private final GenericFormatCsvFileResult attachmentFileResult;
    private final Map<String, GenericFormatImportCruiseContext> cruiseContexts;
    private final Set<String> skippedCruisesNaturalId;
    private String protocolOriginalName;
    private final Multimap<String, AttachmentRow> attachmentRows;

    protected abstract void onClose();

    public GenericFormatContextSupport(GenericFormatImportRequest importRequest, ProgressionModel progressionModel, PersistenceService persistenceService, Decorator<Cruise> cruiseDecorator, Decorator<FishingOperation> fishingOperationDecorator) {
        Preconditions.checkNotNull((Object)importRequest);
        Preconditions.checkNotNull((Object)progressionModel);
        Preconditions.checkNotNull((Object)persistenceService);
        Preconditions.checkNotNull(cruiseDecorator);
        Preconditions.checkNotNull(fishingOperationDecorator);
        this.importRequest = importRequest;
        this.progressionModel = progressionModel;
        this.cruiseDecorator = cruiseDecorator;
        this.fishingOperationDecorator = fishingOperationDecorator;
        this.importEntityParserFactory = new GenericFormatImportEntityParserFactory(persistenceService, this);
        this.validationHelper = new GenericFormatImportValidationHelper(this, new ValidationService());
        this.cruiseContexts = new LinkedHashMap<String, GenericFormatImportCruiseContext>();
        this.skippedCruisesNaturalId = new LinkedHashSet<String>();
        GenericFormatArchive archive = importRequest.getArchive();
        this.sampleCategoryFileResult = this.createFileResult(archive.getSampleCategoryModelPath(), true);
        this.referentialTemporaryGearFileResult = this.createReferentialFileResult(archive.getTemporaryReferentialGearsPath());
        this.referentialTemporaryPersonFileResult = this.createReferentialFileResult(archive.getTemporaryReferentialPersonsPath());
        this.referentialTemporaryVesselFileResult = this.createReferentialFileResult(archive.getTemporaryReferentialVesselsPath());
        File file = archive.getTemporaryReferentialSpeciesPath().toFile();
        this.referentialTemporarySpeciesFileResult = new GenericFormatReferentialSpeciesImportResult(file.getName(), file.exists());
        this.protocolFileResult = this.createFileResult(archive.getProtocolPath(), false);
        this.surveyFileResult = this.createFileResult(archive.getSurveyPath(), true);
        this.gearCaracteristicFileResult = this.createFileResult(archive.getGearCaracteristicsPath(), true);
        this.operationFileResult = this.createFileResult(archive.getOperationPath(), true);
        this.parameterFileResult = this.createFileResult(archive.getParameterPath(), true);
        this.catchFileResult = this.createFileResult(archive.getCatchPath(), true);
        this.marineLitterFileResult = this.createFileResult(archive.getMarineLitterPath(), true);
        this.individualObservationFileResult = this.createFileResult(archive.getIndividualObservationPath(), true);
        this.accidentalCatchFileResult = this.createFileResult(archive.getAccidentalCatchPath(), true);
        this.attachmentFileResult = this.createFileResult(archive.getAttachmentFilePath(), true);
        this.attachmentRows = ArrayListMultimap.create();
    }

    @Override
    public final void close() {
        try {
            this.onClose();
        }
        finally {
            this.validationHelper.close();
            for (GenericFormatImportCruiseContext cruiseContext : this.cruiseContexts.values()) {
                cruiseContext.close();
            }
            this.cruiseContexts.clear();
        }
    }

    @Override
    public Iterator<GenericFormatImportCruiseContext> iterator() {
        return ImmutableSet.copyOf(this.cruiseContexts.values()).iterator();
    }

    public boolean isArchiveLayoutValid() {
        return CollectionUtils.isEmpty(this.archiveLayoutErrors);
    }

    public void setArchiveLayoutErrors(Set<String> archiveLayoutErrors) {
        this.archiveLayoutErrors = archiveLayoutErrors;
    }

    public Set<String> getArchiveLayoutErrors() {
        return ImmutableSet.copyOf(this.archiveLayoutErrors);
    }

    public GenericFormatCsvFileResult getSampleCategoryFileResult() {
        return this.sampleCategoryFileResult;
    }

    public GenericFormatReferentialImportResult<Gear, Integer> getReferentialTemporaryGearFileResult() {
        return this.referentialTemporaryGearFileResult;
    }

    public GenericFormatReferentialImportResult<Person, Integer> getReferentialTemporaryPersonFileResult() {
        return this.referentialTemporaryPersonFileResult;
    }

    public GenericFormatReferentialSpeciesImportResult getReferentialTemporarySpeciesFileResult() {
        return this.referentialTemporarySpeciesFileResult;
    }

    public GenericFormatReferentialImportResult<Vessel, String> getReferentialTemporaryVesselFileResult() {
        return this.referentialTemporaryVesselFileResult;
    }

    public GenericFormatFileResult getProtocolFileResult() {
        return this.protocolFileResult;
    }

    public GenericFormatCsvFileResult getSurveyFileResult() {
        return this.surveyFileResult;
    }

    public GenericFormatCsvFileResult getGearCaracteristicFileResult() {
        return this.gearCaracteristicFileResult;
    }

    public GenericFormatCsvFileResult getOperationFileResult() {
        return this.operationFileResult;
    }

    public GenericFormatCsvFileResult getParameterFileResult() {
        return this.parameterFileResult;
    }

    public GenericFormatCsvFileResult getCatchFileResult() {
        return this.catchFileResult;
    }

    public GenericFormatCsvFileResult getMarineLitterFileResult() {
        return this.marineLitterFileResult;
    }

    public GenericFormatCsvFileResult getIndividualObservationFileResult() {
        return this.individualObservationFileResult;
    }

    public GenericFormatCsvFileResult getAccidentalCatchFileResult() {
        return this.accidentalCatchFileResult;
    }

    public GenericFormatCsvFileResult getAttachmentFileResult() {
        return this.attachmentFileResult;
    }

    public GenericFormatImportRequest getImportRequest() {
        return this.importRequest;
    }

    public TuttiProtocol getImportedProtocol() {
        return this.importedProtocol;
    }

    public void setImportedProtocol(TuttiProtocol importedProtocol) {
        this.importedProtocol = importedProtocol;
    }

    public SampleCategoryModel getImportedSampleCategoryModel() {
        return this.importedSampleCategoryModel;
    }

    public void setImportedSampleCategoryModel(SampleCategoryModel importedSampleCategoryModel) {
        this.importedSampleCategoryModel = importedSampleCategoryModel;
    }

    public boolean isCruiseAlreadyImported(Cruise cruise) {
        GenericFormatImportCruiseContext cruiseContext = this.getCruiseContext(cruise);
        return cruiseContext != null;
    }

    public void addImportedCruise(Cruise cruise, CruiseDataModel selectedCruise, CruiseDataModel existingCruiseData, Set<FishingOperation> existingFishingOperations) {
        String cruiseId = cruise.getId();
        GenericFormatImportCruiseContext cruiseContext = new GenericFormatImportCruiseContext(cruise, selectedCruise, existingCruiseData, existingFishingOperations, this.cruiseDecorator.toString((Object)cruise));
        this.cruiseContexts.put(cruiseId, cruiseContext);
    }

    public void addSkippedCruise(Cruise cruise) {
        String naturalId = Cruises.getNaturalId((Cruise)cruise);
        this.skippedCruisesNaturalId.add(naturalId);
    }

    public void addImportedFishingOperation(FishingOperation fishingOperation, CatchBatch catchBatch) {
        GenericFormatImportCruiseContext cruiseContext = this.getCruiseContext(fishingOperation.getCruise());
        String fishingOperationLabel = this.decorate(fishingOperation);
        cruiseContext.addFishingOperation(fishingOperation, catchBatch, fishingOperationLabel);
    }

    public boolean isCruiseSkipped(RowWithCruiseContextSupport row) {
        Cruise cruise = row.getCruise();
        String naturalId = Cruises.getNaturalId((Cruise)cruise);
        boolean skipped = this.skippedCruisesNaturalId.contains(naturalId);
        return skipped;
    }

    public GenericFormatImportCruiseContext getCruiseContext(RowWithCruiseContextSupport row) {
        Cruise cruise = row.getCruise();
        GenericFormatImportCruiseContext result = null;
        for (GenericFormatImportCruiseContext cruiseContext : this.cruiseContexts.values()) {
            boolean equals = Cruises.equals((Cruise)cruise, (Cruise)cruiseContext.getCruise());
            if (!equals) continue;
            result = cruiseContext;
            break;
        }
        return result;
    }

    public GenericFormatImportCruiseContext getCruiseContext(Cruise cruise) {
        GenericFormatImportCruiseContext cruiseContext = this.cruiseContexts.get(cruise.getId());
        return cruiseContext;
    }

    public CsvConsumerForSampleCategory loadSampleCategories(boolean failFast) {
        this.sampleCategoryFileResult.setImported(true);
        this.surveyFileResult.setLinesCount(this.importRequest.getArchive().getSampleCategoryLineCount());
        CsvConsumerForSampleCategory consumer = new CsvConsumerForSampleCategory(this.importRequest.getArchive().getSampleCategoryModelPath(), this.importRequest.getCsvSeparator(), this.importEntityParserFactory, failFast);
        return consumer;
    }

    public CsvConsumerForSurvey loadSurveys(boolean failFast) {
        this.surveyFileResult.setImported(true);
        this.surveyFileResult.setLinesCount(this.importRequest.getArchive().getSurveyLineCount());
        CsvConsumerForSurvey consumer = new CsvConsumerForSurvey(this.importRequest.getArchive().getSurveyPath(), this.importRequest.getCsvSeparator(), this.importEntityParserFactory, failFast);
        return consumer;
    }

    public CsvConsumerForGearCaracteristic loadGearCaracteristics(boolean failFast) {
        this.gearCaracteristicFileResult.setImported(true);
        this.gearCaracteristicFileResult.setLinesCount(this.importRequest.getArchive().getGearCaracteristicsPathLineCount());
        CsvConsumerForGearCaracteristic consumer = new CsvConsumerForGearCaracteristic(this.importRequest.getArchive().getGearCaracteristicsPath(), this.importRequest.getCsvSeparator(), this.importEntityParserFactory, failFast);
        return consumer;
    }

    public CsvConsumerForOperation loadOperations(boolean failFast) {
        this.operationFileResult.setImported(true);
        this.operationFileResult.setLinesCount(this.importRequest.getArchive().getOperationPathLineCount());
        CsvConsumerForOperation consumer = new CsvConsumerForOperation(this.importRequest.getArchive().getOperationPath(), this.importRequest.getCsvSeparator(), this.importEntityParserFactory, failFast);
        return consumer;
    }

    public CsvConsumerForParameter loadParameters(boolean failFast) {
        this.parameterFileResult.setImported(true);
        this.parameterFileResult.setLinesCount(this.importRequest.getArchive().getParameterPathLineCount());
        CsvConsumerForParameter consumer = new CsvConsumerForParameter(this.importRequest.getArchive().getParameterPath(), this.importRequest.getCsvSeparator(), this.importEntityParserFactory, failFast);
        return consumer;
    }

    public CsvConsumerForCatch loadCatches(boolean failFast) {
        this.catchFileResult.setImported(true);
        this.catchFileResult.setLinesCount(this.importRequest.getArchive().getCatchPathLineCount());
        CsvConsumerForCatch consumer = new CsvConsumerForCatch(this.importRequest.getArchive().getCatchPath(), this.importRequest.getCsvSeparator(), this.getImportedSampleCategoryModel(), this.importEntityParserFactory, failFast);
        return consumer;
    }

    public CsvConsumerForMarineLitter loadMarineLitters(boolean failFast) {
        this.marineLitterFileResult.setImported(true);
        this.marineLitterFileResult.setLinesCount(this.importRequest.getArchive().getMarineLitterPathLineCount());
        CsvConsumerForMarineLitter consumer = new CsvConsumerForMarineLitter(this.importRequest.getArchive().getMarineLitterPath(), this.importRequest.getCsvSeparator(), this.importEntityParserFactory, failFast);
        return consumer;
    }

    public CsvConsumerForIndividualObservation loadIndividualObservations(boolean failFast) {
        this.individualObservationFileResult.setImported(true);
        this.individualObservationFileResult.setLinesCount(this.importRequest.getArchive().getIndividualObservationPathLineCount());
        CsvConsumerForIndividualObservation consumer = new CsvConsumerForIndividualObservation(this.importRequest.getArchive().getIndividualObservationPath(), this.importRequest.getCsvSeparator(), this.importEntityParserFactory, failFast);
        return consumer;
    }

    public CsvConsumerForAccidentalCatch loadAccidentalCatches(boolean failFast) {
        this.accidentalCatchFileResult.setImported(true);
        this.accidentalCatchFileResult.setLinesCount(this.importRequest.getArchive().getAccidentalCatchPathLineCount());
        CsvConsumerForAccidentalCatch consumer = new CsvConsumerForAccidentalCatch(this.importRequest.getArchive().getAccidentalCatchPath(), this.importRequest.getCsvSeparator(), this.importEntityParserFactory, failFast);
        return consumer;
    }

    public CsvConsumerForAttachment loadAttachments(boolean failFast) {
        this.attachmentFileResult.setImported(true);
        this.attachmentFileResult.setLinesCount(this.importRequest.getArchive().getAttachemntsPathLineCount());
        CsvConsumerForAttachment consumer = new CsvConsumerForAttachment(this.importRequest.getArchive().getAttachmentFilePath(), this.importRequest.getCsvSeparator(), this.importEntityParserFactory, failFast);
        return consumer;
    }

    public CsvConsumerForTemporaryGear loadTemporaryGears(boolean failFast) {
        this.referentialTemporaryGearFileResult.setImported(true);
        this.referentialTemporaryGearFileResult.setLinesCount(this.importRequest.getArchive().getTemporaryReferentialGearLineCount());
        CsvConsumerForTemporaryGear consumer = new CsvConsumerForTemporaryGear(this.importRequest.getArchive().getTemporaryReferentialGearsPath(), this.importRequest.getCsvSeparator(), failFast);
        return consumer;
    }

    public CsvConsumerForTemporaryPerson loadTemporaryPersons(boolean failFast) {
        this.referentialTemporaryPersonFileResult.setImported(true);
        this.referentialTemporaryPersonFileResult.setLinesCount(this.importRequest.getArchive().getTemporaryReferentialPersonLineCount());
        CsvConsumerForTemporaryPerson consumer = new CsvConsumerForTemporaryPerson(this.importRequest.getArchive().getTemporaryReferentialPersonsPath(), this.importRequest.getCsvSeparator(), failFast);
        return consumer;
    }

    public CsvConsumerForTemporarySpecies loadTemporarySpecies(boolean failFast) {
        this.referentialTemporarySpeciesFileResult.setImported(true);
        this.referentialTemporarySpeciesFileResult.setLinesCount(this.importRequest.getArchive().getTemporaryReferentialSpeciesLineCount());
        CsvConsumerForTemporarySpecies consumer = new CsvConsumerForTemporarySpecies(this.importRequest.getArchive().getTemporaryReferentialSpeciesPath(), this.importRequest.getCsvSeparator(), true, failFast);
        return consumer;
    }

    public CsvConsumerForTemporaryVessel loadTemporaryVessels(boolean failFast) {
        this.referentialTemporaryVesselFileResult.setImported(true);
        this.referentialTemporaryVesselFileResult.setLinesCount(this.importRequest.getArchive().getTemporaryReferentialVesselLineCount());
        CsvConsumerForTemporaryVessel consumer = new CsvConsumerForTemporaryVessel(this.importRequest.getArchive().getTemporaryReferentialVesselsPath(), this.importRequest.getCsvSeparator(), failFast);
        return consumer;
    }

    public Serializable parseCaracteristicValue(Caracteristic caracteristic, String value) throws CaracteristicValueParseException {
        CaracteristicValueParserFormatter parser = CaracteristicValueParserFormatter.newParser(caracteristic);
        try {
            Serializable caracteristicValue = parser.parse(value);
            return caracteristicValue;
        }
        catch (ParseException e) {
            throw new CaracteristicValueParseException(caracteristic, value, e.getMessage());
        }
    }

    public void increments(String message) {
        this.progressionModel.increments(message);
    }

    public GenericFormatImportValidationHelper getValidationHelper() {
        return this.validationHelper;
    }

    public void doActionOnCruiseContexts(CruiseContextAction action) {
        for (GenericFormatImportCruiseContext cruiseContext : this.cruiseContexts.values()) {
            action.onCruise(cruiseContext, this.progressionModel);
        }
    }

    public Iterable<GenericFormatImportCruiseContext> orderedCruiseContexts() {
        List orderedCruiseContexts = Ordering.from((Comparator)Cruises.CRUISE_COMPARATOR).onResultOf((Function)new Function<GenericFormatImportCruiseContext, Cruise>(){

            public Cruise apply(GenericFormatImportCruiseContext input) {
                return input.getCruise();
            }
        }).sortedCopy(this.cruiseContexts.values());
        return orderedCruiseContexts;
    }

    public void doActionOnSortedCruiseContexts(CruiseContextAction action) {
        for (GenericFormatImportCruiseContext cruiseContext : this.orderedCruiseContexts()) {
            action.onCruise(cruiseContext, this.progressionModel);
        }
    }

    public boolean isTechnicalFilesValid() {
        return this.isArchiveLayoutValid() && this.sampleCategoryFileResult.isValid() && this.referentialTemporaryGearFileResult.isValid() && this.referentialTemporaryPersonFileResult.isValid() && this.referentialTemporarySpeciesFileResult.isValid() && this.referentialTemporaryVesselFileResult.isValid() && this.protocolFileResult.isValid();
    }

    public String getProtocolOriginalName() {
        return this.protocolOriginalName;
    }

    public void setProtocolOriginalName(String protocolOriginalName) {
        this.protocolOriginalName = protocolOriginalName;
    }

    public void setAttachmentRows(Multimap<String, AttachmentRow> attachmentRows) {
        this.attachmentRows.putAll(attachmentRows);
    }

    public Collection<AttachmentRow> popAttachmentRows(ObjectTypeCode objectTypeCode, Integer objectId) {
        Collection result = objectId == null ? null : this.attachmentRows.removeAll((Object)(objectTypeCode + "_" + objectId));
        return result;
    }

    protected GenericFormatCsvFileResult createFileResult(Path path, boolean mandatory) {
        File file = path.toFile();
        return new GenericFormatCsvFileResult(file.getName(), mandatory, file.exists());
    }

    protected <E extends TuttiReferentialEntity, K extends Comparable<K>> GenericFormatReferentialImportResult<E, K> createReferentialFileResult(Path path) {
        File file = path.toFile();
        return new GenericFormatReferentialImportResult(file.getName(), file.exists());
    }

    public String decorate(Cruise cruise) {
        return this.cruiseDecorator.toString((Object)cruise);
    }

    public String decorate(FishingOperation fishingOperation) {
        return this.fishingOperationDecorator.toString((Object)fishingOperation);
    }

    public static interface CruiseContextAction {
        public void onCruise(GenericFormatImportCruiseContext var1, ProgressionModel var2);
    }
}

