/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.csv;

import fr.ifremer.tutti.service.csv.AbstractTuttiImportExportModel;
import fr.ifremer.tutti.service.csv.TuttiCsvUtil;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportEntityParserFactory;
import fr.ifremer.tutti.service.genericformat.csv.ParameterRow;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueParser;

public class ParameterModel
extends AbstractTuttiImportExportModel<ParameterRow> {
    public static ParameterModel forExport(char separator) {
        ParameterModel exportModel = new ParameterModel(separator);
        exportModel.forExport();
        return exportModel;
    }

    public static ParameterModel forImport(char separator, GenericFormatImportEntityParserFactory parserFactory) {
        ParameterModel importModel = new ParameterModel(separator);
        importModel.forImport(parserFactory);
        return importModel;
    }

    public ParameterRow newEmptyInstance() {
        ParameterRow row = ParameterRow.newEmptyInstance();
        return row;
    }

    protected ParameterModel(char separator) {
        super(separator);
    }

    protected void forExport() {
        this.newColumnForExport("Annee", "beginDate", (ValueFormatter)TuttiCsvUtil.YEAR);
        this.newColumnForExport("Serie", "program", TuttiCsvUtil.PROGRAM_FORMATTER);
        this.newColumnForExport("Serie_Partielle", "surveyPart");
        this.newColumnForExport("Code_Station", "stationNumber");
        this.newColumnForExport("Id_Operation", "fishingOperationNumber", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Poche", "multirigAggregation");
        this.newColumnForExport("Code_PMFM", "caracteristic", TuttiCsvUtil.CARACTERISTIC_TECHNICAL_FORMATTER);
        this.newColumnForExport("Libelle_PMFM", "caracteristic", TuttiCsvUtil.CARACTERISTIC_FORMATTER);
        this.newColumnForExport("Valeur", "value", TuttiCsvUtil.CARACTERISTIC_VALUE_FORMATTER);
        this.newColumnForExport("Type", "parameterType", (ValueFormatter)TuttiCsvUtil.newEnumByNameParserFormatter(ParameterRow.ParameterType.class));
        this.newColumnForExport("Serie_Id", "program", TuttiCsvUtil.PROGRAM_TECHNICAL_FORMATTER);
        this.newColumnForExport("Valeur_Id", "value", TuttiCsvUtil.CARACTERISTIC_VALUE_TECHNICAL_FORMATTER);
    }

    protected void forImport(GenericFormatImportEntityParserFactory parserFactory) {
        this.newMandatoryColumn("Annee", "beginDate", (ValueParser)TuttiCsvUtil.YEAR);
        this.newIgnoredColumn("Serie");
        this.newMandatoryColumn("Serie_Partielle", "surveyPart");
        this.newMandatoryColumn("Code_Station", "stationNumber");
        this.newMandatoryColumn("Id_Operation", "fishingOperationNumber", (ValueParser)TuttiCsvUtil.INTEGER);
        this.newMandatoryColumn("Poche", "multirigAggregation");
        this.newMandatoryColumn("Code_PMFM", "caracteristic", (ValueParser)parserFactory.getCaracteristicParser());
        this.newIgnoredColumn("Libelle_PMFM");
        this.newIgnoredColumn("Valeur");
        this.newMandatoryColumn("Type", "parameterType", (ValueParser)TuttiCsvUtil.newEnumByNameParserFormatter(ParameterRow.ParameterType.class));
        this.newMandatoryColumn("Serie_Id", "program", (ValueParser)parserFactory.getProgramParser());
        this.newMandatoryColumn("Valeur_Id", "value");
    }
}

