// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.survey.declaration;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.data.measure.SurveyMeasurement;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.survey.sale.Sale;
import fr.ifremer.adagio.core.dao.data.vessel.Vessel;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * Référence du document déclaratif. Utile pour les données issu du log book électronique (flux
 * SACAPT.)
 */
// HibernateEntity.vsl annotations merge-point
public abstract class DeclaredDocumentReference
    implements Serializable, Comparable<DeclaredDocumentReference>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 5210228746324241042L;

    // Generate 17 attributes
    private Integer id;

    /**
     * Identifiant interne de la référence de document déclaratif. Généré par le système.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Identifiant interne de la référence de document déclaratif. Généré par le système.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private String synchronizationStatus;

    /**
     * Etat de synchronisation (en cours, terminé, en attente de synchro, supprimé). Seulement
     * visible dans la base locale.
     * @return this.synchronizationStatus String
     */
    public String getSynchronizationStatus()
    {
        return this.synchronizationStatus;
    }

    /**
     * Etat de synchronisation (en cours, terminé, en attente de synchro, supprimé). Seulement
     * visible dans la base locale.
     * @param synchronizationStatusIn String
     */
    public void setSynchronizationStatus(String synchronizationStatusIn)
    {
        this.synchronizationStatus = synchronizationStatusIn;
    }

    private String reference;

    /**
     * Numéro de la fiche de peche.
     * issu du flux SACAPT.
     * Cela sert à regrouper les marées par fiche de peche.
     * @return this.reference String
     */
    public String getReference()
    {
        return this.reference;
    }

    /**
     * Numéro de la fiche de peche.
     * issu du flux SACAPT.
     * Cela sert à regrouper les marées par fiche de peche.
     * @param referenceIn String
     */
    public void setReference(String referenceIn)
    {
        this.reference = referenceIn;
    }

    private String fileName;

    /**
     * Nom du fichier ayant servi à importer les données déclarées dans la base.
     * ex : Nom du fichier d'origine de la vente = BL_070212_1215.ric
     * @return this.fileName String
     */
    public String getFileName()
    {
        return this.fileName;
    }

    /**
     * Nom du fichier ayant servi à importer les données déclarées dans la base.
     * ex : Nom du fichier d'origine de la vente = BL_070212_1215.ric
     * @param fileNameIn String
     */
    public void setFileName(String fileNameIn)
    {
        this.fileName = fileNameIn;
    }

    private Date documentDate;

    /**
     * 
     * @return this.documentDate Date
     */
    public Date getDocumentDate()
    {
        return this.documentDate;
    }

    /**
     * 
     * @param documentDateIn Date
     */
    public void setDocumentDate(Date documentDateIn)
    {
        this.documentDate = documentDateIn;
    }

    private String otherDocumentReference;

    /**
     * Autre référence sur le document déclaratif.
     * Utilisé dans SACROIS/RIC2 : Ce code permet de transmettre dans le fichier RIC2 l’information
     * renseignée sur la note de vente dans la case « Document joint à la note de vente (le cas
     * échéant) » :
     * T2M/Déclaration de débarquement, document de transport, déclaration de prise en
     * charge. Ce code permet de préciser, lorsqu’aucun document n’est joint à la note de vente, si
     * ce défaut de document joint est ou non une anomalie du point de vue de la
     * réglementation.
     * Exemple :
     * - 0 : aucun document joint à la note de vente – sans objet
     * - 1 : aucun document joint à la note de vente – anomalie réglementaire
     * - 2 : T2M / déclaration de débarquement
     * - 3 : Document de transport
     * - 4 : Déclaration de prise en charge
     * @return this.otherDocumentReference String
     */
    public String getOtherDocumentReference()
    {
        return this.otherDocumentReference;
    }

    /**
     * Autre référence sur le document déclaratif.
     * Utilisé dans SACROIS/RIC2 : Ce code permet de transmettre dans le fichier RIC2 l’information
     * renseignée sur la note de vente dans la case « Document joint à la note de vente (le cas
     * échéant) » :
     * T2M/Déclaration de débarquement, document de transport, déclaration de prise en
     * charge. Ce code permet de préciser, lorsqu’aucun document n’est joint à la note de vente, si
     * ce défaut de document joint est ou non une anomalie du point de vue de la
     * réglementation.
     * Exemple :
     * - 0 : aucun document joint à la note de vente – sans objet
     * - 1 : aucun document joint à la note de vente – anomalie réglementaire
     * - 2 : T2M / déclaration de débarquement
     * - 3 : Document de transport
     * - 4 : Déclaration de prise en charge
     * @param otherDocumentReferenceIn String
     */
    public void setOtherDocumentReference(String otherDocumentReferenceIn)
    {
        this.otherDocumentReference = otherDocumentReferenceIn;
    }

    private String firstSheetNumber;

    /**
     * Numéro du premier feuillet de la déclaration. Utilisé dans SACROIS/SIPA.
     * Il peut s'agir d'un code alphanumérique (référence du feuillet).
     * @return this.firstSheetNumber String
     */
    public String getFirstSheetNumber()
    {
        return this.firstSheetNumber;
    }

    /**
     * Numéro du premier feuillet de la déclaration. Utilisé dans SACROIS/SIPA.
     * Il peut s'agir d'un code alphanumérique (référence du feuillet).
     * @param firstSheetNumberIn String
     */
    public void setFirstSheetNumber(String firstSheetNumberIn)
    {
        this.firstSheetNumber = firstSheetNumberIn;
    }

    private String lastSheetNumber;

    /**
     * Numéro du dernier feuillet de la déclaration. Utilisé dans SACROIS/SIPA.
     * Il peut s'agir d'un code alphanumérique (référence du feuillet).
     * @return this.lastSheetNumber String
     */
    public String getLastSheetNumber()
    {
        return this.lastSheetNumber;
    }

    /**
     * Numéro du dernier feuillet de la déclaration. Utilisé dans SACROIS/SIPA.
     * Il peut s'agir d'un code alphanumérique (référence du feuillet).
     * @param lastSheetNumberIn String
     */
    public void setLastSheetNumber(String lastSheetNumberIn)
    {
        this.lastSheetNumber = lastSheetNumberIn;
    }

    private Short sheetCount;

    /**
     * Nombre de feuillets dans la déclaration. Utilisé dans SACROIS/SIPA
     * @return this.sheetCount Short
     */
    public Short getSheetCount()
    {
        return this.sheetCount;
    }

    /**
     * Nombre de feuillets dans la déclaration. Utilisé dans SACROIS/SIPA
     * @param sheetCountIn Short
     */
    public void setSheetCount(Short sheetCountIn)
    {
        this.sheetCount = sheetCountIn;
    }

    private String comments;

    /**
     * Commentaire.
     * @return this.comments String
     */
    public String getComments()
    {
        return this.comments;
    }

    /**
     * Commentaire.
     * @param commentsIn String
     */
    public void setComments(String commentsIn)
    {
        this.comments = commentsIn;
    }

    private Date creationDate;

    /**
     * Date de création de l'enquete dans le système central.
     * @return this.creationDate Date
     */
    public Date getCreationDate()
    {
        return this.creationDate;
    }

    /**
     * Date de création de l'enquete dans le système central.
     * @param creationDateIn Date
     */
    public void setCreationDate(Date creationDateIn)
    {
        this.creationDate = creationDateIn;
    }

    private Date controlDate;

    /**
     * 
     * @return this.controlDate Date
     */
    public Date getControlDate()
    {
        return this.controlDate;
    }

    /**
     * 
     * @param controlDateIn Date
     */
    public void setControlDate(Date controlDateIn)
    {
        this.controlDate = controlDateIn;
    }

    private Date validationDate;

    /**
     * 
     * @return this.validationDate Date
     */
    public Date getValidationDate()
    {
        return this.validationDate;
    }

    /**
     * 
     * @param validationDateIn Date
     */
    public void setValidationDate(Date validationDateIn)
    {
        this.validationDate = validationDateIn;
    }

    private Date qualificationDate;

    /**
     * 
     * @return this.qualificationDate Date
     */
    public Date getQualificationDate()
    {
        return this.qualificationDate;
    }

    /**
     * 
     * @param qualificationDateIn Date
     */
    public void setQualificationDate(Date qualificationDateIn)
    {
        this.qualificationDate = qualificationDateIn;
    }

    private String qualificationComments;

    /**
     * 
     * @return this.qualificationComments String
     */
    public String getQualificationComments()
    {
        return this.qualificationComments;
    }

    /**
     * 
     * @param qualificationCommentsIn String
     */
    public void setQualificationComments(String qualificationCommentsIn)
    {
        this.qualificationComments = qualificationCommentsIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    private Integer remoteId;

    /**
     * 
     * @return this.remoteId Integer
     */
    public Integer getRemoteId()
    {
        return this.remoteId;
    }

    /**
     * 
     * @param remoteIdIn Integer
     */
    public void setRemoteId(Integer remoteIdIn)
    {
        this.remoteId = remoteIdIn;
    }

    // Generate 11 associations
    private DeclaredDocumentReference parentDeclaredDocumentReference;

    /**
     * Référence du document déclaratif parent.
     * Utile dans SACAPT.
     * Cela sert à regrouper les marées par fiche de peche.
     * @return this.parentDeclaredDocumentReference DeclaredDocumentReference
     */
    public DeclaredDocumentReference getParentDeclaredDocumentReference()
    {
        return this.parentDeclaredDocumentReference;
    }

    /**
     * Référence du document déclaratif parent.
     * Utile dans SACAPT.
     * Cela sert à regrouper les marées par fiche de peche.
     * @param parentDeclaredDocumentReferenceIn DeclaredDocumentReference
     */
    public void setParentDeclaredDocumentReference(DeclaredDocumentReference parentDeclaredDocumentReferenceIn)
    {
        this.parentDeclaredDocumentReference = parentDeclaredDocumentReferenceIn;
    }

    private Collection<DeclaredDocumentReference> childDeclaredDocumentReferences = new HashSet<DeclaredDocumentReference>();

    /**
     * Référence du document déclaratif. Utile pour les données issu du log book électronique (flux
     * SACAPT.)
     * @return this.childDeclaredDocumentReferences Collection<DeclaredDocumentReference>
     */
    public Collection<DeclaredDocumentReference> getChildDeclaredDocumentReferences()
    {
        return this.childDeclaredDocumentReferences;
    }

    /**
     * Référence du document déclaratif. Utile pour les données issu du log book électronique (flux
     * SACAPT.)
     * @param childDeclaredDocumentReferencesIn Collection<DeclaredDocumentReference>
     */
    public void setChildDeclaredDocumentReferences(Collection<DeclaredDocumentReference> childDeclaredDocumentReferencesIn)
    {
        this.childDeclaredDocumentReferences = childDeclaredDocumentReferencesIn;
    }

    /**
     * Référence du document déclaratif. Utile pour les données issu du log book électronique (flux
     * SACAPT.)
     * @param elementToAdd DeclaredDocumentReference
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addChildDeclaredDocumentReferences(DeclaredDocumentReference elementToAdd)
    {
        return this.childDeclaredDocumentReferences.add(elementToAdd);
    }

    /**
     * Référence du document déclaratif. Utile pour les données issu du log book électronique (flux
     * SACAPT.)
     * @param elementToRemove DeclaredDocumentReference
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeChildDeclaredDocumentReferences(DeclaredDocumentReference elementToRemove)
    {
        return this.childDeclaredDocumentReferences.remove(elementToRemove);
    }

    private Collection<Sale> sales = new HashSet<Sale>();

    /**
     * Ventes déclarées
     * @return this.sales Collection<Sale>
     */
    public Collection<Sale> getSales()
    {
        return this.sales;
    }

    /**
     * Ventes déclarées
     * @param salesIn Collection<Sale>
     */
    public void setSales(Collection<Sale> salesIn)
    {
        this.sales = salesIn;
    }

    /**
     * Ventes déclarées
     * @param elementToAdd Sale
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addSales(Sale elementToAdd)
    {
        return this.sales.add(elementToAdd);
    }

    /**
     * Ventes déclarées
     * @param elementToRemove Sale
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeSales(Sale elementToRemove)
    {
        return this.sales.remove(elementToRemove);
    }

    private Department recorderDepartment;

    /**
     * Service saisisseur
     * @return this.recorderDepartment Department
     */
    public Department getRecorderDepartment()
    {
        return this.recorderDepartment;
    }

    /**
     * Service saisisseur
     * @param recorderDepartmentIn Department
     */
    public void setRecorderDepartment(Department recorderDepartmentIn)
    {
        this.recorderDepartment = recorderDepartmentIn;
    }

    private Person recorderPerson;

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @return this.recorderPerson Person
     */
    public Person getRecorderPerson()
    {
        return this.recorderPerson;
    }

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @param recorderPersonIn Person
     */
    public void setRecorderPerson(Person recorderPersonIn)
    {
        this.recorderPerson = recorderPersonIn;
    }

    private Collection<FishingTrip> fishingTrips = new HashSet<FishingTrip>();

    /**
     * Voyage en mer, ayant pour vocation une activité de peche (peut etre une campagnes halieutique
     * ou une
     * marée d'un navire professionnel, etc.)
     * Un voyage peut représenter type de données :
     * - Une marée observée (en mer, au débarquement), qui désigne une marée de pêche
     * professionnelle au
     * cours de laquelle des relevés sont effectués par un observateur.
     * - Une marée déclarée. Principalement issue du log book électronique (flux SACAPT). Une marée
     * déclarée peut etre un ensemble de marée ou de sous-ensembles de marée (Exemple de la fiche de
     * peche)
     * - une sortie effectuée lors d"une campagne scientifique
     * @return this.fishingTrips Collection<FishingTrip>
     */
    public Collection<FishingTrip> getFishingTrips()
    {
        return this.fishingTrips;
    }

    /**
     * Voyage en mer, ayant pour vocation une activité de peche (peut etre une campagnes halieutique
     * ou une
     * marée d'un navire professionnel, etc.)
     * Un voyage peut représenter type de données :
     * - Une marée observée (en mer, au débarquement), qui désigne une marée de pêche
     * professionnelle au
     * cours de laquelle des relevés sont effectués par un observateur.
     * - Une marée déclarée. Principalement issue du log book électronique (flux SACAPT). Une marée
     * déclarée peut etre un ensemble de marée ou de sous-ensembles de marée (Exemple de la fiche de
     * peche)
     * - une sortie effectuée lors d"une campagne scientifique
     * @param fishingTripsIn Collection<FishingTrip>
     */
    public void setFishingTrips(Collection<FishingTrip> fishingTripsIn)
    {
        this.fishingTrips = fishingTripsIn;
    }

    /**
     * Voyage en mer, ayant pour vocation une activité de peche (peut etre une campagnes halieutique
     * ou une
     * marée d'un navire professionnel, etc.)
     * Un voyage peut représenter type de données :
     * - Une marée observée (en mer, au débarquement), qui désigne une marée de pêche
     * professionnelle au
     * cours de laquelle des relevés sont effectués par un observateur.
     * - Une marée déclarée. Principalement issue du log book électronique (flux SACAPT). Une marée
     * déclarée peut etre un ensemble de marée ou de sous-ensembles de marée (Exemple de la fiche de
     * peche)
     * - une sortie effectuée lors d"une campagne scientifique
     * @param elementToAdd FishingTrip
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addFishingTrips(FishingTrip elementToAdd)
    {
        return this.fishingTrips.add(elementToAdd);
    }

    /**
     * Voyage en mer, ayant pour vocation une activité de peche (peut etre une campagnes halieutique
     * ou une
     * marée d'un navire professionnel, etc.)
     * Un voyage peut représenter type de données :
     * - Une marée observée (en mer, au débarquement), qui désigne une marée de pêche
     * professionnelle au
     * cours de laquelle des relevés sont effectués par un observateur.
     * - Une marée déclarée. Principalement issue du log book électronique (flux SACAPT). Une marée
     * déclarée peut etre un ensemble de marée ou de sous-ensembles de marée (Exemple de la fiche de
     * peche)
     * - une sortie effectuée lors d"une campagne scientifique
     * @param elementToRemove FishingTrip
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeFishingTrips(FishingTrip elementToRemove)
    {
        return this.fishingTrips.remove(elementToRemove);
    }

    private Program program;

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @return this.program Program
     */
    public Program getProgram()
    {
        return this.program;
    }

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @param programIn Program
     */
    public void setProgram(Program programIn)
    {
        this.program = programIn;
    }

    private Vessel vessel;

    /**
     * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
     * @return this.vessel Vessel
     */
    public Vessel getVessel()
    {
        return this.vessel;
    }

    /**
     * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
     * @param vesselIn Vessel
     */
    public void setVessel(Vessel vesselIn)
    {
        this.vessel = vesselIn;
    }

    private QualityFlag qualityFlag;

    /**
     * Niveau de qualité de la donnée.
     * "Non qualifiée" par défaut
     * @return this.qualityFlag QualityFlag
     */
    public QualityFlag getQualityFlag()
    {
        return this.qualityFlag;
    }

    /**
     * Niveau de qualité de la donnée.
     * "Non qualifiée" par défaut
     * @param qualityFlagIn QualityFlag
     */
    public void setQualityFlag(QualityFlag qualityFlagIn)
    {
        this.qualityFlag = qualityFlagIn;
    }

    private Collection<SurveyMeasurement> surveyMeasurements = new HashSet<SurveyMeasurement>();

    /**
     * Caractéristiques additionnelles du document déclaratif.
     * Par exemple : Type de document (PSFM+valeurs qualitatives), etc.
     * @return this.surveyMeasurements Collection<SurveyMeasurement>
     */
    public Collection<SurveyMeasurement> getSurveyMeasurements()
    {
        return this.surveyMeasurements;
    }

    /**
     * Caractéristiques additionnelles du document déclaratif.
     * Par exemple : Type de document (PSFM+valeurs qualitatives), etc.
     * @param surveyMeasurementsIn Collection<SurveyMeasurement>
     */
    public void setSurveyMeasurements(Collection<SurveyMeasurement> surveyMeasurementsIn)
    {
        this.surveyMeasurements = surveyMeasurementsIn;
    }

    /**
     * Caractéristiques additionnelles du document déclaratif.
     * Par exemple : Type de document (PSFM+valeurs qualitatives), etc.
     * @param elementToAdd SurveyMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addSurveyMeasurements(SurveyMeasurement elementToAdd)
    {
        return this.surveyMeasurements.add(elementToAdd);
    }

    /**
     * Caractéristiques additionnelles du document déclaratif.
     * Par exemple : Type de document (PSFM+valeurs qualitatives), etc.
     * @param elementToRemove SurveyMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeSurveyMeasurements(SurveyMeasurement elementToRemove)
    {
        return this.surveyMeasurements.remove(elementToRemove);
    }

    /**
     * Returns <code>true</code> if the argument is an DeclaredDocumentReference instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof DeclaredDocumentReference))
        {
            return false;
        }
        final DeclaredDocumentReference that = (DeclaredDocumentReference)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link DeclaredDocumentReference}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link DeclaredDocumentReference}.
         * @return new DeclaredDocumentReferenceImpl()
         */
        public static DeclaredDocumentReference newInstance()
        {
            return new DeclaredDocumentReferenceImpl();
        }

        /**
         * Constructs a new instance of {@link DeclaredDocumentReference}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param synchronizationStatus String
         * @param documentDate Date
         * @param creationDate Date
         * @param recorderDepartment Department
         * @param program Program
         * @param vessel Vessel
         * @param qualityFlag QualityFlag
         * @return newInstance
         */
        public static DeclaredDocumentReference newInstance(String synchronizationStatus, Date documentDate, Date creationDate, Department recorderDepartment, Program program, Vessel vessel, QualityFlag qualityFlag)
        {
            final DeclaredDocumentReference entity = new DeclaredDocumentReferenceImpl();
            entity.setSynchronizationStatus(synchronizationStatus);
            entity.setDocumentDate(documentDate);
            entity.setCreationDate(creationDate);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setProgram(program);
            entity.setVessel(vessel);
            entity.setQualityFlag(qualityFlag);
            return entity;
        }

        /**
         * Constructs a new instance of {@link DeclaredDocumentReference}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param synchronizationStatus String
         * @param reference String
         * @param fileName String
         * @param documentDate Date
         * @param otherDocumentReference String
         * @param firstSheetNumber String
         * @param lastSheetNumber String
         * @param sheetCount Short
         * @param comments String
         * @param creationDate Date
         * @param controlDate Date
         * @param validationDate Date
         * @param qualificationDate Date
         * @param qualificationComments String
         * @param updateDate Timestamp
         * @param remoteId Integer
         * @param parentDeclaredDocumentReference DeclaredDocumentReference
         * @param childDeclaredDocumentReferences Collection<DeclaredDocumentReference>
         * @param sales Collection<Sale>
         * @param recorderDepartment Department
         * @param recorderPerson Person
         * @param fishingTrips Collection<FishingTrip>
         * @param program Program
         * @param vessel Vessel
         * @param qualityFlag QualityFlag
         * @param surveyMeasurements Collection<SurveyMeasurement>
         * @return newInstance DeclaredDocumentReference
         */
        public static DeclaredDocumentReference newInstance(String synchronizationStatus, String reference, String fileName, Date documentDate, String otherDocumentReference, String firstSheetNumber, String lastSheetNumber, Short sheetCount, String comments, Date creationDate, Date controlDate, Date validationDate, Date qualificationDate, String qualificationComments, Timestamp updateDate, Integer remoteId, DeclaredDocumentReference parentDeclaredDocumentReference, Collection<DeclaredDocumentReference> childDeclaredDocumentReferences, Collection<Sale> sales, Department recorderDepartment, Person recorderPerson, Collection<FishingTrip> fishingTrips, Program program, Vessel vessel, QualityFlag qualityFlag, Collection<SurveyMeasurement> surveyMeasurements)
        {
            final DeclaredDocumentReference entity = new DeclaredDocumentReferenceImpl();
            entity.setSynchronizationStatus(synchronizationStatus);
            entity.setReference(reference);
            entity.setFileName(fileName);
            entity.setDocumentDate(documentDate);
            entity.setOtherDocumentReference(otherDocumentReference);
            entity.setFirstSheetNumber(firstSheetNumber);
            entity.setLastSheetNumber(lastSheetNumber);
            entity.setSheetCount(sheetCount);
            entity.setComments(comments);
            entity.setCreationDate(creationDate);
            entity.setControlDate(controlDate);
            entity.setValidationDate(validationDate);
            entity.setQualificationDate(qualificationDate);
            entity.setQualificationComments(qualificationComments);
            entity.setUpdateDate(updateDate);
            entity.setRemoteId(remoteId);
            entity.setParentDeclaredDocumentReference(parentDeclaredDocumentReference);
            entity.setChildDeclaredDocumentReferences(childDeclaredDocumentReferences);
            entity.setSales(sales);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setRecorderPerson(recorderPerson);
            entity.setFishingTrips(fishingTrips);
            entity.setProgram(program);
            entity.setVessel(vessel);
            entity.setQualityFlag(qualityFlag);
            entity.setSurveyMeasurements(surveyMeasurements);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(DeclaredDocumentReference o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getSynchronizationStatus() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getSynchronizationStatus().compareTo(o.getSynchronizationStatus()));
            }
            if (this.getReference() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getReference().compareTo(o.getReference()));
            }
            if (this.getFileName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getFileName().compareTo(o.getFileName()));
            }
            if (this.getDocumentDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getDocumentDate().compareTo(o.getDocumentDate()));
            }
            if (this.getOtherDocumentReference() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getOtherDocumentReference().compareTo(o.getOtherDocumentReference()));
            }
            if (this.getFirstSheetNumber() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getFirstSheetNumber().compareTo(o.getFirstSheetNumber()));
            }
            if (this.getLastSheetNumber() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getLastSheetNumber().compareTo(o.getLastSheetNumber()));
            }
            if (this.getSheetCount() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getSheetCount().compareTo(o.getSheetCount()));
            }
            if (this.getComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getComments().compareTo(o.getComments()));
            }
            if (this.getCreationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getCreationDate().compareTo(o.getCreationDate()));
            }
            if (this.getControlDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getControlDate().compareTo(o.getControlDate()));
            }
            if (this.getValidationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getValidationDate().compareTo(o.getValidationDate()));
            }
            if (this.getQualificationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getQualificationDate().compareTo(o.getQualificationDate()));
            }
            if (this.getQualificationComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getQualificationComments().compareTo(o.getQualificationComments()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
            if (this.getRemoteId() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRemoteId().compareTo(o.getRemoteId()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// DeclaredDocumentReference.java merge-point
}