/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import liquibase.change.Change;
import liquibase.change.ChangeMetaData;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.servicelocator.ServiceLocator;

public class ChangeFactory {
    private static ChangeFactory instance;
    private Map<String, SortedSet<Class<? extends Change>>> registry = new ConcurrentHashMap<String, SortedSet<Class<? extends Change>>>();
    private Map<Class<? extends Change>, ChangeMetaData> metaDataByClass = new ConcurrentHashMap<Class<? extends Change>, ChangeMetaData>();

    private ChangeFactory() {
    }

    private void init() {
        Class<Change>[] classes;
        Class<Change>[] classArray = classes = ServiceLocator.getInstance().findClasses(Change.class);
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<Change> clazz = classArray[n2];
            this.register(clazz);
            ++n2;
        }
    }

    public static synchronized ChangeFactory getInstance() {
        if (instance == null) {
            instance = new ChangeFactory();
            instance.init();
        }
        return instance;
    }

    public static void reset() {
        instance = null;
    }

    public void register(Class<? extends Change> changeClass) {
        try {
            Change instance = changeClass.newInstance();
            ChangeMetaData metaData = this.getChangeMetaData(instance);
            String name = metaData.getName();
            if (this.registry.get(name) == null) {
                this.registry.put(name, new TreeSet<Class<? extends Change>>(new Comparator<Class<? extends Change>>(){

                    @Override
                    public int compare(Class<? extends Change> o1, Class<? extends Change> o2) {
                        try {
                            return -1 * new Integer(ChangeFactory.this.getChangeMetaData(o1.newInstance()).getPriority()).compareTo(ChangeFactory.this.getChangeMetaData(o2.newInstance()).getPriority());
                        }
                        catch (Exception e) {
                            throw new UnexpectedLiquibaseException(e);
                        }
                    }
                }));
            }
            this.registry.get(name).add(changeClass);
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public ChangeMetaData getChangeMetaData(Change change) {
        if (!this.metaDataByClass.containsKey(change.getClass())) {
            this.metaDataByClass.put(change.getClass(), change.createChangeMetaData());
        }
        return this.metaDataByClass.get(change.getClass());
    }

    public void unregister(String name) {
        this.registry.remove(name);
    }

    public Map<String, SortedSet<Class<? extends Change>>> getRegistry() {
        return Collections.unmodifiableMap(this.registry);
    }

    public Set<String> getDefinedChanges() {
        return Collections.unmodifiableSet(this.registry.keySet());
    }

    public void clear() {
        this.registry.clear();
        this.metaDataByClass.clear();
    }

    public Change create(String name) {
        SortedSet<Class<? extends Change>> classes = this.registry.get(name);
        if (classes == null) {
            return null;
        }
        try {
            return (Change)((Class)classes.iterator().next()).newInstance();
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public String[] getAllChangeNamespaces() {
        HashSet<String> namespaces = new HashSet<String>();
        for (String changeName : this.getDefinedChanges()) {
            Change change = this.create(changeName);
            namespaces.add(change.getSerializedObjectNamespace());
        }
        return namespaces.toArray(new String[namespaces.size()]);
    }
}

