/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.exportactions;

import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportContext;
import fr.ifremer.tutti.service.genericformat.exportactions.ExportTechnicalActionSupport;
import fr.ifremer.tutti.service.referential.ReferentialTemporarySpeciesService;
import fr.ifremer.tutti.service.referential.csv.SpeciesRow;
import fr.ifremer.tutti.service.referential.producer.CsvProducerForTemporarySpecies;
import java.util.List;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ExportReferentialSpeciesAction
extends ExportTechnicalActionSupport {
    private final ReferentialTemporarySpeciesService referentialTemporarySpeciesService;

    public ExportReferentialSpeciesAction(ReferentialTemporarySpeciesService referentialTemporarySpeciesService) {
        this.referentialTemporarySpeciesService = referentialTemporarySpeciesService;
    }

    @Override
    public void execute(GenericFormatExportContext exportContext) {
        List<Species> temporarySpeciess = this.referentialTemporarySpeciesService.getTemporarySpeciess();
        exportContext.increments(I18n.t((String)"tutti.service.genericFormat.export.exportTemporarySpecies", (Object[])new Object[]{temporarySpeciess.size()}));
        try {
            CsvProducerForTemporarySpecies producerForTemporarySpecies = exportContext.getProducerForTemporarySpecies();
            List<SpeciesRow> dataToExport = producerForTemporarySpecies.getDataToExport(temporarySpeciess);
            producerForTemporarySpecies.write(dataToExport);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException("Could not export temporary species", (Throwable)e);
        }
    }
}

