/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.io.InputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.engine.api.DataExtractionFormatInfo;
import org.eclipse.birt.report.engine.api.EmitterInfo;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IDataExtractionTask;
import org.eclipse.birt.report.engine.api.IDatasetPreviewTask;
import org.eclipse.birt.report.engine.api.IDocumentWriter;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.IRunnable;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class ReportEngine
implements IReportEngine {
    protected static Logger logger = Logger.getLogger(IReportEngine.class.getName());
    protected IReportEngine engine;

    public ReportEngine(EngineConfig config) {
        try {
            Platform.startup(config);
        }
        catch (BirtException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        Object factory = Platform.createFactoryObject("org.eclipse.birt.report.engine.ReportEngineFactory");
        if (factory instanceof IReportEngineFactory) {
            this.engine = ((IReportEngineFactory)factory).createReportEngine(config);
        }
        if (this.engine == null) {
            System.out.println("Can not load the report engine");
        }
    }

    @Override
    public Object getRootScope() {
        return this.engine.getRootScope();
    }

    @Override
    public void changeLogLevel(Level newLevel) {
        this.engine.changeLogLevel(newLevel);
    }

    @Override
    public EngineConfig getConfig() {
        return this.engine.getConfig();
    }

    @Override
    public IReportRunnable openReportDesign(String designName) throws EngineException {
        return this.engine.openReportDesign(designName);
    }

    @Override
    public IReportRunnable openReportDesign(ReportDesignHandle designHandle) throws EngineException {
        return this.engine.openReportDesign(designHandle);
    }

    @Override
    public IReportRunnable openReportDesign(InputStream designStream) throws EngineException {
        return this.engine.openReportDesign(designStream);
    }

    @Override
    public IReportRunnable openReportDesign(String name, InputStream designStream) throws EngineException {
        return this.engine.openReportDesign(name, designStream);
    }

    @Override
    public IRunAndRenderTask createRunAndRenderTask(IReportRunnable reportRunnable) {
        return this.engine.createRunAndRenderTask(reportRunnable);
    }

    @Override
    public IGetParameterDefinitionTask createGetParameterDefinitionTask(IRunnable reportRunnable) {
        return this.engine.createGetParameterDefinitionTask(reportRunnable);
    }

    @Override
    public IGetParameterDefinitionTask createGetParameterDefinitionTask(IReportRunnable reportRunnable) {
        return this.engine.createGetParameterDefinitionTask(reportRunnable);
    }

    @Override
    public String[] getSupportedFormats() {
        return this.engine.getSupportedFormats();
    }

    @Override
    public EmitterInfo[] getEmitterInfo() {
        return this.engine.getEmitterInfo();
    }

    @Override
    public String getMIMEType(String format) {
        return this.engine.getMIMEType(format);
    }

    @Override
    public void destroy() {
        if (this.engine != null) {
            this.engine.destroy();
            this.engine = null;
        }
    }

    @Override
    public IRunTask createRunTask(IReportRunnable reportRunnable) {
        return this.engine.createRunTask(reportRunnable);
    }

    @Override
    public IRenderTask createRenderTask(IReportDocument reportDocument) {
        return this.engine.createRenderTask(reportDocument);
    }

    @Override
    public IReportDocument openReportDocument(String fileName) throws EngineException {
        return this.engine.openReportDocument(fileName);
    }

    @Override
    public IDataExtractionTask createDataExtractionTask(IReportDocument reportDocument) {
        return this.engine.createDataExtractionTask(reportDocument);
    }

    @Override
    public void shutdown() {
        this.engine.shutdown();
    }

    @Override
    public IReportDocument openReportDocument(String systemId, String fileName) throws EngineException {
        return this.engine.openReportDocument(systemId, fileName);
    }

    @Override
    public IReportRunnable openReportDesign(String designName, IResourceLocator locator) throws EngineException {
        return this.engine.openReportDesign(designName, locator);
    }

    @Override
    public IReportRunnable openReportDesign(String name, InputStream designStream, IResourceLocator locator) throws EngineException {
        return this.engine.openReportDesign(name, designStream, locator);
    }

    @Override
    public IReportRunnable openReportDesign(String name, InputStream designStream, Map options) throws EngineException {
        return this.engine.openReportDesign(name, designStream, options);
    }

    @Override
    public IReportDocument openReportDocument(String fileName, IResourceLocator locator) throws EngineException {
        return this.engine.openReportDocument(fileName, locator);
    }

    @Override
    public IReportDocument openReportDocument(String systemId, String fileName, IResourceLocator locator) throws EngineException {
        return this.engine.openReportDocument(systemId, fileName, locator);
    }

    @Override
    public IReportDocument openReportDocument(String systemId, String fileName, Map options) throws EngineException {
        return this.engine.openReportDocument(systemId, fileName, options);
    }

    @Override
    public IReportDocument openReportDocument(String systemId, IDocArchiveReader reader, Map options) throws EngineException {
        return this.engine.openReportDocument(systemId, reader, options);
    }

    @Override
    public Logger getLogger() {
        return this.engine.getLogger();
    }

    @Override
    public void setLogger(Logger logger) {
        this.engine.setLogger(logger);
    }

    @Override
    public IRenderTask createRenderTask(IReportDocument reportDocument, IReportRunnable reportRunnable) {
        return this.engine.createRenderTask(reportDocument, reportRunnable);
    }

    @Override
    public DataExtractionFormatInfo[] getDataExtractionFormatInfo() {
        return this.engine.getDataExtractionFormatInfo();
    }

    @Override
    public IDocumentWriter openDocumentWriter(IArchiveFile file) throws EngineException {
        return this.engine.openDocumentWriter(file);
    }

    @Override
    public String getVersion() {
        return this.engine.getVersion();
    }

    @Override
    public IEngineTask createEngineTask(String taskName) throws EngineException {
        return this.engine.createEngineTask(taskName);
    }

    @Override
    public IDatasetPreviewTask createDatasetPreviewTask() throws EngineException {
        return this.engine.createDatasetPreviewTask();
    }
}

